#!/usr/bin/perl
#
# viewedithours.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: viewedithours.cgi,v 1.19 2001/08/29 22:22:45 adam Exp $

require 'etc/timesheet.conf';
require 'lib/hours-funcs.pl';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

my $dead = '';
my $function;
my $dummy;

my $javave =<<EOT;

function jump_cut () {
   myrec = eval(parent.right.document.loghours.record_number.value);
   totrec = eval(parent.right.document.loghours.totalrecords.value);
   if (isNaN(myrec)) {
       alert("The record number must be a number!");
   }

   if ( (myrec > totrec) || (myrec <= 0)) {
       alert("Hmmm. Can't find record number " +  myrec + 
	     " because there are only " + totrec + " records!" );
       parent.right.document.loghours.record_number.value = 
	   eval(parent.right.document.loghours.recordnumber.value);
   }
   else {
      document.loghours.submit();
   }
}

EOT

#&time_head($Conf::VIEWEDIT_HOURS);
    print header,
    start_html('-title'      => $Conf::VIEWEDIT_HOURS,
	      '-BACKGROUND' => $Conf::BACKGROUND,
	      '-script'     => $Conf::JAVA_HELP . $javave,     
	      '-BGCOLOR'    => $Conf::BGCOLOR,
	     );

&help_button_big('VIEWEDIT_HOURS');

if ( param('approve.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;

    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }

    &initialize_state(\%state, $dbconn);
    my $current_hours = $state{'recordnumber'};
    if ( ! $state{'super'} ) {
	&error("Non-administrative users cannot approve hours");
    }
    
    # We want approve to go right to the next record when done
    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...
    if ( $state{'nextrecord'} != 0 ) {
	$state{'prevrecord'} = $state{'recordnumber'};
	$state{'recordnumber'} = $state{'nextrecord'};    
	$state{'nextrecord'} = ($state{'recordnumber'} + 1);
	if ( $state{'nextrecord'} > $state{'totalrecords'} ) {
	    $state{'nextrecord'} = 0;
	}
    }

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    my $current_hours_id = $hours{$current_hours};
    %hours_info = &hours_join($dbconn, $current_hours_id);

    $hours_info{'fkjob_id'} = param('fkjob_id') if param('fkjob_id');
    $hours_info{'date_entered'} = param('date_entered') if param('date_entered'); 
    $hours_info{'date_entered'} = &dbdate($hours_info{'date_entered'});
    $hours_info{'time_in'} = param('time_in') if param('time_in');
    $hours_info{'time_out'} = param('time_out') if param('time_out');
    $hours_info{'hours_description'} = param('hours_description') if param('hours_description');
    $hours_info{'comment'} = param('comment') if param('comment');
    $hours_info{'parking'} = param('parking');
    $hours_info{'total_hours'} = param('total_hours') if param('total_hours');
        
    $hours_info{'billable'} = 0 if param('billable') eq 'n';
    $hours_info{'billable'} = 1 if param('billable') eq 'y';
    if ( param('approved') eq 'y' ) {
	$hours_info{'approval_date'} = &dbdate_today;
    } else {
	$hours_info{'approval_date'} = "$Conf::DUMMY_APPROVAL_DATE";
    }
    

    &scrub_hash(\%hours_info);

    # Make our SQL
    $sql = "UPDATE hours SET ";
    $sql .= "date_entered = '$hours_info{'date_entered'}', ";
    $sql .= "time_in = '$hours_info{'time_in'}', ";
    $sql .= "fkjob_id = '$hours_info{'fkjob_id'}', ";
    $sql .= "time_out = '$hours_info{'time_out'}', ";
    $sql .= "hours_description = '$hours_info{'hours_description'}', ";
    $sql .= "comment = '$hours_info{'comment'}', ";
    $sql .= "parking = $hours_info{'parking'}, ";
    $sql .= "total_hours = $hours_info{'total_hours'}, ";
    $sql .= "billable = '$hours_info{'billable'}', ";
    $sql .= "approval_date = '$hours_info{'approval_date'}' ";
    $sql .= "WHERE hours_id = $current_hours_id;";

	
    $reply = $dbconn->query($sql);
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Update error for $current_hours_id: $oops", $sql);
    }

#########################
    &approve_hours($dbconn, $current_hours_id);	
    
    $state{'hours_id'} = $hours{$state{'recordnumber'}};

    %hours_info = &hours_join($dbconn, $state{'hours_id'});
    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }

    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }


    ### HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});
    &reset_all_params;
    &admin_show_hours_form(%state);

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

} elsif ( param('apply.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;
    my $reply;
    my $sql;
    my $current_hours_id;
    &print_form_head;
    
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }    
    
    &initialize_state(\%state, $dbconn);
    my $current_hours = $state{'recordnumber'};
    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    $current_hours_id = $hours{$current_hours};
    %hours_info = &hours_join($dbconn, $current_hours_id);

    # security check
    if ( ! $state{'super'} && 
	 $hours_info{'fkpersonnel_id'} ne $state{'remote_user'} ) {
	&error("Non-administrative users can only modify their own hours");
    }

    $hours_info{'fkjob_id'} = param('fkjob_id') if param('fkjob_id');
    $hours_info{'date_entered'} = param('date_entered') if param('date_entered'); 
    $hours_info{'date_entered'} = &dbdate($hours_info{'date_entered'});
    $hours_info{'time_in'} = param('time_in') if param('time_in');
    $hours_info{'time_out'} = param('time_out') if param('time_out');
    $hours_info{'hours_description'} = param('hours_description') if param('hours_description');
    $hours_info{'comment'} = param('comment') if param('comment');
    $hours_info{'parking'} = param('parking');
    $hours_info{'total_hours'} = param('total_hours') if param('total_hours');

    
    $hours_info{'billable'} = 0 if param('billable') eq 'n';
    $hours_info{'billable'} = 1 if param('billable') eq 'y';
    if ( param('approved') eq 'y' ) {
	$hours_info{'approval_date'} = &dbdate_today;
    } else {
	$hours_info{'approval_date'} = "$Conf::DUMMY_APPROVAL_DATE";
    }
    

    &scrub_hash(\%hours_info);

    # Make our SQL
    $sql = "UPDATE hours SET ";
    $sql .= "date_entered = '$hours_info{'date_entered'}', ";
    $sql .= "time_in = '$hours_info{'time_in'}', ";
    $sql .= "fkjob_id = '$hours_info{'fkjob_id'}', ";
    $sql .= "time_out = '$hours_info{'time_out'}', ";
    $sql .= "hours_description = '$hours_info{'hours_description'}', ";
    $sql .= "comment = '$hours_info{'comment'}', ";
    $sql .= "parking = $hours_info{'parking'}, ";
    $sql .= "total_hours = $hours_info{'total_hours'}, ";
    $sql .= "billable = '$hours_info{'billable'}', ";
    $sql .= "approval_date = '$hours_info{'approval_date'}' ";
    $sql .= "WHERE hours_id = $current_hours_id;";


	
    $reply = $dbconn->query($sql);
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Update error for $current_hours_id: $oops", $sql);
    }
    
    $state{'hours_id'} = $hours{$state{'recordnumber'}};
    %hours_info = &hours_join($dbconn, $state{'hours_id'});
    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }

    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }

    ###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});

    &reset_all_params;
    if ( $state{'super'} ) {
	&admin_show_hours_form(%state);
    } else {
	&user_show_hours_form(%state);
    }

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";
    
  } elsif ( param('delete.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;

    my $current_hours_id;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }

    &initialize_state(\%state, $dbconn);
    my $current_hours = $state{'recordnumber'};
    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});

    $current_hours_id = $hours{$current_hours};

    my $reply = $dbconn->query("DELETE from $state{'searchtable'} where hours_id = $current_hours_id;");
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_hours_id: $oops");
    }
    $reply = $dbconn->query("UPDATE $Conf::HOURS_DB set del = 'y' where hours_id = $current_hours_id;");
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Update error for $current_hours_id: $oops");
    }
    
    $state{'totalrecords'} = $state{'totalrecords'} - 1;
    if ( $state{'totalrecords'} == 0 ) {
	# give them a search form
	my @supers = &list_supervisors;
	$state{'supers'} = \@supers;
	if ( $state{'super'} ) {
	    &admin_search_hours_form(%state);
	} else {
	    &user_search_hours_form(%state);
	}
	&searchbutton;
	&write_state(%state);
	print "</FORM>";
	exit;

    }
    if ( $state{'totalrecords'} < $state{'recordnumber'} ) {
	$state{'recordnumber'} = $state{'totalrecords'};
	$state{'nextrecord'} = 0;
	$state{'prevrecord'} = ($state{'totalrecords'} - 1);
    }
    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    $state{'hours_id'} = $hours{$state{'recordnumber'}};
    %hours_info = &hours_join($dbconn, $state{'hours_id'});
    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }

    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }

    ###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});

    &reset_all_params;
    if ( $state{'super'} ) {
	&admin_show_hours_form(%state);
    } else {
	&user_show_hours_form(%state);
    }

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

    exit;
}
elsif ( param('prevrecord.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }

    &initialize_state(\%state, $dbconn);

    # let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'prevrecord'};    
    $state{'prevrecord'} = ($state{'recordnumber'} - 1);

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    $state{'hours_id'} = $hours{$state{'recordnumber'}};
    %hours_info = &hours_join($dbconn, $state{'hours_id'});

    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }

    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }

    ###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});
    &reset_all_params;
    
    if ( $state{'super'} ) {
	&admin_show_hours_form(%state);
    } else {
	&user_show_hours_form(%state);
    }

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

} elsif ( param('nextrecord.x') || param('approve.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;

    # OK, if we are doing an "Approve", we basically perform a
    # next record with one intermediate step.  So we just set a var
    # here to use in some conditionals later on.

    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend vewedithours: $oops");
    }

    &initialize_state(\%state, $dbconn);

    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...
    
    $state{'prevrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'nextrecord'};    
    $state{'nextrecord'} = ($state{'recordnumber'} + 1);
    if ( $state{'nextrecord'} > $state{'totalrecords'} ) {
	$state{'nextrecord'} = 0;
    }

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});

    $state{'hours_id'} = $hours{$state{'recordnumber'}};

    %hours_info = &hours_join($dbconn, $state{'hours_id'});
    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }

    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }

    ###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});
    &reset_all_params;

    if ( $state{'super'} ) {
	&admin_show_hours_form(%state);
    } else {
	&user_show_hours_form(%state);
    }

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";


} elsif ( param('searchsubmit.x') ) {
    my %state;
    my $searchtable;
    my $dbconn;
    my $result;
    my $oops;
    my %hours;
    my $var;
				# the "short" form uses a different CGI
    &print_form_head unless ( param('output') eq "short" );
    
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	$oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops");
    }

    &initialize_state(\%state, $dbconn);

    # drop any old searches from temp storage in the DB, allow errors
    $result = $dbconn->query("DROP TABLE temp_hours_search_$state{'remote_user'};");
    
    # Get all the state variables in shape for the search
    $state{'approved'} = param('approved') unless(param('approved') eq "any");
    $state{'fkclient_id'} = param('fkclient_id') unless(param('fkclient_id') eq "any");
    $state{'fksupervisor_id'} = param('fksupervisor_id') unless(param('fksupervisor_id') eq "any");	
    $state{'downloaded'} = "n" if ( param('downloaded') eq "n");
    $state{'downloaded'} = "y" if ( param('downloaded') eq "y");
    $state{'billable'} = "n" if ( param('billable') eq "n");
    $state{'billable'} = "y" if ( param('billable') eq "y");

    # if not admin, then they can only search for their own hours
    if ( $state{'super'} ) {
	$state{'fkpersonnel_id'} = param('fkpersonnel_id') if param('fkpersonnel_id');
    } else {
	$state{'fkpersonnel_id'} = $state{'remote_user'};
    }
    $state{'fkjob_id'} = param('fkjob_id') if param('fkjob_id');
    $state{'hours_id'} = param('hours_id') if param('hours_id');

    # remember to condition our date fields properly
    $state{'to_date'} = &dbdate(param('to_date'));
    $state{'from_date'} = &dbdate(param('from_date'));

    # run the search and get our temp storage table in return
    $state{'searchtable'} = &search_hours(%state);
    
    # fill up a hash with our results
    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    
    if ( ! $hours{'1'} ) {
	print "<H1>No Matches Found</H1>";
				# remember, we skipped this above for short
	( param('output') eq "short" ) && &print_form_head;
	my @supers = &list_supervisors;
	$state{'supers'} = \@supers;
	if ( $state{'super'} ) {
	    &admin_search_hours_form(%state);
	} else {
	    &user_search_hours_form(%state);
	}
	&searchbutton;
	&write_state(%state);
	print "</FORM>";
	exit;
    }
    # if we want the short listing do this
    if ( param('output') eq "short" ) {
	my $key;
	my %short_hours;
	my $sq = "SELECT * FROM $state{'searchtable'}, hours, client, job WHERE ";
	$sq .= "$state{'searchtable'}.hours_id = hours.hours_id AND hours.fkclient_id ";
	$sq .= "= client.client_id AND hours.fkjob_id = job.job_id;";

	my $hours_munge = $dbconn->query("$sq");
	if ( ! $hours_munge ) {
	    my $oops = $dbconn->errorstring;
	    &error("Error getting data: $oops", $sq);
	}

	print "<CENTER>";
	print "<IMG SRC=\"images/viewedithours-big.gif\" BORDER=0 ALT=\"[View/Edit Hours]\">";
	print "</CENTER>";

	print "<FORM ACTION=\"updatehours.cgi\" METHOD=\"GET\">";
	print hidden('-name'=>'search_url',
		     '-value'=>self_url,
		     '-override'=>1);
	print "<TABLE BORDER=1 BGCOLOR=\"#AACCCC\">";
	print "<TR><TH>Job ID</TH><TH>Description</TH><TH>User</TH><TH>Hours</TH><TH>Date</TH></TR>";
	my $numlines = $hours_munge->get_num_rows;
	my $i;
	my %hhash;
	$i = 0;
	my $hours_sum = 0;
	my $hours_bg_color = "#CCCCCC";
	while ($i < $numlines ) {
	    %hhash = $hours_munge->get_row($i);
	    my $hours_url = 
		"$Conf::TIMESHEET_URL/viewedithours.cgi?searchsubmit.x=1&hours_id=$hhash{'hours_id'}";
	    my $job_url = 
		"$Conf::TIMESHEET_URL/vieweditjobs.cgi?searchsubmit.x=1&job_id=$hhash{'fkjob_id'}";
	    
	    if ( $hours_bg_color eq "#FFFFFF" ) {
		$hours_bg_color = "#CCCCCC";
	    } else {
		$hours_bg_color = "#FFFFFF";
	    }

	    my $hstatus = "n";
	    if ( $hhash{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
		$hstatus = "y";
	    }
	    my %yes_no_labels = ('y', 'Yes', 'n', 'No');
	    my $approved_popup =
		popup_menu('-name'=> 'hours' . $hhash{'hours_id'} . 'set',
			   '-values'=> ['y', 'n'],
			   '-default'=> "$hstatus",
			   '-override'=> 1,
			   '-labels'=> \%yes_no_labels);
	    my $hidden_stat =
		hidden(
		       '-name'=> 'hours' . $hhash{'hours_id'} . 'status',
		       '-value'=>$hstatus);
	    
	    print "<TR BGCOLOR=\"$hours_bg_color\">\n";
	    if ( $state{'super'} ) {
		print "<TD HALIGN=CENTER><A href=\"$job_url\">$hhash{'fkjob_id'}</A></TD>";
	    } else {
		print "<TD BGCOLOR=\"$hours_bg_color\" halign=center>$hhash{fkjob_id}</TD>";
	    }
	    print "<TD><A HREF=\"$hours_url\">$hhash{'hours_description'}</A></TD>";
	    print "<TD>$hhash{'fkpersonnel_id'}</TD>";
	    print "<TD>$hhash{'total_hours'}</TD>";
	    print "<TD>$hhash{'date_entered'}</TD>";
	    print "</TR>";
	    print "<TR BGCOLOR=\"$hours_bg_color\">";
	    print "<TD COLSPAN=\"2\">";
	    print "Approved: $hidden_stat $approved_popup</TD>";
	    print "</TD><TD COLSPAN=3>";
	    if ( $hhash{'billable'} ) {
		print "Billable";
	    } else {
		print "Non-Billable";
	    }

	    if ( $hhash{'downloaded'} eq 'y' ) {
		print "&nbsp;<FONT size=\"-1\" COLOR=\"#CC4444\">Downloaded</FONT>";
	    }

	    print "</TD>";
	    print "<TR>\n";
	    $hours_sum = $hours_sum + $hhash{'total_hours'};
	    $i++;
	}
	
	print "<TR BGCOLOR=\"#CCAAAA\"><TD COLSPAN=3 HALIGN=RIGHT>Total Hours:</TD>" .
	    "<TD COLSPAN=2>$hours_sum</TD></TR>";
	print "</TABLE>";
	print '<INPUT TYPE="submit" NAME="Update Jobs" VALUE="Update Hours">';
	
	
    } else {
	# some wooparse SQL to get all the info for our first record
	my %hours_info = &hours_join($dbconn, $hours{'1'});

	# add these to our state hash
	foreach $var (keys %hours_info ) {
	    $state{$var} = $hours_info{$var};
	}
	if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
	    $state{'approved'} = "y";
	} else {
	    $state{'approved'} = "n";
	}
	
	if ( $state{'billable'} == 1 ) {
	    $state{'billable'} = "y";
	} else {
	    $state{'billable'} = "n";
	}
	
	###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
	param('billable', $state{'billable'});
	param('approved', $state{'approved'});
	$state{'date_entered'} = &formdate($state{'date_entered'});
	$state{'recordnumber'} = 1;
	my @recs = keys %hours;
	$state{'totalrecords'} = $#recs + 1;
	if ( $state{'totalrecords'} == $state{'recordnumber'} ) {
	    $state{'nextrecord'} = 0;
	}
	else{
	    $state{'nextrecord'} = ($state{'recordnumber'} +1);
	}

	if ( $state{'super'} ) {
	    &admin_show_hours_form(%state);
	} else {
	    &user_show_hours_form(%state);
	}
	&write_state(%state);
	
	&print_hours_commands(%state);
	&print_record_nav('totalrecords'=>"$state{'totalrecords'}",
			  'recordnumber'=>"$state{'recordnumber'}",
			  'nextrecord'=>"$state{'nextrecord'}");
	print "</FORM>";
    }
    
} elsif ( param('recordnumber') != param('record_number') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %hours;
    my %hours_info;
    my $var;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }

    &initialize_state(\%state, $dbconn);
    $state{'record_number'} = param('record_number');

    # let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'record_number'} + 1;
    $state{'prevrecord'} = ($state{'record_number'} - 1);
    $state{'recordnumber'} = $state{'record_number'};
    if ( $state{'nextrecord'} > $state{'totalrecords'} ) {
	$state{'nextrecord'} = 0;
    }

    %hours = &get_hours_search_result($dbconn, $state{'searchtable'});
    $state{'hours_id'} = $hours{$state{'recordnumber'}};
    %hours_info = &hours_join($dbconn, $state{'hours_id'});
    
    foreach $var (keys %hours_info ) {
	$state{$var} = $hours_info{$var};
    }
    if ( $state{'approval_date'} ne "$Conf::DUMMY_APPROVAL_DATE" ) {
        $state{'approved'} = "y";
    } else {
        $state{'approved'} = "n";
    }
    
    if ( $state{'billable'} == 1 ) {
        $state{'billable'} = "y";
    } else {
        $state{'billable'} = "n";
    }
    
    ###HACK HACK HACK TO GET AROUND CGI.PM REFILLING DEFAULT
    param('billable', $state{'billable'});
    param('approved', $state{'approved'});
    $state{'date_entered'} = &formdate($state{'date_entered'});
    &reset_all_params;
    
    if ( $state{'super'} ) {
	&admin_show_hours_form(%state);
    } else {
	&user_show_hours_form(%state);
    }

    &write_state(%state);
    &print_hours_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

    
} else {				# The bottom of the basket, print new form
    my %state;
    my $oops;
    my $dbconn;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my @supers = &list_supervisors($dbconn);
    $state{'supers'} = \@supers;
    &print_form_head;
    
    &reset_all_params;
    param('date_entered', '');
    param('to_date', '');
    param('from_date', '');
    param('billable','any');
    param('approved','any');
    param('downloaded', 'n');
    if ( $state{'super'} ) {
	&admin_search_hours_form('client_id'=>"$state{'client_id'}",
				 'client_name'=>"$state{'client_name'}",
				 'remote_user'=>"$state{'remote_user'}",
				 'supers'=>\@supers);
    } else {
	&user_search_hours_form('client_id'=>"$state{'client_id'}",
				'client_name'=>"$state{'client_name'}",
				'remote_user'=>"$state{'remote_user'}",
				'supers'=>\@supers);
    }
    &searchbutton;
    &write_state(%state);
    print "</FORM>";    
}

sub print_form_head {
    print <<EOT;
<CENTER>
<IMG SRC="images/viewedithours-big.gif" BORDER=0 ALT="[View/Edit Hours]">
</CENTER>
<FORM NAME="loghours" METHOD="POST" ACTION="viewedithours.cgi">
EOT
}

sub searchbutton {
    print "<INPUT TYPE=\"image\" NAME=\"searchsubmit\" SRC=\"images/search.gif\" BORDER=\"0\">";
}

