#!/usr/bin/perl 
# Take a file with data for Acceptance or Release test data in it
# and turn it into SGML tables for insertion into a document
#
# Caveats: the flat text file must start with a blank line
#
# Greg Gallagher
# ggallag@onShore.com
# $Date: 1999/03/26 16:51:38 $
# $Revision: 1.1 $

use strict;

my $testfile = $ARGV[0];
my $line;
my @fields;
my $startoftests = 1;
my $id;

if ($ARGV[0] eq '') {
	print "usage: releasetests.pl <file>\n";
	print "	- where <file> is a flat-text database of acceptance tests\n";
	exit 1;
}

open(TESTS, "$testfile") || die "Couldn't open $testfile: $!\n";

while($line = <TESTS>) {

	chop($line);

	@fields = split(/:/, $line);

   if($line eq '') {
		$line = <TESTS>;
		@fields = split(/:/, $line);
		if(!$startoftests) {
			print "</tbody>\n</table>\n";
		}
		$startoftests = 0;
		$id = 0;
		print "\n\n<sect1 id=\"release$fields[0]\">\n";
		print "\n<title>$fields[0] Tests</title>\n";
		print "<para>\nEach of the tests below relates to $fields[0] test cases\n";
		print "<table frame=\"all\">\n";
		print "<title>$fields[0] Test Cases</title>\n";
		print "<tgroup cols=\"4\" colsep=\"1\" rowsep=\"1\">\n";
		print "<colspec align=\"left\">";
		print "<thead>\n";
		print "<row>\n";
		print "<entry align=\"center\" valign=\"middle\">TESTCASE</entry>\n";
		print "<entry align=\"center\" valign=\"middle\">EVENTID</entry>\n";
		print "<entry align=\"center\" valign=\"middle\">ACTION</entry>\n";
		print "<entry align=\"center\" valign=\"middle\">EXPECTED_RESULTS</entry>\n";
		print "</row>\n";
		print "</thead>\n<tbody>\n";
	}

	$id++;
	print "<row>\n";
	print "<entry align=\"center\" valign=\"middle\">$fields[0]</entry>\n";
	print "<entry align=\"center\" valign=\"middle\">$id</entry>\n";
	print "<entry align=\"left\" valign=\"middle\">$fields[1]</entry>\n";
	print "<entry align=\"left\" valign=\"middle\">$fields[2]</entry>\n";
	print "</row>\n";

} # end of while()

print "</tbody>\n</table>\n";

exit 0;


