#!/usr/bin/perl
#
# addnewclient.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
#
# $Id: addnewclient.cgi,v 1.8 2001/08/29 22:22:45 adam Exp $

use CGI qw(:standard);
require 'etc/timesheet.conf';
require 'lib/client-funcs.pl';
require 'lib/common-funcs.pl';

&print_head;

if (param('create.x')) {
    
    # let's take care of our input
    my %new;
    my $dbconn;
    
    print "$new{'client_name'}<BR><BR>\n\n";
    $new{'client_id'} = param('client_id') if param('client_id');
    if(!$new{'client_id'}){
	&error("Client ID MUST be SPECIFIED AND DERIVED FROM ACCOUNTING DB");
    }
    $new{'client_name'} = param('client_name') if param('client_name');
    $new{'client_name'} =~ s/\'/''/g;
    $new{'default_bill_rate'} = param('default_bill_rate') if param('default_bill_rate');
    
    $new{'default_approved'} = 0 if param('default_approved') eq 'n';
    $new{'default_approved'} = 1 if param('default_approved') eq 'y';
    
    
    #Check format of input
    unless($new{'client_id'} =~ /\d*/)
    {
	&error("Client ID must be all numbers");
    }
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB, sql_escape_data);
    if(!$dbconn->is_ok){
	my $oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops\n");
    }
    
    if($new{'client_id'}){
	
	unless($dbconn->insert_record($Conf::CLIENT_DB_KEY,
				      $Conf::CLIENT_DB,
				      \%new))
	{
	    my $oops = $dbconn->errorstring;
	    &error("Error Inserting Client Record: $oops\n");
	}
	$new{'client_name'} =~ s/\'\'/'/g;
	print "<H3>Client: $new{'client_name'} inserted with ClientID: $new{'client_id'}</H3>";
	
    }else{
	my $result = $dbconn->insert_record_seq($Conf::CLIENT_DB_KEY,
						$Conf::CLIENT_DB,
						\%new);
	if(!$result){
	    my $oops = $dbconn->errorstring;
	    &error("Error Inserting Client Record: $oops\n");
	}
	print "<H3>Client: $new{'client_name'} inserted with ClientID: $result</H3>";
    }
    &reset_all_params;
    &new_client_form;
    &print_create_button;
    
}else{
    
    &new_client_form;
    &print_create_button;
    
}


sub print_create_button {

    print <<EOT;
<INPUT NAME="create" TYPE="image" SRC="images/createnewclient.gif"BORDER=0 ALT="[Create New Client]">
EOT
}

sub print_head {

&time_head("Add New Client");
&help_button_big('Add New Client');
print <<EOT;
<CENTER>
<IMG SRC="images/clientfunctions-big.gif" BORDER=0 ALT=[Add New Client]>
</CENTER>
<FORM NAME=addnewclient METHOD="POST" ACTION="addnewclient.cgi" TARGET="right">
EOT
}

