
CXXSRCS = y_tab.cc lex_yy.cc idlerr.cc idlutil.cc idltype.cc-
	idlrepoId.cc idlscope.cc idlexpr.cc idlast.cc idlvalidate.cc-
	idldump.cc idlconfig.cc idlpython.cc idlc.cc

IDLMODULE_MAJOR   = 0
IDLMODULE_MINOR   = 1
IDLMODULE_VERSION = 0x2301# => CORBA 2.3, front-end 0.1
version=0.1.0

DIR_CXXMACROS = IDLMODULE_VERSION=""""$(IDLMODULE_VERSION)""""\
	OMNIIDL_EXECUTABLE\
	YY_ALWAYS_INTERACTIVE\
	USE_IDLERROR

.IFDEF ALPHA
DIR_ALPHA_CXXLINKFLAGS=/sysexe
DIR_ALPHA_CXXFLAGS=/float=ieee/ieee=under
.ELSE
DIR_VAX_CXXLINKFLAGS=,SYS$SYSTEM:SYS.STB/selective
DIR_VAX_CXXFLAGS=/float=ieee/ieee=under
.ENDIF
DIR_CXXLINKFLAGS = $(DIR_ALPHA_CXXLINKFLAGS)$(DIR_VAX_CXXLINKFLAGS)
DIR_CXXINCLUDES = /python_include
DIR_CXXFLAGS=$(DIR_ALPHA_CXXFLAGS)$(DIR_VAX_CXXFLAGS)\
/warn=(disable=codeunreachable)
SUBDIRS = cccp

all ::
	@ $(MakeSubdirs)

export ::
	@ $(MakeSubdirs)

OBJS = y_tab.obj lex_yy.obj idlerr.obj idlutil.obj idltype.obj \
	idlrepoId.obj idlscope.obj idlexpr.obj idlast.obj idlvalidate.obj \
	idldump.obj idlconfig.obj

PYOBJS = idlpython.obj

#############################################################################
#   Make rules for OpenVMS                                                  #
#############################################################################

# Only static linking is currently supported.

libname = _omniidlmodule
staticlib = $(libname).olb

OBJ_LIBS = sys$disk:[]$(staticlib)
OBJ_LIBS_DEPEND = sys$disk:[]$(staticlib)

omniidl=omniidl$(DebugSuffix).exe

all :: $(omniidl)

# MMS/DEFINE=file.mms ignores .ifdef statements and erroneously complains about
# macro redefinitions.

.ifdef VAX
IDLFLOAT_OBJS = $(staticlib)(idlfloat_vax)
.endif

LIB_OBJS = $(staticlib)(y_tab)\
	$(staticlib)(lex_yy)\
	$(staticlib)(idlerr)\
	$(staticlib)(idlutil)\
	$(staticlib)(idltype)\
	$(staticlib)(idlrepoId)\
	$(staticlib)(idlscope)\
	$(staticlib)(idlexpr)\
	$(staticlib)(idlast)\
	$(staticlib)(idlvalidate)\
	$(staticlib)(idldump)\
	$(staticlib)(idlconfig)\
	$(IDLFLOAT_OBJS)

$(omniidl) : $(PYOBJS) $(LIB_OBJS)
	@ $(CXXExecutable) sys$disk:[-]python$(DebugSuffix).opt/opt

export :: $(omniidl)
	@ $(ExportExecutable)


veryclean ::
	$(RM) *.mms

#############################################################################
#   Test executable                                                         #
#############################################################################

all :: $(idlc)

$(idlc) : idlc.obj $(staticlib)
	@ $(CXXExecutable) $(staticlib)/lib

.IFDEF VAX
idlfloat_vax.obj : idlfloat_vax.cc
	$(CxxCompile) "/Float=G_Float"
.ENDIF
