############################################################################
#    Copyright (C) 2008 by David Palacio                                   #
#    dpalacio@uninorte.edu.co                                              #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          #
############################################################################

module OkularPart
	def self.create( parent )
		offers = KDE::ServiceTypeTrader.self.query 'KParts/ReadOnlyPart', "(Library == 'okularpart')"
		factory = KDE::PluginLoader.new(offers[0].library).factory
		if factory
			part = factory.create('KParts::ReadOnlyPart', parent, nil, [], '')
			save part
			part.action_collection.action('show_leftpanel').checked = false
			return part
		end
		nil
	end
	def self.save( part )
		ac = part.action_collection
		@@settings = {}
		@@settings['show_leftpanel'] = ac.action('show_leftpanel').checked?
		@@settings['view_continuous'] = ac.action('view_continuous').checked?
		@@settings['view_fit_to_width'] = ac.action('view_fit_to_width').checked?
		@@settings['view_fit_to_page'] = ac.action('view_fit_to_page').checked?
	end
	def self.restore( part )
		if @@settings
			ac = part.action_collection
			ac.action('show_leftpanel').checked = @@settings['show_leftpanel']
			ac.action('view_continuous').checked = @@settings['view_continuous']
			ac.action('view_fit_to_width').checked = @@settings['view_fit_to_width']
			ac.action('view_fit_to_page').checked = @@settings['view_fit_to_page']
			@@settings = nil
		end
	end
end
