/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef RENAMEEVENT_H
#define RENAMEEVENT_H

#include "SlowEvent.h"
#include <string>
#include "List.h"

using std::string;

namespace Om {

class Patch;
class Node;
class TreeNode;
class Plugin;
class DisconnectNodeEvent;
class DisconnectPortEvent;


/** An event to remove and delete a Node.
 *
 * \ingroup engine
 */
class RenameEvent : public SlowEvent
{
public:
	RenameEvent(Request* request, const string& path, const string& name);
	~RenameEvent();

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	enum ErrorType { NO_ERROR, OBJECT_NOT_FOUND, OBJECT_EXISTS, OBJECT_NOT_RENAMABLE, INVALID_NAME };

	string    m_old_path;
	string    m_name;
	string    m_new_path;
	Patch*    m_parent_patch;
	TreeNode* m_treenode;
	ErrorType m_error;
};


} // namespace Om

#endif // RENAMEEVENT_H
