/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OBJECTSTORE_H
#define OBJECTSTORE_H

#include <string>
using std::string;

namespace Om {

class Patch;
class Node;
class Port;
class OmObject;

// FIXME: this is way, way, WAAY too slow

/** Utility functions for finding OmObjects.
 *
 * Slightly misnames, OmObjects aren't actually stored here, though they may
 * be in the future for optimisation (faster searching).
 */
class ObjectStore
{
public:
	static Patch* const    find_patch(const string& path);
	static Node*  const    find_node(const string& path);
	static Port*  const    find_port(const string& path);
	static OmObject* const find_object(const string& path);
};


} // namespace Om

#endif // OBJECTSTORE
