/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Maid.h"
#include "MaidObject.h"
#include <pthread.h>
#include <iostream>
using std::cout; using std::cerr; using std::endl;

namespace Om {


uint MaidObject::m_count = 0; // ew


Maid::Maid(size_t size, const timespec& rate)
: m_thread_exists(false),
  m_quit_flag(false),
  m_objects(size),
  m_rate(rate)
{
}


Maid::~Maid()
{
	stop();
	
	while (!m_objects.empty()) {
		MaidObject* obj = m_objects.pop();
		delete obj;
	}
}



/** Start the cleanup thread.
 */
void
Maid::start()
{
	pthread_create(&m_cleanup_thread, NULL, &Maid::cleanup_loop, this);
	m_thread_exists = true;
}


/** Destroy the cleanup thread.
 */
void
Maid::stop()
{
	if (m_thread_exists) {
		m_quit_flag = true;
		pthread_cancel(m_cleanup_thread);
		pthread_join(m_cleanup_thread, NULL);
		m_thread_exists = false;
	}
}


/** Push an event to be deleted.
 *
 * Realtime safe, to be called from Jack thread.
 */
void
Maid::push(MaidObject* obj)
{
	if (obj != NULL)
		m_objects.push(obj);
}	


// Private //


void*
Maid::cleanup_loop(void* m)
{
	return ((Maid*)m)->m_cleanup_loop();
}


void*
Maid::m_cleanup_loop()
{
	MaidObject* obj = NULL;
	
	while ( ! m_quit_flag) {
		nanosleep(&m_rate, NULL);
		
		while (!m_objects.empty()) {
			obj = m_objects.pop();
			delete obj;
		}
	}

	cout << "[Maid] Exiting maid thread." << endl;
	//pthread_exit(NULL);
	return NULL;
}


} // namespace Om

