/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PATCHWINDOW_H
#define PATCHWINDOW_H

#include <string>
#include <gtkmm.h>
#include <libglademm/xml.h>
#include <libglademm.h>
#include "OmGtkObject.h"
using std::string;

namespace LibOmClient {
class PatchModel;
class NodeModel;
class PortModel;
class ControlModel;
class MetadataModel;
}
using namespace LibOmClient;


namespace OmGtk {
	
class PatchController;
class OmPatchBayArea;
class LoadPluginWindow;
class NewSubpatchWindow;
class LoadSubpatchWindow;
class NewSubpatchWindow;
class NodeControlWindow;
class PatchDescriptionWindow;
class SubpatchModule;
class OmPort;


/** A window for a patch.
 *
 * \ingroup OmGtk
 */
class PatchWindow : public Gtk::Window
{
public:
	PatchWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& glade_xml);
	~PatchWindow();
	
	void patch_controller(PatchController* pc);

	OmPatchBayArea*     patch_bay() const            { return m_patch_bay; }
	PatchController*    patch_controller() const     { return m_patch_controller; }
	LoadPluginWindow*   load_plugin_window() const   { return m_load_plugin_window; }
	LoadSubpatchWindow* load_subpatch_window() const { return m_load_subpatch_window; }
	NewSubpatchWindow*  new_subpatch_window() const  { return m_new_subpatch_window; }

	void show_control_window();
	void show_description_window();
	void zoom_changed();
	void process_toggled();

	void enabled(bool e);

	Gtk::MenuItem* menu_view_control_window() { return m_menu_view_control_window; }

	bool visible() { return m_is_visible; }
	
	void show();
	void hide();
	bool on_delete_event(GdkEventAny* ev);
	
private:
	void event_save_patch();
	void event_save_patch_as();
	void event_close();
	void event_destroy();
	
	void event_show_add_plugin_win();
	void event_show_new_subpatch_win();
	void event_show_load_subpatch_win();

	PatchController*        m_patch_controller;
	OmPatchBayArea*         m_patch_bay;
	LoadPluginWindow*       m_load_plugin_window;
	NewSubpatchWindow*      m_new_subpatch_window;
	LoadSubpatchWindow*     m_load_subpatch_window;
	PatchDescriptionWindow* m_description_window;
	
	bool m_enable_signal;
	bool m_is_visible;
	bool m_position_stored;
	int  m_x;
	int  m_y;
	
	Gtk::MenuItem*       m_menu_file_save_patch;
	Gtk::MenuItem*       m_menu_file_save_patch_as;
	Gtk::MenuItem*       m_menu_file_close;
	Gtk::MenuItem*       m_menu_destroy_patch;
	Gtk::MenuItem*       m_menu_view_control_window;
	Gtk::MenuItem*       m_menu_patch_description;
	Gtk::MenuItem*       m_menu_add_plugin;
	Gtk::MenuItem*       m_menu_new_subpatch;
	Gtk::MenuItem*       m_menu_load_subpatch;
	Gtk::ScrolledWindow* m_canvas_scrolledwindow;
	Gtk::HScale*         m_zoom_slider;	
	//Gtk::Button*         m_destroy_button;
	Gtk::Label*          m_polyphony_label;
	Gtk::CheckButton*    m_process_checkbutton;
};


} // namespace OmGtk

#endif // PATCHWINDOW_H
