/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "DemolitionClientHooks.h"
#include "DemolitionModel.h"


DemolitionClientHooks::DemolitionClientHooks(DemolitionModel* model)
: m_model(model)
{
}


DemolitionClientHooks::~DemolitionClientHooks()
{
}


void
DemolitionClientHooks::error(const string& msg)
{
}


void
DemolitionClientHooks::new_patch(PatchModel* pm)
{
	m_model->add_patch(pm);
}


void
DemolitionClientHooks::new_port(PortModel* port_model)
{
	m_model->add_port(port_model);
}


void
DemolitionClientHooks::port_removal(const string& path)
{
	m_model->remove_port(path);
}


void
DemolitionClientHooks::patch_destruction(const string& path)
{
	m_model->remove_patch(path);
}


void
DemolitionClientHooks::patch_enabled(const string& path)
{
}


void
DemolitionClientHooks::patch_disabled(const string& path)
{
}

void
DemolitionClientHooks::new_node(NodeModel* nm)
{
	m_model->add_node(nm);
}


void
DemolitionClientHooks::node_removal(const string& path)
{
	m_model->remove_node(path);
}

void
DemolitionClientHooks::object_renamed(const string& old_path, const string& new_path)
{
	m_model->object_renamed(old_path, new_path);
}

void
DemolitionClientHooks::connection(ConnectionModel* cm)
{
	m_model->add_connection(cm);
}


void
DemolitionClientHooks::disconnection(const string& src_port_path, const string& dst_port_path)
{
	m_model->remove_connection(src_port_path, dst_port_path);
}


void
DemolitionClientHooks::metadata_update(MetadataModel* mm)
{
}


void
DemolitionClientHooks::control_change(ControlModel* cm)
{
}


void
DemolitionClientHooks::new_plugin(PluginModel* pi)
{
	m_model->add_plugin(pi);
}



