/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (c) 2000-2005 The OGRE Team
Also see acknowledgements in Readme.html

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA, or go to
http://www.gnu.org/copyleft/lesser.txt.
-----------------------------------------------------------------------------
*/
#ifndef __RenderTexture_H__
#define __RenderTexture_H__

#include "OgrePrerequisites.h"

#include "OgreRenderTarget.h"

namespace Ogre
{
    class _OgreExport RenderTexture : public RenderTarget
    {
    public:
        RenderTexture( const String & name, uint width, uint height, TextureType texType = TEX_TYPE_2D,  PixelFormat format = PF_R8G8B8);
        ~RenderTexture();
    protected:
		RenderTexture() {};

		virtual void firePostUpdate();
		virtual void _copyToTexture() = 0;

	protected:
		/// The texture that gets accesses by the rest of the API.
        TexturePtr mTexture;
        PixelFormat mInternalFormat;
    };
}

#endif
