/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: TestThreads.cpp,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// include OS specific include file to mix in X code

#include "vtkActor.h"
#include "vtkConeSource.h"
#include "vtkGlyph3D.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderWindow.h"
#include "vtkRenderer.h"
#include "vtkSphereSource.h"
#include "vtkXRenderWindowInteractor.h"
#include <vtkCommand.h>
#include <vtkCallbackCommand.h>

#include <iostream>
using namespace std;


#include <Xm/PushB.h>
  XtAppContext app;

vtkCallbackCommand* InteractorExitCallbackCommand = NULL;

void ExitCallback(vtkObject*, unsigned long eid, void* clientdata, void *calldata)
{

}
	
void do_stuff()
{
  if ( InteractorExitCallbackCommand == NULL )
	{
		InteractorExitCallbackCommand = vtkCallbackCommand::New();
  	// InteractorExitCallback->SetClientData(this);
  	InteractorExitCallbackCommand->SetCallback( ExitCallback );	
	}
  
	vtkRenderWindow *renWin;
  vtkRenderer *ren1;
  vtkActor *sphereActor1, *spikeActor1;
  vtkSphereSource *sphere;
  vtkConeSource *cone;
  vtkGlyph3D *glyph;
  vtkPolyDataMapper *sphereMapper, *spikeMapper;
  vtkXRenderWindowInteractor *iren;


  renWin = vtkRenderWindow::New();
  ren1 = vtkRenderer::New();
  renWin->AddRenderer(ren1);
  
  sphere = vtkSphereSource::New();
  sphereMapper = vtkPolyDataMapper::New();
  sphereMapper->SetInput(sphere->GetOutput());
  sphereActor1 = vtkActor::New();
  sphereActor1->SetMapper(sphereMapper);
  cone = vtkConeSource::New();
  glyph = vtkGlyph3D::New();
  glyph->SetInput(sphere->GetOutput());
  glyph->SetSource(cone->GetOutput());
  glyph->SetVectorModeToUseNormal();
  glyph->SetScaleModeToScaleByVector();
  glyph->SetScaleFactor(0.25);
  spikeMapper = vtkPolyDataMapper::New();
  spikeMapper->SetInput(glyph->GetOutput());
  spikeActor1 = vtkActor::New();
  spikeActor1->SetMapper(spikeMapper);
  ren1->AddActor(sphereActor1);
  ren1->AddActor(spikeActor1);
  ren1->SetBackground(0.4,0.1,0.2);
  iren = vtkXRenderWindowInteractor::New();
  iren->SetRenderWindow(renWin);
	
	iren->Initialize(app);
	iren->AddObserver(vtkCommand::ExitEvent, InteractorExitCallbackCommand, 0.0f );

	for ( int i = 0; i < 300000; i++ )
	{	
		while ( XtAppPending(app) )
		{
			XEvent event;
			XtAppNextEvent( app, &event);
			XtDispatchEvent( &event);
		}
	}
	
  sphere->Delete();
  sphereMapper->Delete();
  sphereActor1->Delete();
  cone->Delete();
  glyph->Delete();
  spikeMapper->Delete();
  spikeActor1->Delete();
	
  ren1->Delete();
  iren->Delete();
	cout << "Deleting win." << pthread_self() << flush << endl;	
	renWin->Delete();
	cout << "Deleted win." << pthread_self() << flush << endl;	
sleep(1);
	cout << "Deleted some stuff." << pthread_self() << flush << endl;	
	
	for ( int i = 0; i < 300000; i++ )
	{	
		while ( XtAppPending(app) )
		{
			XEvent event;
			XtAppNextEvent( app, &event);
			XtDispatchEvent( &event);
		}
	}
  sleep(1);
	cout << "Done stuff." << flush << endl;	
  //XtAppMainLoop(app);
}

void* start( void*)
{
  // X window stuff
  Widget toplevel, button;
  Display *display;
  // VTK stuff
	
	XInitThreads();
	XtToolkitThreadInitialize();
  XtToolkitInitialize();
	app = XtCreateApplicationContext();
	
	do_stuff();
	do_stuff();
}

main (int argc, char *argv[])
{
	pthread_t thread;
	int rc = pthread_create(&thread, NULL, start, NULL );

	cout << "Main thread continues" << pthread_self()  << std::endl << std::flush;
	
	do
	{
		cout << "." << std::flush;
		sleep(1);
	}	while (1);


}

