function text(x,y,string)

#   text(x,y,string);
#
#   Place text on a 2-D graph at x y positions

if ( nargin != 3)
	help text
	return
endif

xr = rows(x); yr = rows(y);

if (xr != 1 || yr != 1)
	if (xr != yr)
		error("text: x and y if vectors must have same number of rows")
	else
		if (rows(string) == xr)
			for i=1:xr
				plptex(x(i), y(i), 0, 0, 0, string(i,:));
			endfor
		else
			if (rows(string) == 1)
				for i=1:xr
					plptex(x(i), y(i), 0, 0, 0, string);
				endfor
			else
				error("text: if string is a matrix it must have same number of rows as x and y")
			endif
		endif
	endif
else
	plptex(x, y, 0, 0, 0, string);
endif

plflush

endfunction

