## Copyright (C) 2000 Daniel Calvelo
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## -*- texinfo -*-
## @deftypefn {Function File} {} hex2dec (@var{s})
## Return the decimal number corresponding to the binary number stored
## in the string @var{s}.  For example,
##
## @example
## hex2dec ("1110")
##      @result{} 14
## @end example
##
## If @var{s} is a string matrix, returns a column vector of converted
## numbers, one per row of @var{s}.  Invalid rows evaluate to NaN.
## @end deftypefn
##
## @seealso{dec2hex, base2dec, dec2base, bin2dec, dec2bin}

## Author: Daniel Calvelo
## Adapted-by: Paul Kienzle
## 2001-02-02 Paul Kienzle
##    * converted from hex2dec.m

function d = bin2dec (h)

  if (nargin != 1)
    usage("bin2dec (b)");
  else
    d = base2dec (h, 2);
  endif

endfunction