

#define L 8
#define MAXINDEX 106
#define INDEXMASK 255
#define two52 4.50359962737049600000000000000000000000000000000000e+15
#define twoM55 0.277555756156289135105907917022705078125e-16
#define logFastCoeff 0.14142135623730951454746218587388284504413604736328125e1
#define LARGEST 0.898846567431157953864652595394512366808988489471153286e308
#define SMALLEST 0.222507385850720138309023271733240406421921598046233183e-307
#define shiftConst 6.75539944105574400000000000000000000000000000000000e+15
#define shiftConstTwoM13 0.824633720832e12
#define two13 8192.0
#define twoM13 0.1220703125e-3
#define INDEXMASK1 0x1f
#define INDEXMASK2 0x1fe0
#define RNROUNDCST 1.01587301587301598581442042834326647273327977070694e+00
#define RDROUNDCST 8.67361737988403547205962240695953369140625000000000e-19
#define SUBNORMROUNDCST 0.576460752303423488e18
#define PRECISEROUNDCST 0.300926553810505602039996553528894893521578382533654405506e-35
#define twoM1000 0.933263618503218878990089544723817169617091446371708024622e-301
#define twoM74 0.5293955920339377119177015629247762262821197509765625e-22

#define log2_70_p_coeff_1h 1.44269504088896338700465094007086008787155151367187500000000000000000000000000000e+00
#define log2_70_p_coeff_1m 2.03552810625246160186433312051638360278748036817121624952875436065369285643100739e-17
#define log2_70_p_coeff_2h -7.21347520444481693502325470035430043935775756835937500000000000000000000000000000e-01
#define log2_70_p_coeff_2m -1.12725594936749318924493788526353267792267647960831322695440803727251477539539337e-17
#define log2_70_p_coeff_3h 4.80898346962987777164499902937677688896656036376953125000000000000000000000000000e-01
#define log2_70_p_coeff_4h -3.60673760219944627980481755002983845770359039306640625000000000000000000000000000e-01
#define log2_70_p_coeff_5h 2.88539008191916690471146011987002566456794738769531250000000000000000000000000000e-01
#define log2_70_p_coeff_6h -2.40450377363966349975044067832641303539276123046875000000000000000000000000000000e-01
#define log2_70_p_coeff_7h 2.06097743969525126761510591677506454288959503173828125000000000000000000000000000e-01

#define log2_130_p_coeff_1h 1.44269504088896338700465094007086008787155151367187500000000000000000000000000000e+00
#define log2_130_p_coeff_1m 2.03552737409310331110210900522069120325603861485809498166332787150167860090732574e-17
#define log2_130_p_coeff_1l -1.06146602236896146263026926064664797993065100369094413909960470044754680755528179e-33
#define log2_130_p_coeff_2h -7.21347520444481693502325470035430043935775756835937500000000000000000000000000000e-01
#define log2_130_p_coeff_2m -1.01776368704655165555105450261034560162801930742904749083166393575083930045366287e-17
#define log2_130_p_coeff_2l 5.34511411595447028630249611725927839300757516466699521565482986252038599158936192e-34
#define log2_130_p_coeff_3h 4.80898346962987777164499902937677688896656036376953125000000000000000000000000000e-01
#define log2_130_p_coeff_3m 2.52888083240629533774008911522493092191867953828603166055444262383389286696910858e-17
#define log2_130_p_coeff_4h -3.60673760222240846751162735017715021967887878417968750000000000000000000000000000e-01
#define log2_130_p_coeff_4m -5.08881843525388804036113375504277575334378429174238267496122034572181291878223419e-18
#define log2_130_p_coeff_5h 2.88539008177792655196469695511041209101676940917968750000000000000000000000000000e-01
#define log2_130_p_coeff_5m 2.62755152398073847756639381346527463413965059531741258469494937344279605895280838e-17
#define log2_130_p_coeff_6h -2.40449173481493888582249951468838844448328018188476562500000000000000000000000000e-01
#define log2_130_p_coeff_6m -1.26443692756777278172382591559880426333181716128670549204038309198949718847870827e-17
#define log2_130_p_coeff_7h 2.06099291555566194178439332063135225325822830200195312500000000000000000000000000e-01
#define log2_130_p_coeff_7m 6.87383539895312875323064204102239130058263040989538494862642892258008942008018494e-18
#define log2_130_p_coeff_8h -1.80336880111120451131156983137771021574735641479492187500000000000000000000000000e-01
#define log2_130_p_coeff_9h 1.60299448987662213061966554050741251558065414428710937500000000000000000000000000e-01
#define log2_130_p_coeff_10h -1.44269504079917953998091206813114695250988006591796875000000000000000000000000000e-01
#define log2_130_p_coeff_11h 1.31154094707513962925204964449221733957529067993164062500000000000000000000000000e-01
#define log2_130_p_coeff_12h -1.20226134447525057069583453994709998369216918945312500000000000000000000000000000e-01
#define log2_130_p_coeff_13h 1.10970553702962271280796358041698113083839416503906250000000000000000000000000000e-01


#define exp2_p_coeff_0h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define exp2_p_coeff_1h 6.93147180559945286226763982995180413126945495605468750000000000000000000000000000e-01
#define exp2_p_coeff_2h 2.40226506988959309651932017004583030939102172851562500000000000000000000000000000e-01
#define exp2_p_coeff_3h 5.55041161373122232669530262683110777288675308227539062500000000000000000000000000e-02

#define exp2_120_p_coeff_0h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define exp2_120_p_coeff_1h 6.93147180559945286226763982995180413126945495605468750000000000000000000000000000e-01
#define exp2_120_p_coeff_1m 2.31904681384630849473271303648771975481164951834144039022334027322358451783657074e-17
#define exp2_120_p_coeff_2h 2.40226506959100721827482516346208285540342330932617187500000000000000000000000000e-01
#define exp2_120_p_coeff_2m -9.49393125283880586293948324833484500178580834723511897021985816991218598559498787e-18
#define exp2_120_p_coeff_3h 5.55041086648215831189645541599020361900329589843750000000000000000000000000000000e-02
#define exp2_120_p_coeff_3m -3.16600969138004600291955060443412194788085531170366074271704803777538472786545753e-18
#define exp2_120_p_coeff_4h 9.61812910762847687873300372984886053018271923065185546875000000000000000000000000e-03
#define exp2_120_p_coeff_5h 1.33335581474269999902038108530177851207554340362548828125000000000000000000000000e-03
#define exp2_120_p_coeff_6h 1.54035356831810422203327126666749791183974593877792358398437500000000000000000000e-04

#define exp2_82_coeff_0h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define exp2_82_coeff_1h 6.93147180559945286226763982995180413126945495605468750000000000000000000000000000e-01
#define exp2_82_coeff_1m 2.31846856407130082392820712925655671368021772333137264787694675760576501488685608e-17
#define exp2_82_coeff_2h 2.40226506959100721827482516346208285540342330932617187500000000000000000000000000e-01
#define exp2_82_coeff_3h 5.55041086710304984452868382049928186461329460144042968750000000000000000000000000e-02
#define exp2_82_coeff_4h 9.61812619551964329001059184065525187179446220397949218750000000000000000000000000e-03


typedef struct rri_tag {float ri; double logih; double logim; double logil;} rri;  
static const rri argredtable[256] = {
  { 
    1.00000000000000000000000000000000000000000000000000e+00,   /* r[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logih[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logim[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logil[0] */ 
  } , 
  { 
    9.96109008789062500000000000000000000000000000000000e-01,   /* r[1] */ 
    5.62446320255523789233276232835123664699494838714600e-03, /* logih[1] */ 
    3.64310694089194558034258095993109791807285384624700e-19, /* logim[1] */ 
    -1.96284275232340525914596195720627417731891367064553e-35, /* logil[1] */ 
  } , 
  { 
    9.92248535156250000000000000000000000000000000000000e-01,   /* r[2] */ 
    1.12265674928146846900389732581970747560262680053711e-02, /* logih[2] */ 
    -2.01837061736057419181201412747877981301873905342571e-19, /* logim[2] */ 
    -8.76276359130307718472217510144964999205167740057366e-36, /* logil[2] */ 
  } , 
  { 
    9.88416671752929687500000000000000000000000000000000e-01,   /* r[3] */ 
    1.68087498900021219128131377829049597494304180145264e-02, /* logih[3] */ 
    3.96046463581792988288086065543694985501952808182690e-19, /* logim[3] */ 
    -7.50175900227718281636157827566620605518389361772661e-36, /* logil[3] */ 
  } , 
  { 
    9.84615325927734375000000000000000000000000000000000e-01,   /* r[4] */ 
    2.23678990197825021402078249366240925155580043792725e-02, /* logih[4] */ 
    2.72546008943383898172980491432198212129681766980967e-19, /* logim[4] */ 
    8.65193903240721388373038654840463886141894144823057e-36, /* logil[4] */ 
  } , 
  { 
    9.80842590332031250000000000000000000000000000000000e-01,   /* r[5] */ 
    2.79064695222518803496836170552342082373797893524170e-02, /* logih[5] */ 
    -1.06035466460511973857716476431794431849741915846778e-18, /* logim[5] */ 
    1.40399476841784981797309256958923855448288750735528e-35, /* logil[5] */ 
  } , 
  { 
    9.77099418640136718750000000000000000000000000000000e-01,   /* r[6] */ 
    3.34227328145833349481996776830783346667885780334473e-02, /* logih[6] */ 
    -2.30264185180544573536858875991075869298703226281026e-18, /* logim[6] */ 
    -1.54328657939112637118099481931192082521169355752646e-34, /* logil[6] */ 
  } , 
  { 
    9.73383903503417968750000000000000000000000000000000e-01,   /* r[7] */ 
    3.89191773983389929791876227227476192638278007507324e-02, /* logih[7] */ 
    2.25448778888568193693198665534250833992067200909314e-18, /* logim[7] */ 
    -1.66706958554093095538277426422752915572221541711786e-35, /* logil[7] */ 
  } , 
  { 
    9.69696998596191406250000000000000000000000000000000e-01,   /* r[8] */ 
    4.43940763627913639877142770728823961690068244934082e-02, /* logih[8] */ 
    -1.35148268469329738787933054025463561212703774709647e-18, /* logim[8] */ 
    -9.30542106567779590725369440921408781707570437070629e-36, /* logil[8] */ 
  } , 
  { 
    9.66037750244140625000000000000000000000000000000000e-01,   /* r[9] */ 
    4.98485279527303287716577528954076115041971206665039e-02, /* logih[9] */ 
    6.99684078718519819164474461192556823314757766482007e-19, /* logim[9] */ 
    -2.43070079250460900406108506315855413208920069880071e-35, /* logil[9] */ 
  } , 
  { 
    9.62406158447265625000000000000000000000000000000000e-01,   /* r[10] */ 
    5.52822205228920421360427894796885084360837936401367e-02, /* logih[10] */ 
    -2.28041829375459011783136992188608860381451027094727e-18, /* logim[10] */ 
    2.92509524765364940130250242310369777453156638429065e-35, /* logil[10] */ 
  } , 
  { 
    9.58801269531250000000000000000000000000000000000000e-01,   /* r[11] */ 
    6.06962756528966682068038096531381597742438316345215e-02, /* logih[11] */ 
    -2.30575104391021062016554403718699744533879233050506e-18, /* logim[11] */ 
    -7.17933773994063224992733787486043953294734193934224e-35, /* logil[11] */ 
  } , 
  { 
    9.55224037170410156250000000000000000000000000000000e-01,   /* r[12] */ 
    6.60889539816468807309490784973604604601860046386719e-02, /* logih[12] */ 
    -3.43531319808022917726081135288707689815983878236052e-18, /* logim[12] */ 
    -1.33537440950953098282350657111014906210298802453012e-34, /* logil[12] */ 
  } , 
  { 
    9.51672554016113281250000000000000000000000000000000e-01,   /* r[13] */ 
    7.14628301345319461024274687588331289589405059814453e-02, /* logih[13] */ 
    2.85019564755822761568469835817513709577072221641996e-18, /* logim[13] */ 
    -9.19067891131942166039810480616019695600822882350246e-37, /* logil[13] */ 
  } , 
  { 
    9.48147773742675781250000000000000000000000000000000e-01,   /* r[14] */ 
    7.68161667434743566929000735399313271045684814453125e-02, /* logih[14] */ 
    -1.06503850285483291664763275879140215046738161101689e-18, /* logim[14] */ 
    -7.65539408485798958761020119630194135239837477350922e-35, /* logil[14] */ 
  } , 
  { 
    9.44649696350097656250000000000000000000000000000000e-01,   /* r[15] */ 
    8.21486597674154217507691555510973557829856872558594e-02, /* logih[15] */ 
    1.05949179068992293701743882962947866868089440388204e-18, /* logim[15] */ 
    -8.01871606400843361947793952324428287361058018241436e-35, /* logil[15] */ 
  } , 
  { 
    9.41176414489746093750000000000000000000000000000000e-01,   /* r[16] */ 
    8.74629272416674041767947755943168886005878448486328e-02, /* logih[16] */ 
    -1.77710701464998942664649859987232463493014273104014e-18, /* logim[16] */ 
    -1.80956122292284222227087580389487512155443759846534e-35, /* logil[16] */ 
  } , 
  { 
    9.37728881835937500000000000000000000000000000000000e-01,   /* r[17] */ 
    9.27572269111804487140560127045318949967622756958008e-02, /* logih[17] */ 
    -5.27591334713426660094475417460021043346056467758629e-18, /* logim[17] */ 
    -1.53175520932242863184799310580698131125491486503283e-34, /* logil[17] */ 
  } , 
  { 
    9.34306144714355468750000000000000000000000000000000e-01,   /* r[18] */ 
    9.80327386445321302677058383778785355389118194580078e-02, /* logih[18] */ 
    -5.93734060789694089615179387615749478380374593921383e-19, /* logim[18] */ 
    3.22072168497817739835267264564341161078059188303423e-35, /* logil[18] */ 
  } , 
  { 
    9.30909156799316406250000000000000000000000000000000e-01,   /* r[19] */ 
    1.03287706297326614679477074787428136914968490600586e-01, /* logih[19] */ 
    1.33325264360904317354548306659732409559419348498273e-18, /* logim[19] */ 
    3.31890629684034024636090527929623831396401127155796e-36, /* logil[19] */ 
  } , 
  { 
    9.27536010742187500000000000000000000000000000000000e-01,   /* r[20] */ 
    1.08524800743511784517636442615184932947158813476562e-01, /* logih[20] */ 
    -1.28671557844966439678563543759408610236814325233478e-18, /* logim[20] */ 
    -2.56854731168380358630388572766888073135733818319681e-35, /* logil[20] */ 
  } , 
  { 
    9.24187660217285156250000000000000000000000000000000e-01,   /* r[21] */ 
    1.13742268163890894450140933713555568829178810119629e-01, /* logih[21] */ 
    -8.77036301522305748474920477842609739773359932085098e-19, /* logim[21] */ 
    8.57410843683479675757388920826360661070052891897777e-35, /* logil[21] */ 
  } , 
  { 
    9.20863151550292968750000000000000000000000000000000e-01,   /* r[22] */ 
    1.18941319948589224742008241264557000249624252319336e-01, /* logih[22] */ 
    4.19531239651888390161555205120491536470911709375714e-18, /* logim[22] */ 
    -2.32937303080172707430415739969539325535648073239647e-34, /* logil[22] */ 
  } , 
  { 
    9.17562484741210937500000000000000000000000000000000e-01,   /* r[23] */ 
    1.24121688041285385684098230285599129274487495422363e-01, /* logih[23] */ 
    9.00256823026971617398245077356557223480847847208472e-19, /* logim[23] */ 
    6.70088260119589436198762199150551511628184558421695e-35, /* logil[23] */ 
  } , 
  { 
    9.14285659790039062500000000000000000000000000000000e-01,   /* r[24] */ 
    1.29283102936294441720477266244415659457445144653320e-01, /* logih[24] */ 
    7.73743323061072771474411865735142118226773038589797e-18, /* logim[24] */ 
    7.00151503950389057387088983272314894406637587361574e-34, /* logil[24] */ 
  } , 
  { 
    9.11031723022460937500000000000000000000000000000000e-01,   /* r[25] */ 
    1.34426803922212734221375285414978861808776855468750e-01, /* logih[25] */ 
    2.87442943483450917166131039871184389070859209874820e-18, /* logim[25] */ 
    1.07418394159169377416152150989201926752424104438080e-34, /* logil[25] */ 
  } , 
  { 
    9.07801628112792968750000000000000000000000000000000e-01,   /* r[26] */ 
    1.39551019182446001121178369430708698928356170654297e-01, /* logih[26] */ 
    -1.30334047193679924727952135062206194795888829424720e-17, /* logim[26] */ 
    7.66296121586659828803741925222999984250452285658724e-34, /* logil[26] */ 
  } , 
  { 
    9.04593467712402343750000000000000000000000000000000e-01,   /* r[27] */ 
    1.44658516929258157412974128419591579586267471313477e-01, /* logih[27] */ 
    1.38592310231888602734839275401641903151588210621318e-17, /* logim[27] */ 
    7.04204624169239561960113974223630631428167482568361e-34, /* logil[27] */ 
  } , 
  { 
    9.01408195495605468750000000000000000000000000000000e-01,   /* r[28] */ 
    1.49747527963535687067775370451272465288639068603516e-01, /* logih[28] */ 
    -4.63121585254300608564541809516560465960812790456487e-18, /* logim[28] */ 
    -2.38375164082682849282198954173370103452053181545581e-34, /* logil[28] */ 
  } , 
  { 
    8.98245811462402343750000000000000000000000000000000e-01,   /* r[29] */ 
    1.54817791959126344059072266645671334117650985717773e-01, /* logih[29] */ 
    -1.97608219816229633690476653766429513925576435617957e-18, /* logim[29] */ 
    -7.29293250516190589410842756372025648233179264971183e-35, /* logil[29] */ 
  } , 
  { 
    8.95105361938476562500000000000000000000000000000000e-01,   /* r[30] */ 
    1.59870584354488087797108164522796869277954101562500e-01, /* logih[30] */ 
    1.38164327179219532318047293404835044148743773120749e-17, /* logim[30] */ 
    2.60902789861922854258976768649749081077445016828227e-34, /* logil[30] */ 
  } , 
  { 
    8.91985893249511718750000000000000000000000000000000e-01,   /* r[31] */ 
    1.64907200773063644660965110233519226312637329101562e-01, /* logih[31] */ 
    6.40258479048132435575035617265253227017927489659503e-18, /* logim[31] */ 
    -3.13994360424306793167722791429686820377012800164626e-36, /* logil[31] */ 
  } , 
  { 
    8.88889312744140625000000000000000000000000000000000e-01,   /* r[32] */ 
    1.69924313511872926429902008749195374548435211181641e-01, /* logih[32] */ 
    6.27897206252693367521427657669679268044418008293354e-19, /* logim[32] */ 
    -1.84662823838719713889061260700783214693984580501609e-35, /* logil[32] */ 
  } , 
  { 
    8.85812759399414062500000000000000000000000000000000e-01,   /* r[33] */ 
    1.74926316686843275061136182557675056159496307373047e-01, /* logih[33] */ 
    -1.28095711942361950784467450834305264934252560279915e-17, /* logim[33] */ 
    6.15728414357675841500352304615531898144676821521735e-34, /* logil[33] */ 
  } , 
  { 
    8.82759094238281250000000000000000000000000000000000e-01,   /* r[34] */ 
    1.79908316093213171971143538030446507036685943603516e-01, /* logih[34] */ 
    -4.05669244508450884106169713651948436101460999171934e-18, /* logim[34] */ 
    -2.73456623470470858112008354603047232113150522790287e-34, /* logil[34] */ 
  } , 
  { 
    8.79725456237792968750000000000000000000000000000000e-01,   /* r[35] */ 
    1.84874735594675820848920011485461145639419555664062e-01, /* logih[35] */ 
    7.83038695439828504402955103668931677062328445957555e-18, /* logim[35] */ 
    6.50239128030890104986149271144609240438163759169796e-34, /* logil[35] */ 
  } , 
  { 
    8.76712799072265625000000000000000000000000000000000e-01,   /* r[36] */ 
    1.89823784958295938007921677126432769000530242919922e-01, /* logih[36] */ 
    -8.81954617013802931471562955085007459413223371703754e-18, /* logim[36] */ 
    4.68176162545611138840109682829353162004456293635899e-34, /* logil[36] */ 
  } , 
  { 
    8.73720169067382812500000000000000000000000000000000e-01,   /* r[37] */ 
    1.94756800677670482979664257072727195918560028076172e-01, /* logih[37] */ 
    -2.00670924345318825647424200264947046592235601474052e-18, /* logim[37] */ 
    1.23510776676180725049881134754892221509956109351828e-34, /* logil[37] */ 
  } , 
  { 
    8.70748519897460937500000000000000000000000000000000e-01,   /* r[38] */ 
    1.99671979373277602709535472058632876724004745483398e-01, /* logih[38] */ 
    -3.35041803578082878314072229510113791314884693559175e-19, /* logim[38] */ 
    2.19585849692745582866688760428854814221266519680553e-36, /* logil[38] */ 
  } , 
  { 
    8.67796897888183593750000000000000000000000000000000e-01,   /* r[39] */ 
    2.04570665922535199765519564607529900968074798583984e-01, /* logih[39] */ 
    -1.04751553531138287440354969580963337427221634013275e-17, /* logim[39] */ 
    -4.69171037663777474441792299191703931076443660125798e-34, /* logil[39] */ 
  } , 
  { 
    8.64865303039550781250000000000000000000000000000000e-01,   /* r[40] */ 
    2.09452634702868761840122147077636327594518661499023e-01, /* logih[40] */ 
    1.10703702929617688876102394158665802371341635353943e-17, /* logim[40] */ 
    -7.14976977668988171404204188299765278177460282467036e-34, /* logil[40] */ 
  } , 
  { 
    8.61952781677246093750000000000000000000000000000000e-01,   /* r[41] */ 
    2.14319255162218030852372407935035880655050277709961e-01, /* logih[41] */ 
    1.29702313007778250478283769152847492223363745647243e-17, /* logim[41] */ 
    5.73068113001992288619079890329675696690665640594386e-34, /* logil[41] */ 
  } , 
  { 
    8.59060287475585937500000000000000000000000000000000e-01,   /* r[42] */ 
    2.19168713942656773197015240839391481131315231323242e-01, /* logih[42] */ 
    -7.04698144913766631623882809355752075602951087972227e-18, /* logim[42] */ 
    -6.81063628416184547095854182554280736255034389907768e-34, /* logil[42] */ 
  } , 
  { 
    8.56186866760253906250000000000000000000000000000000e-01,   /* r[43] */ 
    2.24002389001174750937650514970300719141960144042969e-01, /* logih[43] */ 
    9.77089146727803082940117001653944079518215379270970e-18, /* logim[43] */ 
    -5.15654043774815198603423123107750339552695455461599e-34, /* logil[43] */ 
  } , 
  { 
    8.53333473205566406250000000000000000000000000000000e-01,   /* r[44] */ 
    2.28818454019755312955908266303595155477523803710938e-01, /* logih[44] */ 
    8.60482840827231531693211061331421783325499374269103e-18, /* logim[44] */ 
    4.62159649315070967905902800219645706522346592477674e-34, /* logil[44] */ 
  } , 
  { 
    8.50498199462890625000000000000000000000000000000000e-01,   /* r[45] */ 
    2.33619913235866366596482635031861718744039535522461e-01, /* logih[45] */ 
    -3.17603438795656722833659731362733461077382072175793e-18, /* logim[45] */ 
    -1.14190998511637372945280226124717188573979535104549e-34, /* logil[45] */ 
  } , 
  { 
    8.47681999206542968750000000000000000000000000000000e-01,   /* r[46] */ 
    2.38404943554491266510808600287418812513351440429688e-01, /* logih[46] */ 
    -4.91919207875165757062252476472896320156113810759041e-18, /* logim[46] */ 
    -1.65774202516213266221949772053971269011961846039958e-34, /* logil[46] */ 
  } , 
  { 
    8.44884872436523437500000000000000000000000000000000e-01,   /* r[47] */ 
    2.43173327789243498564530909789027646183967590332031e-01, /* logih[47] */ 
    4.93306440425329257306593810775031695904319815014754e-18, /* logim[47] */ 
    -1.13614580751390656792590805859574652593001401554151e-34, /* logil[47] */ 
  } , 
  { 
    8.42104911804199218750000000000000000000000000000000e-01,   /* r[48] */ 
    2.47928115382989089354737188841681927442550659179688e-01, /* logih[48] */ 
    -1.37712103635557072032234153365222440536782865715083e-18, /* logim[48] */ 
    9.75493887073081889286766097804801019201793778479461e-36, /* logil[48] */ 
  } , 
  { 
    8.39344024658203125000000000000000000000000000000000e-01,   /* r[49] */ 
    2.52665840909102268341257513384334743022918701171875e-01, /* logih[49] */ 
    -2.29689231346274680410439539616369605449817860326088e-17, /* logim[49] */ 
    -5.60202341060166161523536551099252965521444882693529e-34, /* logil[49] */ 
  } , 
  { 
    8.36601257324218750000000000000000000000000000000000e-01,   /* r[50] */ 
    2.57387928683979749777677170641254633665084838867188e-01, /* logih[50] */ 
    1.55294884781987048139059464306453784663352757128198e-17, /* logim[50] */ 
    1.01380707456162023479965432916465584034071816674502e-33, /* logil[50] */ 
  } , 
  { 
    8.33876609802246093750000000000000000000000000000000e-01,   /* r[51] */ 
    2.62094173563105881097357041653594933450222015380859e-01, /* logih[51] */ 
    -8.55713950348344689585298731473352525543751015890334e-18, /* logim[51] */ 
    5.48763060317488000144168502344734048354142056565485e-34, /* logil[51] */ 
  } , 
  { 
    8.31169128417968750000000000000000000000000000000000e-01,   /* r[52] */ 
    2.66786024747041050630969039048068225383758544921875e-01, /* logih[52] */ 
    -1.67542241678008684495879286127707515841429324510332e-17, /* logim[52] */ 
    -1.84450647715786516704590189681050172449564734674026e-34, /* logil[52] */ 
  } , 
  { 
    8.28478813171386718750000000000000000000000000000000e-01,   /* r[53] */ 
    2.71463291252832750188872523722238838672637939453125e-01, /* logih[53] */ 
    -1.82861289604292083819624352321660587975949022128451e-17, /* logim[53] */ 
    1.41344704609359941327335627738873295910710446946318e-33, /* logil[53] */ 
  } , 
  { 
    8.25806617736816406250000000000000000000000000000000e-01,   /* r[54] */ 
    2.76124115053543395248425440513528883457183837890625e-01, /* logih[54] */ 
    2.16585493379379121431927795059778160498079515320280e-17, /* logim[54] */ 
    8.60215787486055402643372799849720707717258614661468e-34, /* logil[54] */ 
  } , 
  { 
    8.23151588439941406250000000000000000000000000000000e-01,   /* r[55] */ 
    2.80769958587697043839170873980037868022918701171875e-01, /* logih[55] */ 
    -7.49945068305251944743518556464975251268962220130981e-18, /* logim[55] */ 
    -3.35683654241982931982204205181485008542845495662437e-34, /* logil[55] */ 
  } , 
  { 
    8.20512771606445312500000000000000000000000000000000e-01,   /* r[56] */ 
    2.85402304853576316290286740695592015981674194335938e-01, /* logih[56] */ 
    1.97058866076428412478768008134629487975209602250437e-17, /* logim[56] */ 
    1.06837698553508766117432923132263183155168973782721e-33, /* logil[56] */ 
  } , 
  { 
    8.17891120910644531250000000000000000000000000000000e-01,   /* r[57] */ 
    2.90019293012687973121188633740530349314212799072266e-01, /* logih[57] */ 
    2.56668340633873322360015168072740173815474168247740e-19, /* logim[57] */ 
    1.32070461247422232763959137046376896815849857773214e-35, /* logil[57] */ 
  } , 
  { 
    8.15286636352539062500000000000000000000000000000000e-01,   /* r[58] */ 
    2.94620727393795800441722576579195447266101837158203e-01, /* logih[58] */ 
    8.28856253528690669390956178529769851637375900355867e-18, /* logim[58] */ 
    9.21060163289173545842870657414802261911841193726753e-35, /* logil[58] */ 
  } , 
  { 
    8.12698364257812500000000000000000000000000000000000e-01,   /* r[59] */ 
    2.99208104378606787321359661291353404521942138671875e-01, /* logih[59] */ 
    2.50440287234594231108545303202106361171199143807143e-17, /* logim[59] */ 
    5.76496224108896237321806536123506494667013214131283e-34, /* logil[59] */ 
  } , 
  { 
    8.10126304626464843750000000000000000000000000000000e-01,   /* r[60] */ 
    3.03781242627308878390124391444260254502296447753906e-01, /* logih[60] */ 
    7.26236946156037909713854903168533397481837663535236e-18, /* logim[60] */ 
    -5.13832288823633829539789242568260267295555917557936e-34, /* logil[60] */ 
  } , 
  { 
    8.07571411132812500000000000000000000000000000000000e-01,   /* r[61] */ 
    3.08338256217685957594198953302111476659774780273438e-01, /* logih[61] */ 
    -3.91862830506871787886277655283277883335703800578341e-18, /* logim[61] */ 
    -1.80287911307734040041601196733261985968717764792270e-34, /* logil[61] */ 
  } , 
  { 
    8.05031776428222656250000000000000000000000000000000e-01,   /* r[62] */ 
    3.12882364094114129304813332055346108973026275634766e-01, /* logih[62] */ 
    2.00566095640240859030080760939632903054042270806498e-17, /* logim[62] */ 
    -1.20548577698548841142520422108638918923500554048039e-33, /* logil[62] */ 
  } , 
  { 
    8.02507400512695312500000000000000000000000000000000e-01,   /* r[63] */ 
    3.17413398435927307517090412147808820009231567382812e-01, /* logih[63] */ 
    1.92917962412721060884664265681098014687881777581369e-17, /* logim[63] */ 
    -5.60605040615516964419678016739265374372709613799588e-34, /* logil[63] */ 
  } , 
  { 
    8.00000190734863281250000000000000000000000000000000e-01,   /* r[64] */ 
    3.21927750922101629793559141035075299441814422607422e-01, /* logih[64] */ 
    -3.68777572337715973775586041884209304585818249254945e-18, /* logim[64] */ 
    2.42378345855852981194379769493259763563573896470280e-34, /* logil[64] */ 
  } , 
  { 
    7.97508239746093750000000000000000000000000000000000e-01,   /* r[65] */ 
    3.26428670204942816823745488363783806562423706054688e-01, /* logih[65] */ 
    1.45984677103376311105171213886420877499189566989355e-18, /* logim[65] */ 
    8.54804091592753412940247017733822117449065792260507e-35, /* logil[65] */ 
  } , 
  { 
    7.95030593872070312500000000000000000000000000000000e-01,   /* r[66] */ 
    3.30917716530283567699655122851254418492317199707031e-01, /* logih[66] */ 
    -1.10914470017120619152208446527819480613105503270278e-17, /* logim[66] */ 
    7.68957589367645155571847946740580012038237827888475e-35, /* logil[66] */ 
  } , 
  { 
    7.92570114135742187500000000000000000000000000000000e-01,   /* r[67] */ 
    3.35389527027655065527511624168255366384983062744141e-01, /* logih[67] */ 
    -2.68905140673031160753055547019515200860581054595347e-17, /* logim[67] */ 
    1.12312306509581200028305457580071181488591082452267e-33, /* logil[67] */ 
  } , 
  { 
    7.90122985839843750000000000000000000000000000000000e-01,   /* r[68] */ 
    3.39850862798135311404479352859198115766048431396484e-01, /* logih[68] */ 
    2.67578448800166743621563940564181619384497916823689e-18, /* logim[68] */ 
    -4.08593208106915232849113978946102464404769851005264e-36, /* logil[68] */ 
  } , 
  { 
    7.87692070007324218750000000000000000000000000000000e-01,   /* r[69] */ 
    3.44296343246967506690481286568683572113513946533203e-01, /* logih[69] */ 
    2.61985729966483159298053143855013667206513518139355e-17, /* logim[69] */ 
    -1.43317776294076914943494562393727319237442460573694e-33, /* logil[69] */ 
  } , 
  { 
    7.85276412963867187500000000000000000000000000000000e-01,   /* r[70] */ 
    3.48727530794102902333975180226843804121017456054688e-01, /* logih[70] */ 
    -2.34058128233080475834922834476410669486100635732851e-17, /* logim[70] */ 
    -1.19495530307809197006632618244668279768915361517721e-33, /* logil[70] */ 
  } , 
  { 
    7.82875061035156250000000000000000000000000000000000e-01,   /* r[71] */ 
    3.53146008580722203795687619276577606797218322753906e-01, /* logih[71] */ 
    2.51020933081373096955654998109339846738212697870377e-17, /* logim[71] */ 
    3.85467771988000503348528260185321311042188078683671e-35, /* logil[71] */ 
  } , 
  { 
    7.80488014221191406250000000000000000000000000000000e-01,   /* r[72] */ 
    3.57551617657171139086358380154706537723541259765625e-01, /* logih[72] */ 
    8.26026920265729456320682991301405499549392385594867e-18, /* logim[72] */ 
    -4.82409659516332608730700682966909062399273519559205e-34, /* logil[72] */ 
  } , 
  { 
    7.78115272521972656250000000000000000000000000000000e-01,   /* r[73] */ 
    3.61944198317473264658872267318656668066978454589844e-01, /* logih[73] */ 
    9.35251240570409658369637671707393177323119533170476e-18, /* logim[73] */ 
    7.65402247015393379174811496478109595932454697550257e-34, /* logil[73] */ 
  } , 
  { 
    7.75757789611816406250000000000000000000000000000000e-01,   /* r[74] */ 
    3.66321816535990496532804172602482140064239501953125e-01, /* logih[74] */ 
    -1.26283763367166791971668084210111644172264929234222e-17, /* logim[74] */ 
    -5.18175152989954334710733729135724747368463044348133e-34, /* logil[74] */ 
  } , 
  { 
    7.73413658142089843750000000000000000000000000000000e-01,   /* r[75] */ 
    3.70687852887287339065380820102291181683540344238281e-01, /* logih[75] */ 
    -2.26426578076002335190700377100879173906840093029931e-18, /* logim[75] */ 
    9.39919422448895887884207901501396710115618070243006e-35, /* logil[75] */ 
  } , 
  { 
    7.71084785461425781250000000000000000000000000000000e-01,   /* r[76] */ 
    3.75038592931745407010879489462240599095821380615234e-01, /* logih[76] */ 
    1.36478878694725594397668899630117789175518936328670e-17, /* logim[76] */ 
    -7.42102285102582603712767861440251383531360222023193e-34, /* logil[76] */ 
  } , 
  { 
    7.68768310546875000000000000000000000000000000000000e-01,   /* r[77] */ 
    3.79379226984772721653627058913116343319416046142578e-01, /* logih[77] */ 
    1.13769630716652922583152930707043643780239195343403e-17, /* logim[77] */ 
    -5.71497157206590541051326347759309167725971873915619e-34, /* logil[77] */ 
  } , 
  { 
    7.66467094421386718750000000000000000000000000000000e-01,   /* r[78] */ 
    3.83704238729474844671329947232152335345745086669922e-01, /* logih[78] */ 
    -1.37569501553533684673235058090995964600109755003945e-17, /* logim[78] */ 
    -8.19419663933668791519024676445202574794121365195595e-35, /* logil[78] */ 
  } , 
  { 
    7.64179229736328125000000000000000000000000000000000e-01,   /* r[79] */ 
    3.88017048869009228972970504401018843054771423339844e-01, /* logih[79] */ 
    -3.80701519449449765873708863588277305202153361708738e-18, /* logim[79] */ 
    1.41209082306365988413846146208806553569817267206609e-34, /* logil[79] */ 
  } , 
  { 
    7.61904716491699218750000000000000000000000000000000e-01,   /* r[80] */ 
    3.92317508770088307912260461307596415281295776367188e-01, /* logih[80] */ 
    -2.48709304499940275271685524139705487487812483329234e-17, /* logim[80] */ 
    1.51913530740466505110972004119148045675527858280419e-33, /* logil[80] */ 
  } , 
  { 
    7.59643554687500000000000000000000000000000000000000e-01,   /* r[81] */ 
    3.96605469112625952377015892125200480222702026367188e-01, /* logih[81] */ 
    -2.05409584188905648894008644042627621347744841311892e-17, /* logim[81] */ 
    2.22145444790121064274793819131004556765772287126498e-35, /* logil[81] */ 
  } , 
  { 
    7.57396697998046875000000000000000000000000000000000e-01,   /* r[82] */ 
    4.00878963329971971241150185960577800869941711425781e-01, /* logih[82] */ 
    -2.66817967026326825523345579536420301974049078445688e-19, /* logim[82] */ 
    -1.05363633967249486254042597699490314094813255836572e-35, /* logil[82] */ 
  } , 
  { 
    7.55162239074707031250000000000000000000000000000000e-01,   /* r[83] */ 
    4.05141468510801738833748686374747194349765777587891e-01, /* logih[83] */ 
    4.12013026738107642301137843414110630137096547313805e-19, /* logim[83] */ 
    2.33575446522787458311195104600075869808876514799442e-35, /* logil[83] */ 
  } , 
  { 
    7.52941131591796875000000000000000000000000000000000e-01,   /* r[84] */ 
    4.09391022129029724663240585869061760604381561279297e-01, /* logih[84] */ 
    2.56067666045646563728399935742968282460993394682039e-17, /* logim[84] */ 
    -5.13721066726803690112726682214076449553351301368597e-34, /* logil[84] */ 
  } , 
  { 
    7.50733375549316406250000000000000000000000000000000e-01,   /* r[85] */ 
    4.13627472195328416137982685540919192135334014892578e-01, /* logih[85] */ 
    2.18808337792321329482011871274589564814328341663075e-17, /* logim[85] */ 
    1.02540355629315485391150379093592950725836019876557e-33, /* logil[85] */ 
  } , 
  { 
    7.48538017272949218750000000000000000000000000000000e-01,   /* r[86] */ 
    4.17852504136982216831341929719201289117336273193359e-01, /* logih[86] */ 
    9.86946871873695851969756471738566369665379660554619e-19, /* logim[86] */ 
    6.29612486797528483220726516137805747359270884942425e-35, /* logil[86] */ 
  } , 
  { 
    7.46356010437011718750000000000000000000000000000000e-01,   /* r[87] */ 
    4.22064137361382152313638016494223847985267639160156e-01, /* logih[87] */ 
    -1.05922076934284027175745907413659282941993793826139e-17, /* logim[87] */ 
    -6.12299960012078338449376466647955436587104734540624e-34, /* logil[87] */ 
  } , 
  { 
    7.44186401367187500000000000000000000000000000000000e-01,   /* r[88] */ 
    4.26264066771658511889597775734728202223777770996094e-01, /* logih[88] */ 
    -8.85513480816040453945742392800672953193458312727256e-18, /* logim[88] */ 
    -5.24714106986727460487580275593262691651180525370791e-34, /* logil[88] */ 
  } , 
  { 
    7.42029190063476562500000000000000000000000000000000e-01,   /* r[89] */ 
    4.30452153955706073862330640622531063854694366455078e-01, /* logih[89] */ 
    2.61368823927001457998555167240062922142140611089746e-17, /* logim[89] */ 
    1.44680766060028701358746313826017052885573936570807e-33, /* logil[89] */ 
  } , 
  { 
    7.39884376525878906250000000000000000000000000000000e-01,   /* r[90] */ 
    4.34628259883472034541540551799698732793331146240234e-01, /* logih[90] */ 
    -4.65804559835565790738625882506228255266947860929998e-18, /* logim[90] */ 
    3.50162107860052357002426832774093849420181199400792e-34, /* logil[90] */ 
  } , 
  { 
    7.37751960754394531250000000000000000000000000000000e-01,   /* r[91] */ 
    4.38792244913736528832970407165703363716602325439453e-01, /* logih[91] */ 
    6.54435041067844518638349922716293820410138082918974e-18, /* logim[91] */ 
    1.66288117681168517806253799205003056056005048205360e-34, /* logil[91] */ 
  } , 
  { 
    7.35631942749023437500000000000000000000000000000000e-01,   /* r[92] */ 
    4.42943968801095711018689371485379524528980255126953e-01, /* logih[92] */ 
    -1.31830993629830820106422084359785358736815996728614e-17, /* logim[92] */ 
    4.61053576482372100205685418524847218246553128543631e-34, /* logil[92] */ 
  } , 
  { 
    7.33524322509765625000000000000000000000000000000000e-01,   /* r[93] */ 
    4.47083290703147728795130433354643173515796661376953e-01, /* logih[93] */ 
    1.69077329042533132659710418879288890988542117042696e-17, /* logim[93] */ 
    9.64412076794160463494531210530587642610119179701767e-34, /* logil[93] */ 
  } , 
  { 
    7.31428146362304687500000000000000000000000000000000e-01,   /* r[94] */ 
    4.51211950247995374763121390060405246913433074951172e-01, /* logih[94] */ 
    5.29157734589489879989241042345888795815986344495564e-18, /* logim[94] */ 
    4.05922256458861404459677801513180982129072332853957e-35, /* logil[94] */ 
  } , 
  { 
    7.29344367980957031250000000000000000000000000000000e-01,   /* r[95] */ 
    4.55327935107630421551760946385911665856838226318359e-01, /* logih[95] */ 
    1.12238496235431997950024540898660473611218791584296e-17, /* logim[95] */ 
    2.53810412167217662475589577599465754868617140018869e-34, /* logil[95] */ 
  } , 
  { 
    7.27272987365722656250000000000000000000000000000000e-01,   /* r[96] */ 
    4.59431102689436932084987574853585101664066314697266e-01, /* logih[96] */ 
    -5.65021202083821658568979172094850503702023051443232e-18, /* logim[96] */ 
    2.66729880996649709196382536663439201060959304794017e-34, /* logil[96] */ 
  } , 
  { 
    7.25212097167968750000000000000000000000000000000000e-01,   /* r[97] */ 
    4.63525104197631598879070224938914179801940917968750e-01, /* logih[97] */ 
    1.64015018050273811377058500937130036591871213663913e-17, /* logim[97] */ 
    -2.37668158047196530099123034685246144103569462059140e-35, /* logil[97] */ 
  } , 
  { 
    7.23163604736328125000000000000000000000000000000000e-01,   /* r[98] */ 
    4.67606023035364859463669517936068587005138397216797e-01, /* logih[98] */ 
    -2.35404459021293530100419612489692369296536941011139e-17, /* logim[98] */ 
    8.65686412848735892137131700314774245266762617410743e-34, /* logil[98] */ 
  } , 
  { 
    7.21126556396484375000000000000000000000000000000000e-01,   /* r[99] */ 
    4.71675622850898035309796796354930847883224487304688e-01, /* logih[99] */ 
    -5.00291784895727418193570650071413020227423422230627e-18, /* logim[99] */ 
    -3.48814629702810911815080058632968938255265704317182e-34, /* logil[99] */ 
  } , 
  { 
    7.19100952148437500000000000000000000000000000000000e-01,   /* r[100] */ 
    4.75733774931740460711893092593527399003505706787109e-01, /* logih[100] */ 
    2.37354207292015831848317508817743592416645271551013e-17, /* logim[100] */ 
    3.75220251398787236762445752605220099123667359652946e-34, /* logil[100] */ 
  } , 
  { 
    7.17086791992187500000000000000000000000000000000000e-01,   /* r[101] */ 
    4.79780350020427681645429629497812129557132720947266e-01, /* logih[101] */ 
    9.64996639262616277761997731342311958042765881278166e-18, /* logim[101] */ 
    -1.45917791984963879526832989164269922466650870970319e-34, /* logil[101] */ 
  } , 
  { 
    7.15084075927734375000000000000000000000000000000000e-01,   /* r[102] */ 
    4.83815218320749418356996329748653806746006011962891e-01, /* logih[102] */ 
    -2.26055495552680496488915066271475591152753444344542e-17, /* logim[102] */ 
    1.15943477520296400421924802163066587581164941504239e-33, /* logil[102] */ 
  } , 
  { 
    7.13091850280761718750000000000000000000000000000000e-01,   /* r[103] */ 
    4.87840178933420298701406636610045097768306732177734e-01, /* logih[103] */ 
    9.95061561880808777250662218784807296295756393896643e-18, /* logim[103] */ 
    -2.70730037505675842458176336457886940782026608863071e-34, /* logil[103] */ 
  } , 
  { 
    7.11111068725585937500000000000000000000000000000000e-01,   /* r[104] */ 
    4.91853182321002724286529428354697301983833312988281e-01, /* logih[104] */ 
    -1.93631103608357505056849606827194505159750296147429e-17, /* logim[104] */ 
    -5.13067202688456219222003091599945986652944064972985e-34, /* logil[104] */ 
  } , 
  { 
    7.09141731262207031250000000000000000000000000000000e-01,   /* r[105] */ 
    4.95854097106264379846152223763056099414825439453125e-01, /* logih[105] */ 
    -8.97253997785747359550285084120100354068920818555134e-18, /* logim[105] */ 
    4.48985852964966878119016366112985893401143906248048e-34, /* logil[105] */ 
  } , 
  { 
    1.41436386108398437500000000000000000000000000000000e+00,   /* r[106] */ 
    -5.00153317496815130738241350627504289150238037109375e-01, /* logih[106] */ 
    6.38652340493840901898261226024177907291121978480765e-18, /* logim[106] */ 
    -1.50115709371786842001778403725543006667379544298665e-34, /* logil[106] */ 
  } , 
  { 
    1.41046905517578125000000000000000000000000000000000e+00,   /* r[107] */ 
    -4.96175014428150595868771688401466235518455505371094e-01, /* logih[107] */ 
    -2.52613980927368683904892283975420623567633947857171e-17, /* logim[107] */ 
    -2.78172233261534782496122526419959911999891480999118e-34, /* logil[107] */ 
  } , 
  { 
    1.40659332275390625000000000000000000000000000000000e+00,   /* r[108] */ 
    -4.92205273809975751841960800447850488126277923583984e-01, /* logih[108] */ 
    1.38263645220702992115908316962406899116133433250055e-17, /* logim[108] */ 
    -9.13478810114964638432169273750765158178251684940645e-35, /* logil[108] */ 
  } , 
  { 
    1.40274047851562500000000000000000000000000000000000e+00,   /* r[109] */ 
    -4.88248120154341713750056896969908848404884338378906e-01, /* logih[109] */ 
    -9.19124816655229741100591795639860013679834003477893e-18, /* logim[109] */ 
    3.57736696925483033542993216894623988952660296440587e-34, /* logil[109] */ 
  } , 
  { 
    1.39890670776367187500000000000000000000000000000000e+00,   /* r[110] */ 
    -4.84299753257103948733686138439225032925605773925781e-01, /* logih[110] */ 
    2.76894400316545187895597055836412754062515893165117e-17, /* logim[110] */ 
    -1.28196249311567885024568784724802925800328520582323e-33, /* logil[110] */ 
  } , 
  { 
    1.39509582519531250000000000000000000000000000000000e+00,   /* r[111] */ 
    -4.80364220108999595559851059078937396407127380371094e-01, /* logih[111] */ 
    1.60772577856827581149848485565219950146355948388194e-17, /* logim[111] */ 
    -6.33909180037348533226128939381564653515346318497266e-34, /* logil[111] */ 
  } , 
  { 
    1.39130401611328125000000000000000000000000000000000e+00,   /* r[112] */ 
    -4.76437699977644402160592562722740694880485534667969e-01, /* logih[112] */ 
    3.93777448294044466045455458211156033645576475025704e-18, /* logim[112] */ 
    3.61421668039083688240729461133241002751658704802140e-35, /* logil[112] */ 
  } , 
  { 
    1.38753318786621093750000000000000000000000000000000e+00,   /* r[113] */ 
    -4.72522279136534217869325402716640383005142211914062e-01, /* logih[113] */ 
    1.96035568196414967372784793032251967173332695653211e-18, /* logim[113] */ 
    -1.17747583658959694655352427302025069169526418930102e-34, /* logil[113] */ 
  } , 
  { 
    1.38378334045410156250000000000000000000000000000000e+00,   /* r[114] */ 
    -4.68618077280239631043912140739848837256431579589844e-01, /* logih[114] */ 
    -6.21887814563789414007506165242075506645450300833460e-18, /* logim[114] */ 
    2.85091055480350088234477660182894618899479782600553e-34, /* logil[114] */ 
  } , 
  { 
    1.38005447387695312500000000000000000000000000000000e+00,   /* r[115] */ 
    -4.64725214569437938827434209088096395134925842285156e-01, /* logih[115] */ 
    1.41770874784515407852341959571636665299319020447279e-17, /* logim[115] */ 
    7.16277267487504881902108530195699095867171533372599e-34, /* logil[115] */ 
  } , 
  { 
    1.37634468078613281250000000000000000000000000000000e+00,   /* r[116] */ 
    -4.60841812328943278842530162364710122346878051757812e-01, /* logih[116] */ 
    -4.53322590938932589383322662851218023838002020827810e-18, /* logim[116] */ 
    -3.00474404192043520651451236027633906276066461510596e-34, /* logil[116] */ 
  } , 
  { 
    1.37265396118164062500000000000000000000000000000000e+00,   /* r[117] */ 
    -4.56967975515349844606305396155221387743949890136719e-01, /* logih[117] */ 
    -2.33094358634200721377135368497958427964300301497283e-17, /* logim[117] */ 
    9.88425626506853222061479506529364782400408771511375e-34, /* logil[117] */ 
  } , 
  { 
    1.36898422241210937500000000000000000000000000000000e+00,   /* r[118] */ 
    -4.53105819584143920675245453821844421327114105224609e-01, /* logih[118] */ 
    2.01510616322289821386139052884185780607827719984300e-18, /* logim[118] */ 
    6.02181671552856437268832796139799348494799893689780e-35, /* logil[118] */ 
  } , 
  { 
    1.36533355712890625000000000000000000000000000000000e+00,   /* r[119] */ 
    -4.49253451092882338802070307792746461927890777587891e-01, /* logih[119] */ 
    8.23312641185804722064182220776569229058888742494964e-18, /* logim[119] */ 
    3.51720183694942905373021695760046871719134069706073e-34, /* logil[119] */ 
  } , 
  { 
    1.36170196533203125000000000000000000000000000000000e+00,   /* r[120] */ 
    -4.45410976339701503157186834869207814335823059082031e-01, /* logih[120] */ 
    -1.08977418015840362022538949472279372016122627370204e-17, /* logim[120] */ 
    6.97295970316695053124005231434035931338517048339577e-34, /* logil[120] */ 
  } , 
  { 
    1.35808944702148437500000000000000000000000000000000e+00,   /* r[121] */ 
    -4.41578502060277766627649498332175426185131072998047e-01, /* logih[121] */ 
    -2.36601424071700836766138911811129382339795814666297e-18, /* logim[121] */ 
    -8.33576574128057056240434241376128274787476967696058e-35, /* logil[121] */ 
  } , 
  { 
    1.35449790954589843750000000000000000000000000000000e+00,   /* r[122] */ 
    -4.37758166969168582838278780400287359952926635742188e-01, /* logih[122] */ 
    2.32683708630670947650076997142659873229215752583714e-17, /* logim[122] */ 
    -4.15560143754890940120352265317471333960877272565937e-34, /* logil[122] */ 
  } , 
  { 
    1.35092353820800781250000000000000000000000000000000e+00,   /* r[123] */ 
    -4.33946020947943322809692290320526808500289916992188e-01, /* logih[123] */ 
    -6.30929577529820412721860253954307086992044476041831e-19, /* logim[123] */ 
    3.79819606716958067883014408281063348020187639876938e-35, /* logil[123] */ 
  } , 
  { 
    1.34736824035644531250000000000000000000000000000000e+00,   /* r[124] */ 
    -4.30144198188556980966268383781425654888153076171875e-01, /* logih[124] */ 
    1.71683205857569655573934637457594450429113050785555e-17, /* logim[124] */ 
    7.29043201113051662805038181720083419974138092701628e-34, /* logil[124] */ 
  } , 
  { 
    1.34383201599121093750000000000000000000000000000000e+00,   /* r[125] */ 
    -4.26352807132220124053390009066788479685783386230469e-01, /* logih[125] */ 
    8.26061049860036128096500446845868042685767901578105e-18, /* logim[125] */ 
    4.84223346776956637948090236698054613852109689623963e-35, /* logil[125] */ 
  } , 
  { 
    1.34031486511230468750000000000000000000000000000000e+00,   /* r[126] */ 
    -4.22571956634882506254058398553752340376377105712891e-01, /* logih[126] */ 
    2.21190566670722703461840612616380011243743333737306e-17, /* logim[126] */ 
    1.14896204572710075326698165510345911361717606050114e-33, /* logil[126] */ 
  } , 
  { 
    1.33681488037109375000000000000000000000000000000000e+00,   /* r[127] */ 
    -4.18799697546823501692614399871672503650188446044922e-01, /* logih[127] */ 
    3.41599526072994406508033857887135558854814373525867e-18, /* logim[127] */ 
    1.61801446193077496556464113278472787123475795694267e-34, /* logil[127] */ 
  } , 
  { 
    1.33333396911621093750000000000000000000000000000000e+00,   /* r[128] */ 
    -4.15038187209283260248326996588730253279209136962891e-01, /* logih[128] */ 
    5.85238726764280271365110933546070366526501739862427e-18, /* logim[128] */ 
    -2.45528134121210933969132173699021927099228584364359e-34, /* logil[128] */ 
  } , 
  { 
    1.32987022399902343750000000000000000000000000000000e+00,   /* r[129] */ 
    -4.11285466532431642772138502550660632550716400146484e-01, /* logih[129] */ 
    1.83565181086895727239354318438705255980398036076305e-17, /* logim[129] */ 
    -1.44829162356744238484324099870150480074671457391215e-34, /* logil[129] */ 
  } , 
  { 
    1.32642555236816406250000000000000000000000000000000e+00,   /* r[130] */ 
    -4.07543704406910789472817668865900486707687377929688e-01, /* logih[130] */ 
    7.10235884116823704612718576916821308079422777996548e-18, /* logim[130] */ 
    -3.80158777039570620950910438941465328615623287437883e-34, /* logil[130] */ 
  } , 
  { 
    1.32299804687500000000000000000000000000000000000000e+00,   /* r[131] */ 
    -4.03810931786029114753944213589420542120933532714844e-01, /* logih[131] */ 
    -1.93041149309406226539378039674180224095823991324562e-17, /* logim[131] */ 
    -6.48369386828220195024391999791810414893637949753662e-34, /* logil[131] */ 
  } , 
  { 
    1.31958770751953125000000000000000000000000000000000e+00,   /* r[132] */ 
    -4.00087243804195191732020475683384574949741363525391e-01, /* logih[132] */ 
    2.89502375830776532785152499054923847834329794887170e-18, /* logim[132] */ 
    3.93222273610552470790411012589691255020379298257710e-35, /* logil[132] */ 
  } , 
  { 
    1.31619453430175781250000000000000000000000000000000e+00,   /* r[133] */ 
    -3.96372735981224799672872904920950531959533691406250e-01, /* logih[133] */ 
    3.60172691524424563925914502416059579856197691514466e-18, /* logim[133] */ 
    -1.20158940511610546308573928507645976530296896406609e-34, /* logil[133] */ 
  } , 
  { 
    1.31282043457031250000000000000000000000000000000000e+00,   /* r[134] */ 
    -3.92669600259061335467691833400749601423740386962891e-01, /* logih[134] */ 
    1.93341846112285731515865124079144232548548539073023e-17, /* logim[134] */ 
    9.57937519914959684169918849813293673245644163903024e-34, /* logil[134] */ 
  } , 
  { 
    1.30946350097656250000000000000000000000000000000000e+00,   /* r[135] */ 
    -3.88975847627444304421828746853861957788467407226562e-01, /* logih[135] */ 
    3.58737691022243699966445076948412264467756073807198e-18, /* logim[135] */ 
    -6.34256172069676302574983465348800715277257535337860e-35, /* logil[135] */ 
  } , 
  { 
    1.30612182617187500000000000000000000000000000000000e+00,   /* r[136] */ 
    -3.85289467954024300588855567184509709477424621582031e-01, /* logih[136] */ 
    -1.78035364405942478618622742807600593390557301297535e-17, /* logim[136] */ 
    1.17850158702046574289759352582101206794867193878284e-33, /* logil[136] */ 
  } , 
  { 
    1.30279922485351562500000000000000000000000000000000e+00,   /* r[137] */ 
    -3.81614766464260513068040836515137925744056701660156e-01, /* logih[137] */ 
    2.71673376063405867104437219707745590226184712176125e-17, /* logim[137] */ 
    1.69029691017588123460454883011389181316638787275286e-34, /* logil[137] */ 
  } , 
  { 
    1.29949188232421875000000000000000000000000000000000e+00,   /* r[138] */ 
    -3.77947621599900140942907000862760469317436218261719e-01, /* logih[138] */ 
    -1.23014367483561633748866777916981619679184303004036e-17, /* logim[138] */ 
    6.08355261096735838824466189133147806184918981423043e-34, /* logil[138] */ 
  } , 
  { 
    1.29620170593261718750000000000000000000000000000000e+00,   /* r[139] */ 
    -3.74290237902951461457234927365789189934730529785156e-01, /* logih[139] */ 
    5.12028570979627947467233714003700900250465944855234e-18, /* logim[139] */ 
    -7.18774911143147425103526075484104021221318133467838e-35, /* logil[139] */ 
  } , 
  { 
    1.29292869567871093750000000000000000000000000000000e+00,   /* r[140] */ 
    -3.70642713487464359189971219166181981563568115234375e-01, /* logih[140] */ 
    -3.62882160448161069817531404328334713231193347048715e-18, /* logim[140] */ 
    3.44993361798375847334078483327966754606152885070616e-34, /* logil[140] */ 
  } , 
  { 
    1.28967285156250000000000000000000000000000000000000e+00,   /* r[141] */ 
    -3.67005146822302952269723164135939441621303558349609e-01, /* logih[141] */ 
    1.65005650962521207026407651865843985133165811425788e-17, /* logim[141] */ 
    5.91047470268282047973730611955174472735945862101340e-34, /* logil[141] */ 
  } , 
  { 
    1.28643226623535156250000000000000000000000000000000e+00,   /* r[142] */ 
    -3.63375497694418791994053208327386528253555297851562e-01, /* logih[142] */ 
    7.55315421152055178681914500647362519327258619048632e-18, /* logim[142] */ 
    4.21306551291527090995179817572489429320996105009542e-34, /* logil[142] */ 
  } , 
  { 
    1.28320884704589843750000000000000000000000000000000e+00,   /* r[143] */ 
    -3.59755993558560860368089606708963401615619659423828e-01, /* logih[143] */ 
    2.63438906908873597795987370422038765478538518071631e-17, /* logim[143] */ 
    -5.30377956355563946242119261708497493118965065157578e-34, /* logil[143] */ 
  } , 
  { 
    1.28000068664550781250000000000000000000000000000000e+00,   /* r[144] */ 
    -3.56144584146996623363889966640272177755832672119141e-01, /* logih[144] */ 
    1.84288871644476152525450190682980250615827933483764e-17, /* logim[144] */ 
    -2.68882850166617068062129216508822868733174909720115e-34, /* logil[144] */ 
  } , 
  { 
    1.27680778503417968750000000000000000000000000000000e+00,   /* r[145] */ 
    -3.52541353192291462281815483947866596281528472900391e-01, /* logih[145] */ 
    6.10296193683269704536448210556558136989473744080234e-18, /* logim[145] */ 
    2.08807753798353788586668668478566842671399016888175e-34, /* logil[145] */ 
  } , 
  { 
    1.27363204956054687500000000000000000000000000000000e+00,   /* r[146] */ 
    -3.48948545297196932590821916164713911712169647216797e-01, /* logih[146] */ 
    -8.65980325947033784931501249514555272578815826796687e-18, /* logim[146] */ 
    -5.80551069749146700308305149939969738912023055923091e-34, /* logil[146] */ 
  } , 
  { 
    1.27047157287597656250000000000000000000000000000000e+00,   /* r[147] */ 
    -3.45364095084557620740639549694606103003025054931641e-01, /* logih[147] */ 
    -2.20359930641039442061906126368732543917103383835287e-17, /* logim[147] */ 
    5.25544112497915932563320135615380577517633877609112e-34, /* logil[147] */ 
  } , 
  { 
    1.26732635498046875000000000000000000000000000000000e+00,   /* r[148] */ 
    -3.41788087291514053323027155784075148403644561767578e-01, /* logih[148] */ 
    1.60590761637741619238785912450262223376577693103413e-17, /* logim[148] */ 
    6.20932254992098893431701251479794933091514543510527e-34, /* logil[148] */ 
  } , 
  { 
    1.26419830322265625000000000000000000000000000000000e+00,   /* r[149] */ 
    -3.38222783638829349595056328325881622731685638427734e-01, /* logih[149] */ 
    -7.25934908657137387104187166197193711352219562279959e-19, /* logim[149] */ 
    -7.33518955628645774542681475658185145551343791889460e-36, /* logil[149] */ 
  } , 
  { 
    1.26108360290527343750000000000000000000000000000000e+00,   /* r[150] */ 
    -3.34663921581079604194997045851778239011764526367188e-01, /* logih[150] */ 
    2.58775470575103710441675607573318821075159943052076e-17, /* logim[150] */ 
    2.52692281388567773158078403820428589058070685814554e-35, /* logil[150] */ 
  } , 
  { 
    1.25798606872558593750000000000000000000000000000000e+00,   /* r[151] */ 
    -3.31115945514659559822945311680086888372898101806641e-01, /* logih[151] */ 
    -1.88333140638890303027893990821579263359866325365640e-17, /* logim[151] */ 
    -2.42862233896785521070263301233188993094792416528478e-34, /* logil[151] */ 
  } , 
  { 
    1.25490188598632812500000000000000000000000000000000e+00,   /* r[152] */ 
    -3.27574572037176436900551834696670994162559509277344e-01, /* logih[152] */ 
    2.07539785395888161822620697150340485723327148173244e-17, /* logim[152] */ 
    -1.23548121878231629330640725541259206553802467565088e-33, /* logil[152] */ 
  } , 
  { 
    1.25183296203613281250000000000000000000000000000000e+00,   /* r[153] */ 
    -3.24042069523512776818563452252419665455818176269531e-01, /* logih[153] */ 
    -2.19005007906502743142091460775759087075823478365805e-17, /* logim[153] */ 
    -9.37037260965326332974189985014675959956434500415796e-34, /* logil[153] */ 
  } , 
  { 
    1.24878120422363281250000000000000000000000000000000e+00,   /* r[154] */ 
    -3.20520728160823831220938018304877914488315582275391e-01, /* logih[154] */ 
    8.84664087846507870804592874874264782111036297675925e-18, /* logim[154] */ 
    -2.79501394783314300402799429396176544077241557582655e-34, /* logil[154] */ 
  } , 
  { 
    1.24574279785156250000000000000000000000000000000000e+00,   /* r[155] */ 
    -3.17006233235677392645612826527212746441364288330078e-01, /* logih[155] */ 
    -2.11397414280339689746407608887976410350376395394685e-17, /* logim[155] */ 
    3.03479113171805714055168835565789961369331896831913e-34, /* logil[155] */ 
  } , 
  { 
    1.24271774291992187500000000000000000000000000000000e+00,   /* r[156] */ 
    -3.13498655898958755727790048695169389247894287109375e-01, /* logih[156] */ 
    2.26105586296044525095947242798100200767794657136581e-17, /* logim[156] */ 
    2.60892976305499386383284257219701588877405462281587e-34, /* logil[156] */ 
  } , 
  { 
    1.23970985412597656250000000000000000000000000000000e+00,   /* r[157] */ 
    -3.10002506907223029930520397101645357906818389892578e-01, /* logih[157] */ 
    -2.12074655036622140523873009541587371919611130881289e-17, /* logim[157] */ 
    7.30831854753703044634898432991347385046726141750071e-34, /* logil[157] */ 
  } , 
  { 
    1.23671531677246093750000000000000000000000000000000e+00,   /* r[158] */ 
    -3.06513440210500087701461779943201690912246704101562e-01, /* logih[158] */ 
    2.12840943277243056092775928647435125404474364580951e-17, /* logim[158] */ 
    7.25047508544774410393782565061654912871065991425794e-34, /* logil[158] */ 
  } , 
  { 
    1.23373413085937500000000000000000000000000000000000e+00,   /* r[159] */ 
    -3.03031527860823046705007755008409731090068817138672e-01, /* logih[159] */ 
    -1.17964490716782890686396740199564245489484684608012e-17, /* logim[159] */ 
    -2.32059444003387543097602750801495580204955378385700e-34, /* logil[159] */ 
  } , 
  { 
    1.23077011108398437500000000000000000000000000000000e+00,   /* r[160] */ 
    -2.99561313754444002999122176333912648260593414306641e-01, /* logih[160] */ 
    2.11014025619190086202004124493478829824043549375509e-17, /* logim[160] */ 
    5.40038404420639021176237530552511419095691650926683e-34, /* logil[160] */ 
  } , 
  { 
    1.22781753540039062500000000000000000000000000000000e+00,   /* r[161] */ 
    -2.96096179330254616335338369026430882513523101806641e-01, /* logih[161] */ 
    2.67263979507576883549661537337697767383852090911653e-17, /* logim[161] */ 
    -2.94764943000919117463056963543943525405460259854793e-34, /* logil[161] */ 
  } , 
  { 
    1.22488021850585937500000000000000000000000000000000e+00,   /* r[162] */ 
    -2.92640674438622072628390924364794045686721801757812e-01, /* logih[162] */ 
    1.71594867435767387701491785234936424743342309564339e-17, /* logim[162] */ 
    -1.31007554480643933015058741413754044981377681619902e-33, /* logil[162] */ 
  } , 
  { 
    1.22195625305175781250000000000000000000000000000000e+00,   /* r[163] */ 
    -2.89192636519142565187934224013588391244411468505859e-01, /* logih[163] */ 
    -2.18230480089953441152115749431697227603316223085319e-19, /* logim[163] */ 
    -8.85466907005428204234103766898640792692944423628476e-36, /* logil[163] */ 
  } , 
  { 
    1.21904754638671875000000000000000000000000000000000e+00,   /* r[164] */ 
    -2.85754396342549343845718112788745202124118804931641e-01, /* logih[164] */ 
    -2.52426324464082956234588408195190742914473546506648e-17, /* logim[164] */ 
    1.40869584178453690304836821378162094545489911118516e-33, /* logil[164] */ 
  } , 
  { 
    1.21615219116210937500000000000000000000000000000000e+00,   /* r[165] */ 
    -2.82323781162987341719627920610946603119373321533203e-01, /* logih[165] */ 
    -2.26062338879282363134318310278758951570998177822355e-17, /* logim[165] */ 
    -2.68106389298437671467414029735971090503255483828766e-34, /* logil[165] */ 
  } , 
  { 
    1.21327018737792968750000000000000000000000000000000e+00,   /* r[166] */ 
    -2.78900865037392253764636507185059599578380584716797e-01, /* logih[166] */ 
    -5.63339187198014524317590270324119375314418005110616e-18, /* logim[166] */ 
    5.21040627963337134602368749859442018659641934000068e-35, /* logil[166] */ 
  } , 
  { 
    1.21040153503417968750000000000000000000000000000000e+00,   /* r[167] */ 
    -2.75485722297818480530651186199975199997425079345703e-01, /* logih[167] */ 
    1.00075444298865318738580890792735678874884353310639e-17, /* logim[167] */ 
    -4.47816459623451897434280578394151285127126954784303e-34, /* logil[167] */ 
  } , 
  { 
    1.20754623413085937500000000000000000000000000000000e+00,   /* r[168] */ 
    -2.72078427549137136232104694499867036938667297363281e-01, /* logih[168] */ 
    2.72560475587786773498503956757053623040042693331146e-17, /* logim[168] */ 
    1.45218948063688621997250686619739825113781997475216e-33, /* logil[168] */ 
  } , 
  { 
    1.20470619201660156250000000000000000000000000000000e+00,   /* r[169] */ 
    -2.68681339812479158535296619447763077914714813232422e-01, /* logih[169] */ 
    5.70669740727466907072711072058064597445179109382518e-19, /* logim[169] */ 
    3.22286121745779380928448151900341840625477392480707e-35, /* logil[169] */ 
  } , 
  { 
    1.20187759399414062500000000000000000000000000000000e+00,   /* r[170] */ 
    -2.65289971315308126253995624210801906883716583251953e-01, /* logih[170] */ 
    -9.85570591393311591325758586976559232082321294112761e-18, /* logim[170] */ 
    4.70169173751465081907550999286196624093375291125429e-34, /* logil[170] */ 
  } , 
  { 
    1.19906234741210937500000000000000000000000000000000e+00,   /* r[171] */ 
    -2.61906676236464963647421200221288017928600311279297e-01, /* logih[171] */ 
    2.11725501817603632855204088733430972661848669245281e-17, /* logim[171] */ 
    -4.34447783947526009842327436452242187031752585481265e-34, /* logil[171] */ 
  } , 
  { 
    1.19626235961914062500000000000000000000000000000000e+00,   /* r[172] */ 
    -2.58533830516213369854483516974141821265220642089844e-01, /* logih[172] */ 
    6.68433683242387216829190215856985521381580367248536e-18, /* logim[172] */ 
    1.47308049080021740635607084979003827052572897235269e-34, /* logil[172] */ 
  } , 
  { 
    1.19347381591796875000000000000000000000000000000000e+00,   /* r[173] */ 
    -2.55166914924355725524662830139277502894401550292969e-01, /* logih[173] */ 
    8.59194265653184494493651707567219919844164634345398e-18, /* logim[173] */ 
    -5.71296827813717896996055631958626046207607829073074e-34, /* logil[173] */ 
  } , 
  { 
    1.19069862365722656250000000000000000000000000000000e+00,   /* r[174] */ 
    -2.51808300544058893954968425532570108771324157714844e-01, /* logih[174] */ 
    -1.41914360009177510586369575931064612468930448614148e-17, /* logim[174] */ 
    -1.62403247278609196179609602276489322075073469608800e-34, /* logil[174] */ 
  } , 
  { 
    1.18793487548828125000000000000000000000000000000000e+00,   /* r[175] */ 
    -2.48455747430406659326251883612712845206260681152344e-01, /* logih[175] */ 
    -1.01487704576317129292387756236812830284397429666783e-17, /* logim[175] */ 
    -2.33655220085162222996740706004887790768032744693521e-34, /* logil[175] */ 
  } , 
  { 
    1.18518447875976562500000000000000000000000000000000e+00,   /* r[176] */ 
    -2.45111637923020875273749652478727512061595916748047e-01, /* logih[176] */ 
    7.90027454939177726382780718024180385506006420479963e-18, /* logim[176] */ 
    -7.12630269915217131628005874908549382719132579907736e-34, /* logil[176] */ 
  } , 
  { 
    1.18244743347167968750000000000000000000000000000000e+00,   /* r[177] */ 
    -2.41776048972363183375833273203170392662286758422852e-01, /* logih[177] */ 
    -1.37983625208326204093508338414984840931706541381331e-17, /* logim[177] */ 
    7.20097580628563544454377572306403550061149741436607e-34, /* logil[177] */ 
  } , 
  { 
    1.17972373962402343750000000000000000000000000000000e+00,   /* r[178] */ 
    -2.38449057776214834447614521195646375417709350585938e-01, /* logih[178] */ 
    1.09262391873895283755849310197040950453513559131684e-17, /* logim[178] */ 
    5.19474724393747239275281177964830169009947097965027e-34, /* logil[178] */ 
  } , 
  { 
    1.17701148986816406250000000000000000000000000000000e+00,   /* r[179] */ 
    -2.35128403889451498276486063332413323223590850830078e-01, /* logih[179] */ 
    -2.20620458531834175679580996316363151867859051514489e-18, /* logim[179] */ 
    9.83810838200669124655236613392658820366639819033369e-35, /* logil[179] */ 
  } , 
  { 
    1.17431259155273437500000000000000000000000000000000e+00,   /* r[180] */ 
    -2.31816492140433955126965770432434510439634323120117e-01, /* logih[180] */ 
    2.57100775389850524221489812836912330014517778962947e-18, /* logim[180] */ 
    1.00374417119546455021964629408545038692958060180549e-34, /* logil[180] */ 
  } , 
  { 
    1.17162513732910156250000000000000000000000000000000e+00,   /* r[181] */ 
    -2.28511051821717880994100369207444600760936737060547e-01, /* logih[181] */ 
    9.92032628735403930510124467196382166156697723468760e-18, /* logim[181] */ 
    6.81523716295691040818680683845702798454513605818654e-35, /* logil[181] */ 
  } , 
  { 
    1.16894912719726562500000000000000000000000000000000e+00,   /* r[182] */ 
    -2.25212144978847061960181008544168435037136077880859e-01, /* logih[182] */ 
    -1.16073487380474294909629845428878875053786683626167e-17, /* logim[182] */ 
    1.99595089821539122107001863565030748851109328863471e-34, /* logil[182] */ 
  } , 
  { 
    1.16628646850585937500000000000000000000000000000000e+00,   /* r[183] */ 
    -2.21922193282795110480520861528930254280567169189453e-01, /* logih[183] */ 
    -3.05125287362116491328592101654681002471500301574214e-18, /* logim[183] */ 
    1.83193994791768071092494646800366992102561399372769e-34, /* logil[183] */ 
  } , 
  { 
    1.16363716125488281250000000000000000000000000000000e+00,   /* r[184] */ 
    -2.18641275375243943068781504734943155199289321899414e-01, /* logih[184] */ 
    8.35804667506368175331097204734558341794896033630962e-18, /* logim[184] */ 
    -6.76361847971404643554720269553322140862967487333475e-34, /* logil[184] */ 
  } , 
  { 
    1.16099739074707031250000000000000000000000000000000e+00,   /* r[185] */ 
    -2.15364729860247627879488163671339862048625946044922e-01, /* logih[185] */ 
    6.95092875909142621207400674633981711651172609645792e-20, /* logim[185] */ 
    -2.69634411814059745570417391670366760873171411634907e-36, /* logil[185] */ 
  } , 
  { 
    1.15837097167968750000000000000000000000000000000000e+00,   /* r[186] */ 
    -2.12097354617240441143621865194290876388549804687500e-01, /* logih[186] */ 
    3.94012228039531281835195940112690671816259833936964e-18, /* logim[186] */ 
    2.35523503821099524557043963050386917863396604377712e-34, /* logil[186] */ 
  } , 
  { 
    1.15575599670410156250000000000000000000000000000000e+00,   /* r[187] */ 
    -2.08836848096523530760038056541816331446170806884766e-01, /* logih[187] */ 
    7.10684410301031817893241287396550439057323196953174e-18, /* logim[187] */ 
    4.17638182387052934717199646329356631335921484531446e-34, /* logil[187] */ 
  } , 
  { 
    1.15315246582031250000000000000000000000000000000000e+00,   /* r[188] */ 
    -2.05583273736383437269026330795895773917436599731445e-01, /* logih[188] */ 
    -1.11541224825735129654072863667548382180433494970388e-17, /* logim[188] */ 
    2.60702460469050167439470691373935621310497497561972e-34, /* logil[188] */ 
  } , 
  { 
    1.15056228637695312500000000000000000000000000000000e+00,   /* r[189] */ 
    -2.02339086834303488737774046057893428951501846313477e-01, /* logih[189] */ 
    -8.06133178191867723913541186137675666224522328881259e-18, /* logim[189] */ 
    4.69018902441109377621277031182321899995757079990517e-34, /* logil[189] */ 
  } , 
  { 
    1.14798164367675781250000000000000000000000000000000e+00,   /* r[190] */ 
    -1.99099573382730848924992983484116848558187484741211e-01, /* logih[190] */ 
    -7.82936742512703344110788328637397546846483342009157e-18, /* logim[190] */ 
    5.23473869269106466321035297990759170076861208106171e-34, /* logil[190] */ 
  } , 
  { 
    1.14541435241699218750000000000000000000000000000000e+00,   /* r[191] */ 
    -1.95869586130290290748590109615179244428873062133789e-01, /* logih[191] */ 
    1.12134985887404327493969118908772924959105352074790e-17, /* logim[191] */ 
    1.66886450547656745631907524196364853864087335213403e-34, /* logil[191] */ 
  } , 
  { 
    1.14285659790039062500000000000000000000000000000000e+00,   /* r[192] */ 
    -1.92644390011628419134837031378992833197116851806641e-01, /* logih[192] */ 
    -6.69952429363159445722018187914913034715067412521068e-18, /* logim[192] */ 
    8.89381602231133611911957806790376785637357399200603e-35, /* logil[192] */ 
  } , 
  { 
    1.14031219482421875000000000000000000000000000000000e+00,   /* r[193] */ 
    -1.89428859708889563151501533866394311189651489257812e-01, /* logih[193] */ 
    5.59630837119075206491413698162738631266398718359305e-18, /* logim[193] */ 
    -4.99136387936431477565418774749623903558226749832454e-35, /* logil[193] */ 
  } , 
  { 
    1.13777732849121093750000000000000000000000000000000e+00,   /* r[194] */ 
    -1.86218239090319481743307505894335918128490447998047e-01, /* logih[194] */ 
    3.78774956212100823689526329408930405128821433232626e-18, /* logim[194] */ 
    -3.17758760986685144372998527475489364873340117319014e-34, /* logil[194] */ 
  } , 
  { 
    1.13525581359863281250000000000000000000000000000000e+00,   /* r[195] */ 
    -1.83017424763517094765674642076191958039999008178711e-01, /* logih[195] */ 
    5.87157335095818829027440258888705251018885949838258e-18, /* logim[195] */ 
    -2.54192655149641158852181857283167049817204136167821e-34, /* logil[195] */ 
  } , 
  { 
    1.13274383544921875000000000000000000000000000000000e+00,   /* r[196] */ 
    -1.79821639523964738049954803500440903007984161376953e-01, /* logih[196] */ 
    8.22302301209080640417647229353398001438134544835098e-19, /* logim[196] */ 
    -2.52039332892153569817641206709892948549663624549042e-35, /* logil[196] */ 
  } , 
  { 
    1.13024330139160156250000000000000000000000000000000e+00,   /* r[197] */ 
    -1.76633367267372942688297143831732682883739471435547e-01, /* logih[197] */ 
    -1.91571353469448596640611671435274648642190311723695e-18, /* logim[197] */ 
    -1.21134793249841109085003066519453210454870699339190e-34, /* logil[197] */ 
  } , 
  { 
    1.12775421142578125000000000000000000000000000000000e+00,   /* r[198] */ 
    -1.73452673591511286055322216270724311470985412597656e-01, /* logih[198] */ 
    5.21283885301191031368646131342662533975361117947090e-18, /* logim[198] */ 
    -1.01368643659769709343563840800327590720656486827318e-34, /* logil[198] */ 
  } , 
  { 
    1.12527465820312500000000000000000000000000000000000e+00,   /* r[199] */ 
    -1.70277178922613403599939374544192105531692504882812e-01, /* logih[199] */ 
    1.34546625256560311153005432906921643689472370072641e-17, /* logim[199] */ 
    -2.01787346631624515685039191465892766058891822659738e-34, /* logil[199] */ 
  } , 
  { 
    1.12280654907226562500000000000000000000000000000000e+00,   /* r[200] */ 
    -1.67109383895854723967033805820392444729804992675781e-01, /* logih[200] */ 
    -6.60161109774567977756253155335787084419173665974265e-18, /* logim[200] */ 
    -5.20727010500155857942441424119648973967213145273875e-35, /* logil[200] */ 
  } , 
  { 
    1.12034988403320312500000000000000000000000000000000e+00,   /* r[201] */ 
    -1.63949354721177775751073113497113808989524841308594e-01, /* logih[201] */ 
    -1.59075426091945659534123359515275496742329136677793e-18, /* logim[201] */ 
    -8.80061355388662086427482764107757767132081769249868e-35, /* logil[201] */ 
  } , 
  { 
    1.11790466308593750000000000000000000000000000000000e+00,   /* r[202] */ 
    -1.60797157807325702405520928550686221569776535034180e-01, /* logih[202] */ 
    -1.27882485432659989407998658585334380471532522122288e-17, /* logim[202] */ 
    -1.78908761080882243046115883816432632406586944308380e-34, /* logil[202] */ 
  } , 
  { 
    1.11546897888183593750000000000000000000000000000000e+00,   /* r[203] */ 
    -1.57650392886728163421850013037328608334064483642578e-01, /* logih[203] */ 
    5.48897678434671628772441349557697552667538441741952e-19, /* logim[203] */ 
    -6.79258603184423299240762713680989948394024184442684e-36, /* logil[203] */ 
  } , 
  { 
    1.11304283142089843750000000000000000000000000000000e+00,   /* r[204] */ 
    -1.54509110639958202604304915439570322632789611816406e-01, /* logih[204] */ 
    -3.59136851163677714278758679380160119258917626559671e-19, /* logim[204] */ 
    -1.56974154580554013761421709836383374626199071205828e-35, /* logil[204] */ 
  } , 
  { 
    1.11062812805175781250000000000000000000000000000000e+00,   /* r[205] */ 
    -1.51375839568216624675400794330926146358251571655273e-01, /* logih[205] */ 
    1.85511636793595219210186133192591461270305721253330e-18, /* logim[205] */ 
    -1.91794182494587047847453803902174963816836368421214e-34, /* logil[205] */ 
  } , 
  { 
    1.10822486877441406250000000000000000000000000000000e+00,   /* r[206] */ 
    -1.48250646865354079873000614497868809849023818969727e-01, /* logih[206] */ 
    -1.01653072428705486842585428998216576160196054521775e-17, /* logim[206] */ 
    5.31584010431656413312485980487520698550209333197199e-34, /* logil[206] */ 
  } , 
  { 
    1.10583114624023437500000000000000000000000000000000e+00,   /* r[207] */ 
    -1.45131111540638235712918913122848607599735260009766e-01, /* logih[207] */ 
    -1.37520535926702420814491655344493331500786583007547e-17, /* logim[207] */ 
    -3.12537587519576338142297025257101128398882620659901e-34, /* logil[207] */ 
  } , 
  { 
    1.10344886779785156250000000000000000000000000000000e+00,   /* r[208] */ 
    -1.42019778794149176270877887873211875557899475097656e-01, /* logih[208] */ 
    -3.68499044867024074477140873097095881834850367397794e-18, /* logim[208] */ 
    -1.63017157850342774197009569405883228185646262806831e-34, /* logil[208] */ 
  } , 
  { 
    1.10107612609863281250000000000000000000000000000000e+00,   /* r[209] */ 
    -1.38914217265857425909203470837383065372705459594727e-01, /* logih[209] */ 
    -6.17799701560862884451695448882239750612348592334350e-18, /* logim[209] */ 
    -2.34837262732331600500907295169491998103701955922085e-34, /* logil[209] */ 
  } , 
  { 
    1.09871292114257812500000000000000000000000000000000e+00,   /* r[210] */ 
    -1.35814478782694425529342652225750498473644256591797e-01, /* logih[210] */ 
    -1.10878202856006564968015298269391791178600779503105e-17, /* logim[210] */ 
    -6.34363946747343426901749776771284987530057524263824e-34, /* logil[210] */ 
  } , 
  { 
    1.09635925292968750000000000000000000000000000000000e+00,   /* r[211] */ 
    -1.32720615355253201972374199613113887608051300048828e-01, /* logih[211] */ 
    5.00671269578839009481340541432441710674698094423168e-18, /* logim[211] */ 
    5.65638829687757042763410955571684820831086486484696e-35, /* logil[211] */ 
  } , 
  { 
    1.09401702880859375000000000000000000000000000000000e+00,   /* r[212] */ 
    -1.29635194425267469275908638337568845599889755249023e-01, /* logih[212] */ 
    -1.32741790693761805495822031536188642314117707435772e-17, /* logim[212] */ 
    2.36177367859446952683532192189387042515220366349614e-34, /* logil[212] */ 
  } , 
  { 
    1.09168434143066406250000000000000000000000000000000e+00,   /* r[213] */ 
    -1.26555763872087861932058672209677752107381820678711e-01, /* logih[213] */ 
    5.61175210355060094496565624276228808645454542333958e-18, /* logim[213] */ 
    2.47905722889287266912955785312024516940886239709541e-34, /* logil[213] */ 
  } , 
  { 
    1.08936119079589843750000000000000000000000000000000e+00,   /* r[214] */ 
    -1.23482376253153572354115397047280566766858100891113e-01, /* logih[214] */ 
    -5.24860550833652446049807047479312960894536533343032e-18, /* logim[214] */ 
    1.57303914080610683083254197080760577504337194439462e-34, /* logil[214] */ 
  } , 
  { 
    1.08704948425292968750000000000000000000000000000000e+00,   /* r[215] */ 
    -1.20417615674669478686986678894754732027649879455566e-01, /* logih[215] */ 
    4.98589250874990455590729277739610886330195529901588e-19, /* logim[215] */ 
    -2.77483656505407014767190386581182627944876838144956e-35, /* logil[215] */ 
  } , 
  { 
    1.08474540710449218750000000000000000000000000000000e+00,   /* r[216] */ 
    -1.17356477685791341092347295216313796117901802062988e-01, /* logih[216] */ 
    -4.43816803292478642713439762323399536218860906455113e-18, /* logim[216] */ 
    1.57142075014587982329499427592772686845625881951589e-34, /* logil[216] */ 
  } , 
  { 
    1.08245277404785156250000000000000000000000000000000e+00,   /* r[217] */ 
    -1.14304083489448829458190459718025522306561470031738e-01, /* logih[217] */ 
    -2.44497503421640839485178934251442732595447798838524e-18, /* logim[217] */ 
    9.13177011131237596027512825680515711244107356781889e-35, /* logil[217] */ 
  } , 
  { 
    1.08016967773437500000000000000000000000000000000000e+00,   /* r[218] */ 
    -1.11257954979794640437695818491192767396569252014160e-01, /* logih[218] */ 
    3.65465035573521902378371256352169641526181202186019e-18, /* logim[218] */ 
    3.01033668355988911672661379284389721222632837445285e-34, /* logil[218] */ 
  } , 
  { 
    1.07789421081542968750000000000000000000000000000000e+00,   /* r[219] */ 
    -1.08215592727541040640737435296614421531558036804199e-01, /* logih[219] */ 
    -6.38939331108877749140470530072612418291901128036500e-18, /* logim[219] */ 
    -1.57977443005077752334576053495157374607253022139958e-34, /* logil[219] */ 
  } , 
  { 
    1.07563018798828125000000000000000000000000000000000e+00,   /* r[220] */ 
    -1.05182150700728491155011568025656742975115776062012e-01, /* logih[220] */ 
    9.96668646201815079564771481993512113001566815373477e-19, /* logim[220] */ 
    -8.40901520642174694941917655898657225968386843551730e-35, /* logil[220] */ 
  } , 
  { 
    1.07337570190429687500000000000000000000000000000000e+00,   /* r[221] */ 
    -1.02155135184729670139169854792271507903933525085449e-01, /* logih[221] */ 
    9.54331694819518742321529152057292821145759268608888e-19, /* logim[221] */ 
    8.08375441648303398276921573613512412447286382908005e-35, /* logil[221] */ 
  } , 
  { 
    1.07112884521484375000000000000000000000000000000000e+00,   /* r[222] */ 
    -9.91320311358910577492764559792703948915004730224609e-02, /* logih[222] */ 
    -1.15319697956815851305646410589057158513062401209409e-19, /* logim[222] */ 
    -7.40284620248563691684694048738117565554761996111872e-36, /* logil[222] */ 
  } , 
  { 
    1.06889343261718750000000000000000000000000000000000e+00,   /* r[223] */ 
    -9.61180252768258497342301893695548642426729202270508e-02, /* logih[223] */ 
    6.85171092643411485272954560328117638640557421326159e-18, /* logim[223] */ 
    -1.67824770393390632739991704456259895006309663742546e-34, /* logil[223] */ 
  } , 
  { 
    1.06666755676269531250000000000000000000000000000000e+00,   /* r[224] */ 
    -9.31106082695352110789599464624188840389251708984375e-02, /* logih[224] */ 
    -2.26105242874531783782517748931571159031922191193177e-18, /* logim[224] */ 
    -2.03783945271517638711748368885966194474657481104373e-35, /* logil[224] */ 
  } , 
  { 
    1.06444931030273437500000000000000000000000000000000e+00,   /* r[225] */ 
    -9.01072494463056178348736580119293648749589920043945e-02, /* logih[225] */ 
    -5.44728555823394356142980742937673446468666963750632e-18, /* logim[225] */ 
    1.97413590011115023111162093321380372124491875850575e-34, /* logil[225] */ 
  } , 
  { 
    1.06224060058593750000000000000000000000000000000000e+00,   /* r[226] */ 
    -8.71105777787103824350012359900574665516614913940430e-02, /* logih[226] */ 
    -4.43564406369389579389284215323972775263708137166154e-18, /* logim[226] */ 
    1.70779313126122225936135094173405768955565424909277e-34, /* logil[226] */ 
  } , 
  { 
    1.06004142761230468750000000000000000000000000000000e+00,   /* r[227] */ 
    -8.41206480365157827083777419829857535660266876220703e-02, /* logih[227] */ 
    -3.14792226986980839484335841464619768591703354318294e-18, /* logim[227] */ 
    1.52657062057281535176853536917634594017181918735262e-34, /* logil[227] */ 
  } , 
  { 
    1.05785179138183593750000000000000000000000000000000e+00,   /* r[228] */ 
    -8.11375151493067964247885015538486186414957046508789e-02, /* logih[228] */ 
    -6.15912022353230257795364252670116201168948678312527e-18, /* logim[228] */ 
    -2.16344593340788372463481302845555712130079294383972e-34, /* logil[228] */ 
  } , 
  { 
    1.05566978454589843750000000000000000000000000000000e+00,   /* r[229] */ 
    -7.81586275943592923010072581746499054133892059326172e-02, /* logih[229] */ 
    -3.25085161347353548036706096407758727333265699647547e-18, /* logim[229] */ 
    1.63920542914931230587405015453230564450059005459335e-34, /* logil[229] */ 
  } , 
  { 
    1.05349731445312500000000000000000000000000000000000e+00,   /* r[230] */ 
    -7.51866364807085019172916418028762564063072204589844e-02, /* logih[230] */ 
    -2.54870557338844162102455061406383024497892883435493e-18, /* logim[230] */ 
    -6.59135720018155570156029431794739322327869508222348e-35, /* logil[230] */ 
  } , 
  { 
    1.05133438110351562500000000000000000000000000000000e+00,   /* r[231] */ 
    -7.22215972120476834561486612074077129364013671875000e-02, /* logih[231] */ 
    -6.64425227252169993584924920404020380947983762424339e-18, /* logim[231] */ 
    2.91013479660203574471829316747093985065960871705841e-34, /* logil[231] */ 
  } , 
  { 
    1.04918098449707031250000000000000000000000000000000e+00,   /* r[232] */ 
    -6.92635653457482070027850795668200589716434478759766e-02, /* logih[232] */ 
    -4.17058903808438561260436396327171311252509638555115e-18, /* logim[232] */ 
    3.30755248525805832232280848513964707004463090388921e-34, /* logil[232] */ 
  } , 
  { 
    1.04703521728515625000000000000000000000000000000000e+00,   /* r[233] */ 
    -6.63099684847409387433714300641440786421298980712891e-02, /* logih[233] */ 
    -8.74727269069244478292642836141302714118531385326008e-19, /* logim[233] */ 
    9.13680180722266849670406326820143717312677461406295e-35, /* logil[233] */ 
  } , 
  { 
    1.04489707946777343750000000000000000000000000000000e+00,   /* r[234] */ 
    -6.33608463694464163484809660076280124485492706298828e-02, /* logih[234] */ 
    4.88853992059804485610361972971949389543857070116405e-18, /* logim[234] */ 
    3.59584991557930488620611395470856240222060784881851e-34, /* logil[234] */ 
  } , 
  { 
    1.04277038574218750000000000000000000000000000000000e+00,   /* r[235] */ 
    -6.04215166113879487141957724816165864467620849609375e-02, /* logih[235] */ 
    3.24424348086874445666593409656049253578069669395260e-18, /* logim[235] */ 
    -1.60277475491901208789005491794898884020948020845008e-34, /* logil[235] */ 
  } , 
  { 
    1.04065132141113281250000000000000000000000000000000e+00,   /* r[236] */ 
    -5.74867630322526829145246551888703834265470504760742e-02, /* logih[236] */ 
    3.76759687947251899896914839649469366487490379203479e-19, /* logim[236] */ 
    -2.21494568010334432329216609802290865335331834512200e-35, /* logil[236] */ 
  } , 
  { 
    1.03853988647460937500000000000000000000000000000000e+00,   /* r[237] */ 
    -5.45566258253886229856455258868663804605603218078613e-02, /* logih[237] */ 
    -2.65946239302500951789232143661643591976491541288433e-18, /* logim[237] */ 
    -1.53785481060545545279952344255193134903777587882504e-34, /* logil[237] */ 
  } , 
  { 
    1.03643798828125000000000000000000000000000000000000e+00,   /* r[238] */ 
    -5.16338003108584853162454919583979062736034393310547e-02, /* logih[238] */ 
    -2.78795469954967100989074401097287044599854944339982e-18, /* logim[238] */ 
    -1.49163921524354280847709876358289989763104855468257e-34, /* logil[238] */ 
  } , 
  { 
    1.03434371948242187500000000000000000000000000000000e+00,   /* r[239] */ 
    -4.87156827428533376056485337812773650512099266052246e-02, /* logih[239] */ 
    2.96381531361489610816411758109172878093342204001504e-18, /* logim[239] */ 
    1.90369184844193639243251585798972318425548902746587e-34, /* logil[239] */ 
  } , 
  { 
    1.03225898742675781250000000000000000000000000000000e+00,   /* r[240] */ 
    -4.58049794824296474526903466539806686341762542724609e-02, /* logih[240] */ 
    1.62105752345434014647769506007451291849983142737970e-18, /* logim[240] */ 
    -9.20867893989873723178504588707200553003761945783565e-35, /* logil[240] */ 
  } , 
  { 
    1.03018188476562500000000000000000000000000000000000e+00,   /* r[241] */ 
    -4.28990763245113357338134107976657105609774589538574e-02, /* logih[241] */ 
    -6.34003512301982273340105213426264835291352971908960e-19, /* logim[241] */ 
    -3.19233228551439316201562934283596212957829301138982e-35, /* logil[241] */ 
  } , 
  { 
    1.02811241149902343750000000000000000000000000000000e+00,   /* r[242] */ 
    -3.99980141873396699558895761583698913455009460449219e-02, /* logih[242] */ 
    3.46776145155773436838304619563053637896412152479204e-18, /* logim[242] */ 
    1.18249199307224204078322468557405538276307569138571e-35, /* logil[242] */ 
  } , 
  { 
    1.02605247497558593750000000000000000000000000000000e+00,   /* r[243] */ 
    -3.71045159850557013103689030231180367991328239440918e-02, /* logih[243] */ 
    -1.51254314986204784019866874830661020957859050088050e-18, /* logim[243] */ 
    -4.62897721796816023188344967819483871559574158072420e-35, /* logil[243] */ 
  } , 
  { 
    1.02400016784667968750000000000000000000000000000000e+00,   /* r[244] */ 
    -3.42159518140385116025115053162153344601392745971680e-02, /* logih[244] */ 
    -4.20171334566300044079146136535848239242167490849902e-19, /* logim[244] */ 
    -1.97864138714387435136379874705706366605172130727980e-35, /* logil[244] */ 
  } , 
  { 
    1.02195549011230468750000000000000000000000000000000e+00,   /* r[245] */ 
    -3.13323630146640427773796488963853335008025169372559e-02, /* logih[245] */ 
    -1.60932497177386839267872885266206616652634543879907e-18, /* logim[245] */ 
    -6.28817851293024240545936211571266012891885359494453e-35, /* logil[245] */ 
  } , 
  { 
    1.01992034912109375000000000000000000000000000000000e+00,   /* r[246] */ 
    -2.84564890448900827124578682969513465650379657745361e-02, /* logih[246] */ 
    -1.32743413787410314281579343321838041020056743726823e-18, /* logim[246] */ 
    2.04618286866463010251865131532183144563010428890917e-35, /* logil[246] */ 
  } , 
  { 
    1.01789283752441406250000000000000000000000000000000e+00,   /* r[247] */ 
    -2.55856842917966814665575725484814029186964035034180e-02, /* logih[247] */ 
    -1.49154860937761055001848142233043312841087530311649e-18, /* logim[247] */ 
    2.02599394521852446744073942371740628593627411196085e-35, /* logil[247] */ 
  } , 
  { 
    1.01587295532226562500000000000000000000000000000000e+00,   /* r[248] */ 
    -2.27199905087555366345331009370056563057005405426025e-02, /* logih[248] */ 
    1.12960205619839265574985374116680854623969773242666e-18, /* logim[248] */ 
    -8.34362880258700413677035364508655979450149223832712e-35, /* logil[248] */ 
  } , 
  { 
    1.01386070251464843750000000000000000000000000000000e+00,   /* r[249] */ 
    -1.98594495836460112336840921898328815586864948272705e-02, /* logih[249] */ 
    -1.65424881469239763312059082975380380550401132087393e-20, /* logim[249] */ 
    -1.17360571247672971463309448698886739285461152534205e-36, /* logil[249] */ 
  } , 
  { 
    1.01185798645019531250000000000000000000000000000000e+00,   /* r[250] */ 
    -1.70068230155151732529983377162352553568780422210693e-02, /* logih[250] */ 
    1.27516044327499840806046149901955205004460778589711e-19, /* logim[250] */ 
    -8.52710691967735804583223211101678334615958045143104e-37, /* logil[250] */ 
  } , 
  { 
    1.00986099243164062500000000000000000000000000000000e+00,   /* r[251] */ 
    -1.41567193815739632983818907518980267923325300216675e-02, /* logih[251] */ 
    8.65690356839925383828965885125235491000373622359337e-19, /* logim[251] */ 
    -1.64494399168713442766339462748988626277364551873170e-35, /* logil[251] */ 
  } , 
  { 
    1.00787353515625000000000000000000000000000000000000e+00,   /* r[252] */ 
    -1.13146252970666803122634647138511354569345712661743e-02, /* logih[252] */ 
    3.15936714773135871052341883744882960982174189853601e-19, /* logim[252] */ 
    2.39659922006639309827564391487460990569975332009368e-35, /* logil[252] */ 
  } , 
  { 
    1.00589370727539062500000000000000000000000000000000e+00,   /* r[253] */ 
    -8.47786370355218220351556368541423580609261989593506e-03, /* logih[253] */ 
    -9.75735845129809026777533412359789145867559613642986e-20, /* logim[253] */ 
    -6.04717464355893048249602969326230504905195484152609e-37, /* logil[253] */ 
  } , 
  { 
    1.00392150878906250000000000000000000000000000000000e+00,   /* r[254] */ 
    -5.64647714981406870921043505973102583084255456924438e-03, /* logih[254] */ 
    4.32956569441265152083688702413498400247673690133916e-19, /* logim[254] */ 
    2.23027666862069486060936208535887094361283857129620e-36, /* logil[254] */ 
  } , 
  { 
    1.00195693969726562500000000000000000000000000000000e+00,   /* r[255] */ 
    -2.82050831346294375231997797470739897107705473899841e-03, /* logih[255] */ 
    2.66775679488942854129723744389995508483544623376680e-20, /* logim[255] */ 
    -8.80338525383831336492192061402657740638778525161937e-37, /* logil[255] */ 
  } }; 

 
typedef struct tPi1_t_tag {double hiM1; double hi; double mi; double lo;} tPi1_t;  
typedef struct tPi2_t_tag {double hi; double mi; double lo;} tPi2_t;  
static const tPi1_t twoPowerIndex1[32] = {
  { 
    0.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex1MOne[0] */ 
    1.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex1hi[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex1mi[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex1lo[0] */ 
  } , 
  { 
    8.46162726943132067255332051658456293807830661535263e-05, /* twoPowerIndex1MOne[1] */ 
    1.00008461627269440441523329354822635650634765625000e+00, /* twoPowerIndex1hi[1] */ 
    -9.12125999627646384986052256665186572875345252060450e-17, /* twoPowerIndex1mi[1] */ 
    3.36755111543914781718517640651013480155414711472518e-33, /* twoPowerIndex1lo[1] */ 
  } , 
  { 
    1.69239705302231071594454281381558757857419550418854e-04, /* twoPowerIndex1MOne[2] */ 
    1.00016923970530213772178740327944979071617126464844e+00, /* twoPowerIndex1hi[2] */ 
    9.33618533547846199388179470637929281332443150415515e-17, /* twoPowerIndex1mi[2] */ 
    3.77297954885090084710073756456287936644477196404411e-33, /* twoPowerIndex1lo[2] */ 
  } , 
  { 
    2.53870298429598856802813511279737213044427335262299e-04, /* twoPowerIndex1MOne[3] */ 
    1.00025387029842960373571258969604969024658203125000e+00, /* twoPowerIndex1hi[3] */ 
    -4.89064911953409381305925724006739962094640351616807e-18, /* twoPowerIndex1mi[3] */ 
    8.69701308333596579376838706167199696373572491739592e-35, /* twoPowerIndex1lo[3] */ 
  } , 
  { 
    3.38508052682312944679093869027042273955885320901871e-04, /* twoPowerIndex1MOne[4] */ 
    1.00033850805268231809463941317517310380935668945312e+00, /* twoPowerIndex1hi[4] */ 
    -5.14133393131895706530678267769194263660821897510018e-18, /* twoPowerIndex1mi[4] */ 
    3.65532984508913994275805274025238001612209382982528e-34, /* twoPowerIndex1lo[4] */ 
  } , 
  { 
    4.23152968666321135839808453837918023054953664541244e-04, /* twoPowerIndex1MOne[5] */ 
    1.00042315296866624052540828415658324956893920898438e+00, /* twoPowerIndex1hi[5] */ 
    8.06180631495321395718653515232725600012433502276551e-17, /* twoPowerIndex1mi[5] */ 
    2.27756032119564512217610282919955584270974037720845e-33, /* twoPowerIndex1lo[5] */ 
  } , 
  { 
    5.07805046987622405244011680736093694576993584632874e-04, /* twoPowerIndex1MOne[6] */ 
    1.00050780504698755279946453811135143041610717773438e+00, /* twoPowerIndex1hi[6] */ 
    6.96242402202057255168575283120383384543281723609229e-17, /* twoPowerIndex1mi[6] */ 
    5.20646484360987194687938744912769762301408608274186e-34, /* twoPowerIndex1lo[6] */ 
  } , 
  { 
    5.92464288252267119033733777655470476020127534866333e-04, /* twoPowerIndex1MOne[7] */ 
    1.00059246428825221464364858547924086451530456542969e+00, /* twoPowerIndex1hi[7] */ 
    5.24358776284676541346649133871799377889330385550410e-17, /* twoPowerIndex1mi[7] */ 
    -1.16401717083964875595275373190622641096721208508067e-33, /* twoPowerIndex1lo[7] */ 
  } , 
  { 
    6.77130693066356655063220415513569605536758899688721e-04, /* twoPowerIndex1MOne[8] */ 
    1.00067713069306640782940576173132285475730895996094e+00, /* twoPowerIndex1hi[8] */ 
    -5.11512329768566763581175858027414623025077801052578e-17, /* twoPowerIndex1mi[8] */ 
    6.98198098827029289611306311409722598417652045670746e-34, /* twoPowerIndex1lo[8] */ 
  } , 
  { 
    7.61804262036044053420236199514192776405252516269684e-04, /* twoPowerIndex1MOne[9] */ 
    1.00076180426203609208357647730736061930656433105469e+00, /* twoPowerIndex1hi[9] */ 
    -4.80106395281352797253594357274293799083867247600929e-17, /* twoPowerIndex1mi[9] */ 
    1.60659089499355510094934148076620501547799589638472e-33, /* twoPowerIndex1lo[9] */ 
  } , 
  { 
    8.46484995767533420114869802119983432930894196033478e-04, /* twoPowerIndex1MOne[10] */ 
    1.00084648499576744917760606767842546105384826660156e+00, /* twoPowerIndex1hi[10] */ 
    8.42299002458648658027371639395540881533737558365359e-17, /* twoPowerIndex1mi[10] */ 
    2.36970468083963275494383447607242933566525306383712e-33, /* twoPowerIndex1lo[10] */ 
  } , 
  { 
    9.31172894867080143919968460153313571936450898647308e-04, /* twoPowerIndex1MOne[11] */ 
    1.00093117289486710497214971837820485234260559082031e+00, /* twoPowerIndex1hi[11] */ 
    -2.48518461029926794844540008382519256098178534001306e-17, /* twoPowerIndex1mi[11] */ 
    1.46302367831163072138631641353266395843931006446965e-33, /* twoPowerIndex1lo[11] */ 
  } , 
  { 
    1.01586795994099100479135522334672714350745081901550e-03, /* twoPowerIndex1MOne[12] */ 
    1.00101586795994101919404783984646201133728027343750e+00, /* twoPowerIndex1hi[12] */ 
    -2.82452207477616780689379931990767172214919031737312e-17, /* twoPowerIndex1mi[12] */ 
    -1.95728551891328398835983018867545661396300096090192e-33, /* twoPowerIndex1lo[12] */ 
  } , 
  { 
    1.10057019159562384860717720869160984875634312629700e-03, /* twoPowerIndex1MOne[13] */ 
    1.00110057019159559565935069258557632565498352050781e+00, /* twoPowerIndex1hi[13] */ 
    2.82746405249917066780441808454827762565634907210646e-17, /* twoPowerIndex1mi[13] */ 
    2.84963022949056029094282669604361292342636089091009e-33, /* twoPowerIndex1lo[13] */ 
  } , 
  { 
    1.18527959043738845452964358884173634578473865985870e-03, /* twoPowerIndex1MOne[14] */ 
    1.00118527959043746022871346212923526763916015625000e+00, /* twoPowerIndex1hi[14] */ 
    -7.18042456559213166577815896739695813826899291527385e-17, /* twoPowerIndex1mi[14] */ 
    -4.76259460142737667571053552520587169925041399888400e-33, /* twoPowerIndex1lo[14] */ 
  } , 
  { 
    1.26999615707274501712198411240706263924948871135712e-03, /* twoPowerIndex1MOne[15] */ 
    1.00126999615707279467358148394851014018058776855469e+00, /* twoPowerIndex1hi[15] */ 
    -4.95925540000318718201054702131568017537484907271764e-17, /* twoPowerIndex1mi[15] */ 
    1.38114240085784279494535821521711378076084168967947e-33, /* twoPowerIndex1lo[15] */ 
  } , 
  { 
    1.35471989210820577265170783221037709154188632965088e-03, /* twoPowerIndex1MOne[16] */ 
    1.00135471989210822485460994357708841562271118164062e+00, /* twoPowerIndex1hi[16] */ 
    -1.89737284167929933536294189134998232481318340155287e-17, /* twoPowerIndex1mi[16] */ 
    -1.14644761608474571162584330231223616391499645510675e-34, /* twoPowerIndex1lo[16] */ 
  } , 
  { 
    1.43945079615033413172886511688375321682542562484741e-03, /* twoPowerIndex1MOne[17] */ 
    1.00143945079615037663245402654865756630897521972656e+00, /* twoPowerIndex1hi[17] */ 
    -4.25104299595813332360330451324069867137771018561227e-17, /* twoPowerIndex1mi[17] */ 
    -1.57361794708548262075721650186677311111593370726069e-33, /* twoPowerIndex1lo[17] */ 
  } , 
  { 
    1.52418886980574446246561315376766287954524159431458e-03, /* twoPowerIndex1MOne[18] */ 
    1.00152418886980565382316399336559697985649108886719e+00, /* twoPowerIndex1hi[18] */ 
    9.06044106726912172835402556659442028244667434824268e-17, /* twoPowerIndex1mi[18] */ 
    -9.28795936877474030548429956901821606468166518236870e-34, /* twoPowerIndex1lo[18] */ 
  } , 
  { 
    1.60893411368110274099751944021363669889979064464569e-03, /* twoPowerIndex1MOne[19] */ 
    1.00160893411368112637660487962421029806137084960938e+00, /* twoPowerIndex1hi[19] */ 
    -2.36264836237383004793138962370023654775211297571300e-17, /* twoPowerIndex1mi[19] */ 
    8.71910060549436570048152399632583363263947185973970e-34, /* twoPowerIndex1lo[19] */ 
  } , 
  { 
    1.69368652838312633464312728648337724735029041767120e-03, /* twoPowerIndex1MOne[20] */ 
    1.00169368652838319810882694582687690854072570800781e+00, /* twoPowerIndex1hi[20] */ 
    -7.17327634990031997530849131951948428542423257707819e-17, /* twoPowerIndex1mi[20] */ 
    6.07647560689104755979568262152596670382288431776872e-33, /* twoPowerIndex1lo[20] */ 
  } , 
  { 
    1.77844611451858400190395581574875905062071979045868e-03, /* twoPowerIndex1MOne[21] */ 
    1.00177844611451849488048537750728428363800048828125e+00, /* twoPowerIndex1hi[21] */ 
    8.90494708260750700506643975752906510626799035262348e-17, /* twoPowerIndex1mi[21] */ 
    -1.07254669154255875107094381902285900913374960884151e-33, /* twoPowerIndex1lo[21] */ 
  } , 
  { 
    1.86321287269429545878363096989005498471669852733612e-03, /* twoPowerIndex1MOne[22] */ 
    1.00186321287269430868605013529304414987564086914062e+00, /* twoPowerIndex1hi[22] */ 
    -1.33071962467226606689858482393149015112554043251841e-17, /* twoPowerIndex1mi[22] */ 
    -3.85443386097781554341108465500150047004226523597749e-34, /* twoPowerIndex1lo[22] */ 
  } , 
  { 
    1.94798680351713202930918900079859668039716780185699e-03, /* twoPowerIndex1MOne[23] */ 
    1.00194798680351704334157147968653589487075805664062e+00, /* twoPowerIndex1hi[23] */ 
    8.86950831931357794861851693306328605666305931343879e-17, /* twoPowerIndex1mi[23] */ 
    2.75565261371873441737709070275465061950835621245478e-33, /* twoPowerIndex1lo[23] */ 
  } , 
  { 
    2.03276790759401642869064197327588772168383002281189e-03, /* twoPowerIndex1MOne[24] */ 
    1.00203276790759399084151937131537124514579772949219e+00, /* twoPowerIndex1hi[24] */ 
    2.57269259432211179649018725316354562817431777421067e-17, /* twoPowerIndex1mi[24] */ 
    6.79751255613789265201334995370535043187556454092516e-34, /* twoPowerIndex1lo[24] */ 
  } , 
  { 
    2.11755618553192319700184675923537724884226918220520e-03, /* twoPowerIndex1MOne[25] */ 
    1.00211755618553199909115392074454575777053833007812e+00, /* twoPowerIndex1hi[25] */ 
    -7.60963076154928660009367289085332496679920703482915e-17, /* twoPowerIndex1mi[25] */ 
    4.75753257695507842037160015079808278438391224582425e-33, /* twoPowerIndex1lo[25] */ 
  } , 
  { 
    2.20235163793787653077616006669359194347634911537170e-03, /* twoPowerIndex1MOne[26] */ 
    1.00220235163793791599573523853905498981475830078125e+00, /* twoPowerIndex1hi[26] */ 
    -3.92993778548451720552933864302152846562830407163222e-17, /* twoPowerIndex1mi[26] */ 
    2.22740945016647607963332576015739728975193247400334e-33, /* twoPowerIndex1lo[26] */ 
  } , 
  { 
    2.28715426541895461981512838178787205833941698074341e-03, /* twoPowerIndex1MOne[27] */ 
    1.00228715426541903354973328532651066780090332031250e+00, /* twoPowerIndex1hi[27] */ 
    -7.91320298680023160041154790353287334442969086934633e-17, /* twoPowerIndex1mi[27] */ 
    4.30154033931455305578282137055178652288667345721532e-33, /* twoPowerIndex1lo[27] */ 
  } , 
  { 
    2.37196406858228422617762554125420138007029891014099e-03, /* twoPowerIndex1MOne[28] */ 
    1.00237196406858219965840817167190834879875183105469e+00, /* twoPowerIndex1hi[28] */ 
    8.46137724799471749932697856411684097253648908880386e-17, /* twoPowerIndex1mi[28] */ 
    -1.15795350476069740873680647805085951983720786847012e-33, /* twoPowerIndex1lo[28] */ 
  } , 
  { 
    2.45678104803504588835028066284849046496674418449402e-03, /* twoPowerIndex1MOne[29] */ 
    1.00245678104803515040543970826547592878341674804688e+00, /* twoPowerIndex1hi[29] */ 
    -1.04659436381151501919178287379323678295958386394535e-16, /* twoPowerIndex1mi[29] */ 
    5.63489769746205416541081978104590942612321060930815e-33, /* twoPowerIndex1lo[29] */ 
  } , 
  { 
    2.54160520438446958443878820332884060917422175407410e-03, /* twoPowerIndex1MOne[30] */ 
    1.00254160520438451165148308064090088009834289550781e+00, /* twoPowerIndex1hi[30] */ 
    -4.19488324163994025318330321149973224973566383682287e-17, /* twoPowerIndex1mi[30] */ 
    -1.10867727371575753136248480661711257993643946476249e-33, /* twoPowerIndex1lo[30] */ 
  } , 
  { 
    2.62643653823783820161485991206973267253488302230835e-03, /* twoPowerIndex1MOne[31] */ 
    1.00262643653823779743561317445710301399230957031250e+00, /* twoPowerIndex1hi[31] */ 
    4.09516010415381254633240310888754218841825131705667e-17, /* twoPowerIndex1mi[31] */ 
    4.18651539196539390512773521751259041499174185767385e-34, /* twoPowerIndex1lo[31] */ 
  } }; 
 
static const tPi2_t twoPowerIndex2[256] = {
  { 
    1.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex2hi[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex2mi[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* twoPowerIndex2lo[0] */ 
  } , 
  { 
    1.00271127505020252179690487537300214171409606933594e+00, /* twoPowerIndex2hi[1] */ 
    -3.63661592869226394431650732319448247819940912156384e-17, /* twoPowerIndex2mi[1] */ 
    -6.58076018413558386665763067745208065096307047224855e-34, /* twoPowerIndex2lo[1] */ 
  } , 
  { 
    1.00542990111280272635951860138447955250740051269531e+00, /* twoPowerIndex2hi[2] */ 
    9.49918653545503175702165599813853704096085691656846e-17, /* twoPowerIndex2mi[2] */ 
    2.69197614795285565383714012654266434015814803945559e-33, /* twoPowerIndex2lo[2] */ 
  } , 
  { 
    1.00815589811841754830368245166027918457984924316406e+00, /* twoPowerIndex2hi[3] */ 
    -3.25205875608430806088583499076669170064325943797327e-17, /* twoPowerIndex2mi[3] */ 
    2.46355206137317856028163445564386882918089954604456e-33, /* twoPowerIndex2lo[3] */ 
  } , 
  { 
    1.01088928605170047525518839393043890595436096191406e+00, /* twoPowerIndex2hi[4] */ 
    -1.52347786033685771762884896542837070154735103108242e-17, /* twoPowerIndex2mi[4] */ 
    -1.20527773363982029579667170059568717373235495431222e-33, /* twoPowerIndex2lo[4] */ 
  } , 
  { 
    1.01363008495148942955665916088037192821502685546875e+00, /* twoPowerIndex2hi[5] */ 
    9.28359976818356758749022147678502506693759778650960e-18, /* twoPowerIndex2mi[5] */ 
    4.13890589104247114331738780166693451804305210832799e-34, /* twoPowerIndex2lo[5] */ 
  } , 
  { 
    1.01637831491095309566219384578289464116096496582031e+00, /* twoPowerIndex2hi[6] */ 
    -5.77217007319966002765782626628372138987895927390512e-17, /* twoPowerIndex2mi[6] */ 
    -3.01819186434481667596632332663816426794401961980022e-34, /* twoPowerIndex2lo[6] */ 
  } , 
  { 
    1.01913399607773791366582827322417870163917541503906e+00, /* twoPowerIndex2hi[7] */ 
    3.60190498225966172216609531722640706381960474006480e-17, /* twoPowerIndex2mi[7] */ 
    -3.04390025916336453718381303520593752766892414197373e-33, /* twoPowerIndex2lo[7] */ 
  } , 
  { 
    1.02189714865411662714222984504885971546173095703125e+00, /* twoPowerIndex2hi[8] */ 
    5.10922502897344389358977529484899213711118891193073e-17, /* twoPowerIndex2mi[8] */ 
    7.88422656496927442160138555121324022911581088833303e-34, /* twoPowerIndex2lo[8] */ 
  } , 
  { 
    1.02466779289713572076436776114860549569129943847656e+00, /* twoPowerIndex2hi[9] */ 
    -7.56160786848777943963602624934464667278197265594918e-17, /* twoPowerIndex2mi[9] */ 
    3.82829708640966874425497233807001672128855640186408e-33, /* twoPowerIndex2lo[9] */ 
  } , 
  { 
    1.02744594911876374609960294037591665983200073242188e+00, /* twoPowerIndex2hi[10] */ 
    -4.95607417464537044048053918668002938932966613516228e-17, /* twoPowerIndex2mi[10] */ 
    1.52647285191522534623240430678753798210498111737407e-33, /* twoPowerIndex2lo[10] */ 
  } , 
  { 
    1.03023163768604097967340749164577573537826538085938e+00, /* twoPowerIndex2hi[11] */ 
    3.31983004108081294376648458695381123964530598047240e-17, /* twoPowerIndex2mi[11] */ 
    -6.05948719060829591517581519609021946982655246308260e-34, /* twoPowerIndex2lo[11] */ 
  } , 
  { 
    1.03302487902122841489926940994337201118469238281250e+00, /* twoPowerIndex2hi[12] */ 
    7.60083887402708848935418174694583720224989620170520e-18, /* twoPowerIndex2mi[12] */ 
    4.17547660336499599627565312970423748685953776150432e-34, /* twoPowerIndex2lo[12] */ 
  } , 
  { 
    1.03582569360195719809780712239444255828857421875000e+00, /* twoPowerIndex2hi[13] */ 
    -7.80678239133763616702426510222438085291507518120348e-17, /* twoPowerIndex2mi[13] */ 
    4.83798199689382054315888822530184564936218864541054e-34, /* twoPowerIndex2lo[13] */ 
  } , 
  { 
    1.03863410196137873064969880942953750491142272949219e+00, /* twoPowerIndex2hi[14] */ 
    5.99627378885251061843052226928644856972739702249617e-17, /* twoPowerIndex2mi[14] */ 
    -3.95663704958043112614113186183111724364471056517376e-33, /* twoPowerIndex2lo[14] */ 
  } , 
  { 
    1.04145012468831610341624127613613381981849670410156e+00, /* twoPowerIndex2hi[15] */ 
    3.78483048028757620965705119578257297756469464729973e-17, /* twoPowerIndex2mi[15] */ 
    -2.78990868974053264987416432056918863121352708112718e-33, /* twoPowerIndex2lo[15] */ 
  } , 
  { 
    1.04427378242741375480306942336028441786766052246094e+00, /* twoPowerIndex2hi[16] */ 
    8.55188970553796489217080231819249267647451456689049e-17, /* twoPowerIndex2mi[16] */ 
    -4.33079108057472301914865017639792677602990877842667e-33, /* twoPowerIndex2lo[16] */ 
  } , 
  { 
    1.04710509587928979335913481918396428227424621582031e+00, /* twoPowerIndex2hi[17] */ 
    7.27707724310431474860740275908141293488900903214077e-17, /* twoPowerIndex2mi[17] */ 
    4.72214361830876717418601268670474261741247234406534e-34, /* twoPowerIndex2lo[17] */ 
  } , 
  { 
    1.04994408580068721015265964524587616324424743652344e+00, /* twoPowerIndex2hi[18] */ 
    5.59293784812700258637018360670823030304395274991437e-17, /* twoPowerIndex2mi[18] */ 
    5.88211594754600857675576658960991674898106235024158e-33, /* twoPowerIndex2lo[18] */ 
  } , 
  { 
    1.05279077300462642341472019325010478496551513671875e+00, /* twoPowerIndex2hi[19] */ 
    -9.62948289902693573941616400549765121885820038033846e-17, /* twoPowerIndex2mi[19] */ 
    -1.08761347818786776096507022683126915318078909071327e-33, /* twoPowerIndex2lo[19] */ 
  } , 
  { 
    1.05564517836055715704901558638084679841995239257812e+00, /* twoPowerIndex2hi[20] */ 
    1.75932573877209198413667791203269037000656546957040e-18, /* twoPowerIndex2mi[20] */ 
    -1.30396724977978376996223394717384715710429730879060e-34, /* twoPowerIndex2lo[20] */ 
  } , 
  { 
    1.05850732279451276163229067606152966618537902832031e+00, /* twoPowerIndex2hi[21] */ 
    -7.15265185663778073796145114756001119612383138085358e-17, /* twoPowerIndex2mi[21] */ 
    -5.64149549927303480417353705471376517000863783007238e-33, /* twoPowerIndex2lo[21] */ 
  } , 
  { 
    1.06137722728926209292410476336954161524772644042969e+00, /* twoPowerIndex2hi[22] */ 
    -1.19735370853656575649342301877145101231593191394554e-17, /* twoPowerIndex2mi[22] */ 
    -3.24019009642435813881917735260705206101901086389479e-34, /* twoPowerIndex2lo[22] */ 
  } , 
  { 
    1.06425491288446449900106927088927477598190307617188e+00, /* twoPowerIndex2hi[23] */ 
    5.07875419861123039357382102421174755425792834691388e-17, /* twoPowerIndex2mi[23] */ 
    1.50895958491701564197395322903064350349289305322861e-33, /* twoPowerIndex2lo[23] */ 
  } , 
  { 
    1.06714040067682369716806078940862789750099182128906e+00, /* twoPowerIndex2hi[24] */ 
    -7.89985396684158212226333428391940791349522867645719e-17, /* twoPowerIndex2mi[24] */ 
    2.48773924323047906697979838020484860096229450391065e-33, /* twoPowerIndex2lo[24] */ 
  } , 
  { 
    1.07003371182024187291403904964681714773178100585938e+00, /* twoPowerIndex2hi[25] */ 
    -9.93716271128891938111903502484820565662793756924256e-17, /* twoPowerIndex2mi[25] */ 
    2.31962344798684261201922994500766835313211720477486e-34, /* twoPowerIndex2lo[25] */ 
  } , 
  { 
    1.07293486752597555522470429423265159130096435546875e+00, /* twoPowerIndex2hi[26] */ 
    -3.83966884335882380671154732420037314658136257342221e-18, /* twoPowerIndex2mi[26] */ 
    -1.99249094904898757254369089814013323079830118271091e-34, /* twoPowerIndex2lo[26] */ 
  } , 
  { 
    1.07584388906279104780594479962019249796867370605469e+00, /* twoPowerIndex2hi[27] */ 
    -1.00027161511441361124926436161855303296586383555652e-17, /* twoPowerIndex2mi[27] */ 
    6.88586299535442828962527763656910379336185001641212e-34, /* twoPowerIndex2lo[27] */ 
  } , 
  { 
    1.07876079775711986030728439800441265106201171875000e+00, /* twoPowerIndex2hi[28] */ 
    -6.65666043605659260344452997720816205593857378631714e-17, /* twoPowerIndex2mi[28] */ 
    -3.65812580131923690564246115619834327696213789275798e-33, /* twoPowerIndex2lo[28] */ 
  } , 
  { 
    1.08168561499321524976835462439339607954025268554688e+00, /* twoPowerIndex2hi[29] */ 
    -4.78262390299708626555704566711052721844264408750016e-17, /* twoPowerIndex2mi[29] */ 
    -2.29832484759747593833858703400029440154531888955339e-33, /* twoPowerIndex2lo[29] */ 
  } , 
  { 
    1.08461836221330920615457671374315395951271057128906e+00, /* twoPowerIndex2hi[30] */ 
    3.16615284581634611576111879942615084172431708553659e-17, /* twoPowerIndex2mi[30] */ 
    -7.75514267549291199158161695245488815392525791097983e-34, /* twoPowerIndex2lo[30] */ 
  } , 
  { 
    1.08755906091776965993744852312374860048294067382812e+00, /* twoPowerIndex2hi[31] */ 
    5.40934930782029075923173884363871219691387098941733e-18, /* twoPowerIndex2mi[31] */ 
    3.48154867584145263827432069924110927169603001776988e-34, /* twoPowerIndex2lo[31] */ 
  } , 
  { 
    1.09050773266525768967483145388541743159294128417969e+00, /* twoPowerIndex2hi[32] */ 
    -3.04678207981247114696551170541257032193091359539676e-17, /* twoPowerIndex2mi[32] */ 
    2.01705487848848619150139275849815038703452970938356e-33, /* twoPowerIndex2lo[32] */ 
  } , 
  { 
    1.09346439907288583981426199898123741149902343750000e+00, /* twoPowerIndex2hi[33] */ 
    1.44139581472692093419513384462869463509260880619035e-17, /* twoPowerIndex2mi[33] */ 
    4.08630093857659572006798113947020484158367259206261e-34, /* twoPowerIndex2lo[33] */ 
  } , 
  { 
    1.09642908181637688258547314035240560770034790039062e+00, /* twoPowerIndex2hi[34] */ 
    -5.91993348444931582404791974798026685003551623353440e-17, /* twoPowerIndex2mi[34] */ 
    1.11454498034154926063604046797188107791920045228203e-33, /* twoPowerIndex2lo[34] */ 
  } , 
  { 
    1.09940180263022191375910097121959552168846130371094e+00, /* twoPowerIndex2hi[35] */ 
    7.17045959970192322482531070995357544666158025777059e-17, /* twoPowerIndex2mi[35] */ 
    2.13409756277809587478782727047623660463701953626949e-33, /* twoPowerIndex2lo[35] */ 
  } , 
  { 
    1.10238258330784089089604549371870234608650207519531e+00, /* twoPowerIndex2hi[36] */ 
    5.26603687157069438656191942579725322612448063343618e-17, /* twoPowerIndex2mi[36] */ 
    6.45805397536721410708490440561131106837447579889036e-34, /* twoPowerIndex2lo[36] */ 
  } , 
  { 
    1.10537144570174117319538709125481545925140380859375e+00, /* twoPowerIndex2hi[37] */ 
    8.23928876050021358995335359335922723831311179076842e-17, /* twoPowerIndex2mi[37] */ 
    -1.04774466610247815442874156330747491506292900514778e-33, /* twoPowerIndex2lo[37] */ 
  } , 
  { 
    1.10836841172367872587756210123188793659210205078125e+00, /* twoPowerIndex2hi[38] */ 
    -8.78681384518052661557648698444116835232371902158176e-17, /* twoPowerIndex2mi[38] */ 
    -1.93068861306745460990089493247099606865877523423866e-33, /* twoPowerIndex2lo[38] */ 
  } , 
  { 
    1.11137350334481754821069898753194138407707214355469e+00, /* twoPowerIndex2hi[39] */ 
    5.56394502666969764310655992493514019038185064989534e-17, /* twoPowerIndex2mi[39] */ 
    -1.17769877519864439845431603912093657619994388212320e-33, /* twoPowerIndex2lo[39] */ 
  } , 
  { 
    1.11438674259589243220602838846389204263687133789062e+00, /* twoPowerIndex2hi[40] */ 
    1.04102784568455709549461912557590544266030834754874e-16, /* twoPowerIndex2mi[40] */ 
    1.47570167344000313963428137759389241586071635800536e-33, /* twoPowerIndex2lo[40] */ 
  } , 
  { 
    1.11740815156736927882263898936798796057701110839844e+00, /* twoPowerIndex2hi[41] */ 
    -7.97680590262822045600561531634368139010993610472575e-17, /* twoPowerIndex2mi[41] */ 
    -3.13386648600120619264244700150043196400877518036064e-33, /* twoPowerIndex2lo[41] */ 
  } , 
  { 
    1.12043775240960674643986294540809467434883117675781e+00, /* twoPowerIndex2hi[42] */ 
    -6.20108590655417874997850240693143539763038270522938e-17, /* twoPowerIndex2mi[42] */ 
    5.83820205528528388698845434843840374410554175693809e-33, /* twoPowerIndex2lo[42] */ 
  } , 
  { 
    1.12347556733301989773110562964575365185737609863281e+00, /* twoPowerIndex2hi[43] */ 
    -9.69973758898704299543613376480429793851537956846792e-17, /* twoPowerIndex2mi[43] */ 
    -2.26554127979727181051674177007680355310974340445620e-33, /* twoPowerIndex2lo[43] */ 
  } , 
  { 
    1.12652161860824184813623105583246797323226928710938e+00, /* twoPowerIndex2hi[44] */ 
    5.16585675879545673703180814711785602957687143067887e-17, /* twoPowerIndex2mi[44] */ 
    -5.65916686170716220063974592097473710424342945964456e-34, /* twoPowerIndex2lo[44] */ 
  } , 
  { 
    1.12957592856628807886920640157768502831459045410156e+00, /* twoPowerIndex2hi[45] */ 
    6.71280585872625658757968769071561199197683972848295e-17, /* twoPowerIndex2mi[45] */ 
    -1.07820162799000302104084759726971168076450417442143e-33, /* twoPowerIndex2lo[45] */ 
  } , 
  { 
    1.13263851959871919561351205629762262105941772460938e+00, /* twoPowerIndex2hi[46] */ 
    3.23735616673800026374280491083711282285071512434226e-17, /* twoPowerIndex2mi[46] */ 
    -2.17410428198276732317664547375555516673086011902827e-33, /* twoPowerIndex2lo[46] */ 
  } , 
  { 
    1.13570941415780546357439106941455975174903869628906e+00, /* twoPowerIndex2hi[47] */ 
    5.06659992612615585870979493424241383844326077647274e-17, /* twoPowerIndex2mi[47] */ 
    -1.32541787182048387837370885885176434849571625344055e-33, /* twoPowerIndex2lo[47] */ 
  } , 
  { 
    1.13878863475669156457570352358743548393249511718750e+00, /* twoPowerIndex2hi[48] */ 
    8.91281267602540777782023808215740339330966556723006e-17, /* twoPowerIndex2mi[48] */ 
    -2.00741463283249448727846279877956608996968961458494e-33, /* twoPowerIndex2lo[48] */ 
  } , 
  { 
    1.14187620396956157620138583297375589609146118164062e+00, /* twoPowerIndex2hi[49] */ 
    4.65109117753141238740817792833606106064264488933295e-17, /* twoPowerIndex2mi[49] */ 
    1.16876708285186516119099627711493197934208124175159e-33, /* twoPowerIndex2lo[49] */ 
  } , 
  { 
    1.14497214443180417298151496652280911803245544433594e+00, /* twoPowerIndex2hi[50] */ 
    4.64128989217001065651476858937308428660295061803434e-17, /* twoPowerIndex2mi[50] */ 
    2.12613258776789922762135782566899992944567171074898e-34, /* twoPowerIndex2lo[50] */ 
  } , 
  { 
    1.14807647884017893780139729642542079091072082519531e+00, /* twoPowerIndex2hi[51] */ 
    6.89774023662719177044119892069339989513569982425983e-17, /* twoPowerIndex2mi[51] */ 
    4.18470834663834509017799649540704770686179227316921e-33, /* twoPowerIndex2lo[51] */ 
  } , 
  { 
    1.15118922995298267331065744656370952725410461425781e+00, /* twoPowerIndex2hi[52] */ 
    3.25071021886382721197741051783883831627922464835734e-17, /* twoPowerIndex2mi[52] */ 
    8.89091931637927159755660842958283684863470887791663e-34, /* twoPowerIndex2lo[52] */ 
  } , 
  { 
    1.15431042059021593537693206599215045571327209472656e+00, /* twoPowerIndex2hi[53] */ 
    1.04171289462732661865012882394503754385710309711063e-16, /* twoPowerIndex2mi[53] */ 
    -5.36004208703313921208161123405733997004096829869921e-33, /* twoPowerIndex2lo[53] */ 
  } , 
  { 
    1.15744007363375112085179807763779535889625549316406e+00, /* twoPowerIndex2hi[54] */ 
    -9.12387123113440028710214564331695285968225139034901e-17, /* twoPowerIndex2mi[54] */ 
    4.33323257285343273028953697402398811817365345749781e-33, /* twoPowerIndex2lo[54] */ 
  } , 
  { 
    1.16057821202749877897986152675002813339233398437500e+00, /* twoPowerIndex2hi[55] */ 
    -3.26104020541739372182753051431941352277362975722267e-17, /* twoPowerIndex2mi[55] */ 
    7.11357834451307044066628553966351937724582011421575e-35, /* twoPowerIndex2lo[55] */ 
  } , 
  { 
    1.16372485877757747552152522985124960541725158691406e+00, /* twoPowerIndex2hi[56] */ 
    3.82920483692409349872159816102110059722238312159091e-17, /* twoPowerIndex2mi[56] */ 
    7.19709831987676327409679245188515478735702972651365e-34, /* twoPowerIndex2lo[56] */ 
  } , 
  { 
    1.16688003695248165847431209840578958392143249511719e+00, /* twoPowerIndex2hi[57] */ 
    -8.79187957999916974198229633672296429647404899187201e-17, /* twoPowerIndex2mi[57] */ 
    -2.87626642494823975790958872496361075697324563663418e-33, /* twoPowerIndex2lo[57] */ 
  } , 
  { 
    1.17004376968325018992800323758274316787719726562500e+00, /* twoPowerIndex2hi[58] */ 
    -1.84774420179000469437829606444460290025923861011560e-18, /* twoPowerIndex2mi[58] */ 
    9.95026324026540894110632007684038501192747054873613e-35, /* twoPowerIndex2lo[58] */ 
  } , 
  { 
    1.17321608016363732041043022036319598555564880371094e+00, /* twoPowerIndex2hi[59] */ 
    -7.28756258658499447915217361810881652407443644873380e-17, /* twoPowerIndex2mi[59] */ 
    -5.80514434850720922900022428546053614526438490706197e-33, /* twoPowerIndex2lo[59] */ 
  } , 
  { 
    1.17639699165028122074261318630306050181388854980469e+00, /* twoPowerIndex2hi[60] */ 
    5.55420325421807896276684328889766000203735373777665e-17, /* twoPowerIndex2mi[60] */ 
    -1.48842929343368511961710849782815827921712348302943e-33, /* twoPowerIndex2lo[60] */ 
  } , 
  { 
    1.17958652746287584456297281576553359627723693847656e+00, /* twoPowerIndex2hi[61] */ 
    1.00923127751003904353623199255548893172824487848155e-16, /* twoPowerIndex2mi[61] */ 
    2.56907593214680284136128623025833045419367581735075e-33, /* twoPowerIndex2lo[61] */ 
  } , 
  { 
    1.18278471098434101449470290390308946371078491210938e+00, /* twoPowerIndex2hi[62] */ 
    1.54297543007907605845327903967313855640292420619590e-17, /* twoPowerIndex2mi[62] */ 
    7.09719727836492954234152192412259750112212179635692e-34, /* twoPowerIndex2lo[62] */ 
  } , 
  { 
    1.18599156566099384058077248482732102274894714355469e+00, /* twoPowerIndex2hi[63] */ 
    -9.20950683529310590495224568572832186256763277535644e-18, /* twoPowerIndex2mi[63] */ 
    4.45938700163758066851795410125927948023388255302655e-34, /* twoPowerIndex2lo[63] */ 
  } , 
  { 
    1.18920711500272102689734765590401366353034973144531e+00, /* twoPowerIndex2hi[64] */ 
    3.98201523146564611098029654755651628169309930562261e-17, /* twoPowerIndex2mi[64] */ 
    1.14195965688545340101163692105448367710482873511510e-33, /* twoPowerIndex2lo[64] */ 
  } , 
  { 
    1.19243138258315117816721340204821899533271789550781e+00, /* twoPowerIndex2hi[65] */ 
    4.39755141560972144344381120574300882985513737679934e-17, /* twoPowerIndex2mi[65] */ 
    -2.41829020212771695653773640974975764989760653578657e-33, /* twoPowerIndex2lo[65] */ 
  } , 
  { 
    1.19566439203982732841780034505063667893409729003906e+00, /* twoPowerIndex2hi[66] */ 
    4.61660367048148139742806754321229408219716031742605e-17, /* twoPowerIndex2mi[66] */ 
    1.32248737144550668026460879187484144120719947949532e-33, /* twoPowerIndex2lo[66] */ 
  } , 
  { 
    1.19890616707438057986223611806053668260574340820312e+00, /* twoPowerIndex2hi[67] */ 
    -9.80919335600842311847819900738643766443372921069732e-17, /* twoPowerIndex2mi[67] */ 
    -5.29087429062105337716063232877224643258346493331853e-33, /* twoPowerIndex2lo[67] */ 
  } , 
  { 
    1.20215673145270307564658196497475728392601013183594e+00, /* twoPowerIndex2hi[68] */ 
    6.64498149925230124489270286991048474954122885069094e-17, /* twoPowerIndex2mi[68] */ 
    -3.85685255336907654452995968372311171004938395576078e-33, /* twoPowerIndex2lo[68] */ 
  } , 
  { 
    1.20541610900512385917693336523370817303657531738281e+00, /* twoPowerIndex2hi[69] */ 
    -3.35727219326752963448211014853517469169774564393197e-17, /* twoPowerIndex2mi[69] */ 
    -4.92549550862177406688591486963370003941067572015491e-34, /* twoPowerIndex2lo[69] */ 
  } , 
  { 
    1.20868432362658162482205170817906036972999572753906e+00, /* twoPowerIndex2hi[70] */ 
    -4.74672594522898409739364787077500872067787392617061e-17, /* twoPowerIndex2mi[70] */ 
    -2.39731037167046840753848687443925994516005866460984e-33, /* twoPowerIndex2lo[70] */ 
  } , 
  { 
    1.21196139927680124337427969294367358088493347167969e+00, /* twoPowerIndex2hi[71] */ 
    -4.89061107752111835731723583297106520554917182658748e-17, /* twoPowerIndex2mi[71] */ 
    3.03773638515966381050119516339532028224866436819777e-33, /* twoPowerIndex2lo[71] */ 
  } , 
  { 
    1.21524735998046895524282717815367504954338073730469e+00, /* twoPowerIndex2hi[72] */ 
    -7.71263069268148813091257203929615917892526180720328e-17, /* twoPowerIndex2mi[72] */ 
    4.71720614288499816545262331753743129502653902881319e-33, /* twoPowerIndex2lo[72] */ 
  } , 
  { 
    1.21854222982740845182547673175577074289321899414062e+00, /* twoPowerIndex2hi[73] */ 
    -9.00672695836383767486750626492663453576309245864756e-17, /* twoPowerIndex2mi[73] */ 
    5.16504109670658058144743067711083355626699725368541e-34, /* twoPowerIndex2lo[73] */ 
  } , 
  { 
    1.22184603297275762301410395593848079442977905273438e+00, /* twoPowerIndex2hi[74] */ 
    -1.06110212114026911612338140955143073076587458436915e-16, /* twoPowerIndex2mi[74] */ 
    1.60374219470078741193166884413586755813454143083569e-33, /* twoPowerIndex2lo[74] */ 
  } , 
  { 
    1.22515879363714552674480273708468303084373474121094e+00, /* twoPowerIndex2hi[75] */ 
    -8.90353381426998342947457496954569957296479418024787e-17, /* twoPowerIndex2mi[75] */ 
    -3.38239295886914309313127675019861767225893406120572e-33, /* twoPowerIndex2lo[75] */ 
  } , 
  { 
    1.22848053610687002468182527081808075308799743652344e+00, /* twoPowerIndex2hi[76] */ 
    -1.89878163130252995311948719658078062677878185721429e-17, /* twoPowerIndex2mi[76] */ 
    6.18469453652103848424687212656185051850860290411013e-34, /* twoPowerIndex2lo[76] */ 
  } , 
  { 
    1.23181128473407586199073193711228668689727783203125e+00, /* twoPowerIndex2hi[77] */ 
    7.38938247161005024655390749410851704831793332860224e-17, /* twoPowerIndex2mi[77] */ 
    5.66416860276341522848933887503853153547313928315175e-33, /* twoPowerIndex2lo[77] */ 
  } , 
  { 
    1.23515106393693341324535595049383118748664855957031e+00, /* twoPowerIndex2hi[78] */ 
    -1.07552443443078413782534550626319265988634731989314e-16, /* twoPowerIndex2mi[78] */ 
    -1.64465643112359468913735122191038582299186062892515e-33, /* twoPowerIndex2lo[78] */ 
  } , 
  { 
    1.23849989819981654015634831011993810534477233886719e+00, /* twoPowerIndex2hi[79] */ 
    2.76770205557396742995282629120281510329639442299790e-17, /* twoPowerIndex2mi[79] */ 
    2.66724789689442974848682438840669194714548350787063e-35, /* twoPowerIndex2lo[79] */ 
  } , 
  { 
    1.24185781207348400201340155035723000764846801757812e+00, /* twoPowerIndex2hi[80] */ 
    4.65802759183693679122616767654141683800114091774588e-17, /* twoPowerIndex2mi[80] */ 
    -2.31439910378785985764079190411324307370918857557275e-33, /* twoPowerIndex2lo[80] */ 
  } , 
  { 
    1.24522483017525797954760946595342829823493957519531e+00, /* twoPowerIndex2hi[81] */ 
    -4.67724044984672750044476807490179835934784763101964e-17, /* twoPowerIndex2mi[81] */ 
    -6.19614441679121104595267684200368658842294828986636e-34, /* twoPowerIndex2lo[81] */ 
  } , 
  { 
    1.24860097718920481923987608752213418483734130859375e+00, /* twoPowerIndex2hi[82] */ 
    -8.26181099902196355045651985461180951636054028345939e-17, /* twoPowerIndex2mi[82] */ 
    -3.13508520893426556972542244676107480243422253073214e-33, /* twoPowerIndex2lo[82] */ 
  } , 
  { 
    1.25198627786631622171853450709022581577301025390625e+00, /* twoPowerIndex2hi[83] */ 
    4.83416715246989759958838285593793501234849559981127e-17, /* twoPowerIndex2mi[83] */ 
    1.78566475406016519018652742315549367024352654682538e-33, /* twoPowerIndex2lo[83] */ 
  } , 
  { 
    1.25538075702469109629078047873917967081069946289062e+00, /* twoPowerIndex2hi[84] */ 
    -6.71138982129687841852821870522008036246320680675952e-18, /* twoPowerIndex2mi[84] */ 
    -5.76846264325028352862497671463784812858487529613818e-35, /* twoPowerIndex2lo[84] */ 
  } , 
  { 
    1.25878443954971652729568631912115961313247680664062e+00, /* twoPowerIndex2hi[85] */ 
    -8.42178258773059935676825219277948030487309990653640e-17, /* twoPowerIndex2mi[85] */ 
    -3.42668790982954401635344774416743553535666629313219e-33, /* twoPowerIndex2lo[85] */ 
  } , 
  { 
    1.26219735039425073885865913325687870383262634277344e+00, /* twoPowerIndex2hi[86] */ 
    -3.08446488747384646529907217460461327518172988421553e-17, /* twoPowerIndex2mi[86] */ 
    2.40882976270348351451454970147527613654722303853330e-33, /* twoPowerIndex2lo[86] */ 
  } , 
  { 
    1.26561951457880628169050396536476910114288330078125e+00, /* twoPowerIndex2hi[87] */ 
    4.25057700345086863701776979850140764907451511182054e-17, /* twoPowerIndex2mi[87] */ 
    -2.43502301511662232808349177773715412240431561172854e-33, /* twoPowerIndex2lo[87] */ 
  } , 
  { 
    1.26905095719173321988648694969015195965766906738281e+00, /* twoPowerIndex2hi[88] */ 
    2.66793213134218609522998616502989391061315227839969e-18, /* twoPowerIndex2mi[88] */ 
    -5.01723570938719050333027020376949013774930719140568e-35, /* twoPowerIndex2lo[88] */ 
  } , 
  { 
    1.27249170338940276181460831139702349901199340820312e+00, /* twoPowerIndex2hi[89] */ 
    -1.05779162672124210291083901925683986461541009150905e-17, /* twoPowerIndex2mi[89] */ 
    -2.93131904402812719815315335629352674850210527511727e-34, /* twoPowerIndex2lo[89] */ 
  } , 
  { 
    1.27594177839639200122689999261638149619102478027344e+00, /* twoPowerIndex2hi[90] */ 
    9.91543024421429032951245620636467731146795580787420e-17, /* twoPowerIndex2mi[90] */ 
    4.59759442266878048582159401225601949347063078487755e-33, /* twoPowerIndex2lo[90] */ 
  } , 
  { 
    1.27940120750566932450453805358847603201866149902344e+00, /* twoPowerIndex2hi[91] */ 
    -9.75909500835606221035467671832651562727399972211988e-17, /* twoPowerIndex2mi[91] */ 
    -1.38251039186524925998756795041289231285031751943997e-33, /* twoPowerIndex2lo[91] */ 
  } , 
  { 
    1.28287001607877826359072059858590364456176757812500e+00, /* twoPowerIndex2hi[92] */ 
    1.71359491824356096814175768900864730928374054987756e-17, /* twoPowerIndex2mi[92] */ 
    7.25131491282819461838977871983760669047046080773478e-34, /* twoPowerIndex2lo[92] */ 
  } , 
  { 
    1.28634822954602556777103927743155509233474731445312e+00, /* twoPowerIndex2hi[93] */ 
    -3.41695570693618197637835756165078424638638756108411e-17, /* twoPowerIndex2mi[93] */ 
    3.01980638845024588477534724775904900964451374240343e-33, /* twoPowerIndex2lo[93] */ 
  } , 
  { 
    1.28983587340666572274017198651563376188278198242188e+00, /* twoPowerIndex2hi[94] */ 
    8.94925753089759172194875997189204564115016328268090e-17, /* twoPowerIndex2mi[94] */ 
    1.20830737845688318745384554764993450976718105981461e-33, /* twoPowerIndex2lo[94] */ 
  } , 
  { 
    1.29333297322908946647146422037621960043907165527344e+00, /* twoPowerIndex2hi[95] */ 
    -2.97459044313275164581312778190571731582573264222880e-17, /* twoPowerIndex2mi[95] */ 
    1.16237613827319824876464974429153654014369509787634e-33, /* twoPowerIndex2lo[95] */ 
  } , 
  { 
    1.29683955465100964055125132290413603186607360839844e+00, /* twoPowerIndex2hi[96] */ 
    2.53825027948883149592910250791940344234383392801619e-17, /* twoPowerIndex2mi[96] */ 
    1.68678246461832500334243039646153124282288438904092e-34, /* twoPowerIndex2lo[96] */ 
  } , 
  { 
    1.30035564337965059422685953904874622821807861328125e+00, /* twoPowerIndex2hi[97] */ 
    5.67872810280221742200488134915364617768988996925235e-17, /* twoPowerIndex2mi[97] */ 
    -2.65697595108343105071012773811939091954697862387724e-33, /* twoPowerIndex2lo[97] */ 
  } , 
  { 
    1.30388126519193581209776766627328470349311828613281e+00, /* twoPowerIndex2hi[98] */ 
    8.64767559826787117946355165568051639464066963273840e-17, /* twoPowerIndex2mi[98] */ 
    8.70201872477350096167517355607069078597678984954289e-34, /* twoPowerIndex2lo[98] */ 
  } , 
  { 
    1.30741644593467731816360810626065358519554138183594e+00, /* twoPowerIndex2hi[99] */ 
    -7.33664565287886889230365718649852916028408328060276e-17, /* twoPowerIndex2mi[99] */ 
    -2.93367882958631685351818537761286406545337467653224e-33, /* twoPowerIndex2lo[99] */ 
  } , 
  { 
    1.31096121152476441373835314152529463171958923339844e+00, /* twoPowerIndex2hi[100] */ 
    -7.18153613551945385697245613605196258733040544776187e-17, /* twoPowerIndex2mi[100] */ 
    -2.12629266743969557140434977160228094057588798528197e-34, /* twoPowerIndex2lo[100] */ 
  } , 
  { 
    1.31451558794935463581055046233814209699630737304688e+00, /* twoPowerIndex2hi[101] */ 
    2.26754331510458564505142831387082924518590502314377e-17, /* twoPowerIndex2mi[101] */ 
    -7.52544640273480434326029480252966858598400235446401e-34, /* twoPowerIndex2lo[101] */ 
  } , 
  { 
    1.31807960126606404926974391855765134096145629882812e+00, /* twoPowerIndex2hi[102] */ 
    -5.45795582714915350249059559812768392944707787964569e-17, /* twoPowerIndex2mi[102] */ 
    3.01605678846279399154010507026593082215688854819315e-34, /* twoPowerIndex2lo[102] */ 
  } , 
  { 
    1.32165327760315753913289427146082744002342224121094e+00, /* twoPowerIndex2hi[103] */ 
    -2.48063824591302174150388078679826792820566433791932e-17, /* twoPowerIndex2mi[103] */ 
    -7.98826352342197225244683042177702410050087972196938e-34, /* twoPowerIndex2lo[103] */ 
  } , 
  { 
    1.32523664315974132321684919588733464479446411132812e+00, /* twoPowerIndex2hi[104] */ 
    -2.85873121003886137327027220806882812126373511580572e-17, /* twoPowerIndex2mi[104] */ 
    7.62021406397260431456821182703024347950927217409368e-34, /* twoPowerIndex2lo[104] */ 
  } , 
  { 
    1.32882972420595435458778865722706541419029235839844e+00, /* twoPowerIndex2hi[105] */ 
    4.08908622391016005194851803726881862830375046944341e-17, /* twoPowerIndex2mi[105] */ 
    -8.25755527905788850028602577519818711544066895869934e-34, /* twoPowerIndex2lo[105] */ 
  } , 
  { 
    1.33243254708316150036750968865817412734031677246094e+00, /* twoPowerIndex2hi[106] */ 
    -5.10158663091674395948874951281987248409217090958003e-17, /* twoPowerIndex2mi[106] */ 
    1.24161698455614255772408207369534691020717040259615e-33, /* twoPowerIndex2lo[106] */ 
  } , 
  { 
    1.33604513820414583236129146825987845659255981445312e+00, /* twoPowerIndex2hi[107] */ 
    -5.89186635638880135250424875698763827220081961896780e-17, /* twoPowerIndex2mi[107] */ 
    4.82773672901544401626262260553683707114055277401310e-33, /* twoPowerIndex2lo[107] */ 
  } , 
  { 
    1.33966752405330291608720472140703350305557250976562e+00, /* twoPowerIndex2hi[108] */ 
    8.92728259483173198426255486589831591472085466011828e-17, /* twoPowerIndex2mi[108] */ 
    -7.69657983531899254540849298389093495155758992415150e-34, /* twoPowerIndex2lo[108] */ 
  } , 
  { 
    1.34329973118683532185002604819601401686668395996094e+00, /* twoPowerIndex2hi[109] */ 
    -5.80258089020143775129607366972124060945118168095697e-17, /* twoPowerIndex2mi[109] */ 
    -5.62848183889096727330900462318018132434931156577971e-33, /* twoPowerIndex2lo[109] */ 
  } , 
  { 
    1.34694178623294580354752270068274810910224914550781e+00, /* twoPowerIndex2hi[110] */ 
    3.22406510125467916912928274924363934664289972360091e-17, /* twoPowerIndex2mi[110] */ 
    -2.51832203762622189165076753162586788705235166031733e-33, /* twoPowerIndex2lo[110] */ 
  } , 
  { 
    1.35059371589203447427962601068429648876190185546875e+00, /* twoPowerIndex2hi[111] */ 
    -8.28711038146241653260111018049835125653080776498248e-17, /* twoPowerIndex2mi[111] */ 
    2.79728744284194320208556684414100450680158956985147e-33, /* twoPowerIndex2lo[111] */ 
  } , 
  { 
    1.35425554693689265128853094211081042885780334472656e+00, /* twoPowerIndex2hi[112] */ 
    7.70094837980298946162338224151128414915778826123523e-17, /* twoPowerIndex2mi[112] */ 
    -2.24074836437395028882100810844688282941385619430371e-33, /* twoPowerIndex2lo[112] */ 
  } , 
  { 
    1.35792730621290114179089414392365142703056335449219e+00, /* twoPowerIndex2hi[113] */ 
    -9.52963574482518886708763256581296493681255450761483e-17, /* twoPowerIndex2mi[113] */ 
    3.94129059821951840862728683884868804521606133502020e-33, /* twoPowerIndex2lo[113] */ 
  } , 
  { 
    1.36160902063822475405174827756127342581748962402344e+00, /* twoPowerIndex2hi[114] */ 
    1.53378766127066804593191316699398053341331687545086e-18, /* twoPowerIndex2mi[114] */ 
    2.89261626537731219518175809165487342026413059288117e-36, /* twoPowerIndex2lo[114] */ 
  } , 
  { 
    1.36530071720401191548432962008519098162651062011719e+00, /* twoPowerIndex2hi[115] */ 
    -1.00053631259747651675482154696825016305954942740907e-16, /* twoPowerIndex2mi[115] */ 
    3.54928742268818507952779264530371584695776903628456e-33, /* twoPowerIndex2lo[115] */ 
  } , 
  { 
    1.36900242297459051599162194179370999336242675781250e+00, /* twoPowerIndex2hi[116] */ 
    9.59379791911884877255545693637832999511204427845953e-17, /* twoPowerIndex2mi[116] */ 
    -4.88674958784947176959607858061848292445663702071206e-33, /* twoPowerIndex2lo[116] */ 
  } , 
  { 
    1.37271416508766841424460380949312821030616760253906e+00, /* twoPowerIndex2hi[117] */ 
    -4.49596059523484126201398925346079480634909342749196e-17, /* twoPowerIndex2mi[117] */ 
    1.62562490898807010621996863149362627894393561257459e-33, /* twoPowerIndex2lo[117] */ 
  } , 
  { 
    1.37643597075453016920221216423669829964637756347656e+00, /* twoPowerIndex2hi[118] */ 
    -6.89858893587180104162314142277078705990308809896903e-17, /* twoPowerIndex2mi[118] */ 
    -9.23154448708427617703494512509845826869729176165562e-34, /* twoPowerIndex2lo[118] */ 
  } , 
  { 
    1.38016786726023799047879947465844452381134033203125e+00, /* twoPowerIndex2hi[119] */ 
    1.05103145799699839461846797726451249170514296493641e-16, /* twoPowerIndex2mi[119] */ 
    -5.20959403592477818815879901700610698718705668178631e-34, /* twoPowerIndex2lo[119] */ 
  } , 
  { 
    1.38390988196383202257777611521305516362190246582031e+00, /* twoPowerIndex2hi[120] */ 
    -6.77051165879478628715737183479431151106043475381389e-17, /* twoPowerIndex2mi[120] */ 
    5.25954134785524271676320971772030766300829615286373e-34, /* twoPowerIndex2lo[120] */ 
  } , 
  { 
    1.38766204229852907481301826919661834836006164550781e+00, /* twoPowerIndex2hi[121] */ 
    8.42298427487541531761909892542259393461447669376914e-17, /* twoPowerIndex2mi[121] */ 
    4.46434333442928450361645463407705485478297602125654e-33, /* twoPowerIndex2lo[121] */ 
  } , 
  { 
    1.39142437577192623621158418245613574981689453125000e+00, /* twoPowerIndex2hi[122] */ 
    -4.90617486528898932450860315361961796480813828948749e-17, /* twoPowerIndex2mi[122] */ 
    9.41947135373105773751136712580396521761942792376029e-34, /* twoPowerIndex2lo[122] */ 
  } , 
  { 
    1.39519690996620027156893684150418266654014587402344e+00, /* twoPowerIndex2hi[123] */ 
    -9.32933622422549655219151241388008074464471865703576e-17, /* twoPowerIndex2mi[123] */ 
    3.85009236000292978304841859575059463134595037095756e-33, /* twoPowerIndex2lo[123] */ 
  } , 
  { 
    1.39897967253831123635166022722842171788215637207031e+00, /* twoPowerIndex2hi[124] */ 
    -9.61421320905132307233280072508933760749140842467170e-17, /* twoPowerIndex2mi[124] */ 
    3.97465190077505680357285219692652769985214754647576e-33, /* twoPowerIndex2lo[124] */ 
  } , 
  { 
    1.40277269122020475933254601841326802968978881835938e+00, /* twoPowerIndex2hi[125] */ 
    -5.29578324940798922315924317002369067798815514694702e-17, /* twoPowerIndex2mi[125] */ 
    3.01901046243343149118437935612420792667881700875337e-33, /* twoPowerIndex2lo[125] */ 
  } , 
  { 
    1.40657599381901543544870492041809484362602233886719e+00, /* twoPowerIndex2hi[126] */ 
    7.03491481213642218799944724280847971836007996977941e-18, /* twoPowerIndex2mi[126] */ 
    -1.87515169946872014216649248611672456272335645241101e-34, /* twoPowerIndex2lo[126] */ 
  } , 
  { 
    1.41038960821727066274888784391805529594421386718750e+00, /* twoPowerIndex2hi[127] */ 
    4.16654872843506225899503851018795172623979530606656e-17, /* twoPowerIndex2mi[127] */ 
    -2.40474814922300276552970992509731322006163156322473e-33, /* twoPowerIndex2lo[127] */ 
  } , 
  { 
    1.41421356237309514547462185873882845044136047363281e+00, /* twoPowerIndex2hi[128] */ 
    -9.66729331345291345105469972976694765012981670542977e-17, /* twoPowerIndex2mi[128] */ 
    4.13867530869941356271900493210877889450985709540127e-33, /* twoPowerIndex2lo[128] */ 
  } , 
  { 
    1.41804788432041517509674122266005724668502807617188e+00, /* twoPowerIndex2hi[129] */ 
    2.27443854218552945230015468607785816403034626672752e-17, /* twoPowerIndex2mi[129] */ 
    6.11983793133626012461813597014932765313298826737750e-34, /* twoPowerIndex2lo[129] */ 
  } , 
  { 
    1.42189260216916557588717751059448346495628356933594e+00, /* twoPowerIndex2hi[130] */ 
    -1.60778289158902441338409661475962612292273904731179e-17, /* twoPowerIndex2mi[130] */ 
    7.68807227837949092746953551637615091691382851311989e-34, /* twoPowerIndex2lo[130] */ 
  } , 
  { 
    1.42574774410549420800009556842269375920295715332031e+00, /* twoPowerIndex2hi[131] */ 
    9.88069075850060728430483918067849097743150129356283e-17, /* twoPowerIndex2mi[131] */ 
    -5.89890673162487333450312700634529433299513739860251e-34, /* twoPowerIndex2lo[131] */ 
  } , 
  { 
    1.42961333839197002326670826732879504561424255371094e+00, /* twoPowerIndex2hi[132] */ 
    -1.20316424890536551791763281075597751007148682598677e-17, /* twoPowerIndex2mi[132] */ 
    3.96492532243389364766543780399018506300743370884771e-35, /* twoPowerIndex2lo[132] */ 
  } , 
  { 
    1.43348941336778890054404200782300904393196105957031e+00, /* twoPowerIndex2hi[133] */ 
    -5.80245424392682610310488944560210655448170298910740e-17, /* twoPowerIndex2mi[133] */ 
    -1.27850570502833499820846554122319062699206032852878e-33, /* twoPowerIndex2lo[133] */ 
  } , 
  { 
    1.43737599744898236764356624917127192020416259765625e+00, /* twoPowerIndex2hi[134] */ 
    -4.20403401646755661224775048184723117388682958150796e-17, /* twoPowerIndex2mi[134] */ 
    -7.70667502347783805122329265482919129596484289448427e-34, /* twoPowerIndex2lo[134] */ 
  } , 
  { 
    1.44127311912862565712600826373090967535972595214844e+00, /* twoPowerIndex2hi[135] */ 
    5.60250365087898567500720975825924684730592892906837e-18, /* twoPowerIndex2mi[135] */ 
    -1.78220423347129903406970040172107023860560188781295e-34, /* twoPowerIndex2lo[135] */ 
  } , 
  { 
    1.44518080697704665027458759141154587268829345703125e+00, /* twoPowerIndex2hi[136] */ 
    -3.02375813499398731939978948265280760393682335269040e-17, /* twoPowerIndex2mi[136] */ 
    -1.77301195820250091791088617662298487007284882395542e-33, /* twoPowerIndex2lo[136] */ 
  } , 
  { 
    1.44909908964203504311285541916731745004653930664062e+00, /* twoPowerIndex2hi[137] */ 
    -6.25940500081930925440932857364551992320704493612607e-17, /* twoPowerIndex2mi[137] */ 
    -2.36452377319288878996205003453964701184928253771460e-33, /* twoPowerIndex2lo[137] */ 
  } , 
  { 
    1.45302799584905262264555858564563095569610595703125e+00, /* twoPowerIndex2hi[138] */ 
    -5.77994860939610610226179416579990281210592783980168e-17, /* twoPowerIndex2mi[138] */ 
    4.65449358394055530593548186610866020262848130035371e-33, /* twoPowerIndex2lo[138] */ 
  } , 
  { 
    1.45696755440144376514410851086722686886787414550781e+00, /* twoPowerIndex2hi[139] */ 
    5.64867945387699814049307308799040836462273423076302e-17, /* twoPowerIndex2mi[139] */ 
    5.24967327842642970132560251109596346953497158893017e-33, /* twoPowerIndex2lo[139] */ 
  } , 
  { 
    1.46091779418064704465507475106278434395790100097656e+00, /* twoPowerIndex2hi[140] */ 
    -5.60037718607521580013156831807759453639536208267684e-17, /* twoPowerIndex2mi[140] */ 
    -4.80948804890004400970317146361816382779746350931714e-33, /* twoPowerIndex2lo[140] */ 
  } , 
  { 
    1.46487874414640573128565392835298553109169006347656e+00, /* twoPowerIndex2hi[141] */ 
    9.53076754358715731899854652788308463901335051797481e-17, /* twoPowerIndex2mi[141] */ 
    -3.69846856553667878907707087404919621014972996085084e-34, /* twoPowerIndex2lo[141] */ 
  } , 
  { 
    1.46885043333698184220281746092950925230979919433594e+00, /* twoPowerIndex2hi[142] */ 
    8.46588275653362760829764150554853775141300918573480e-17, /* twoPowerIndex2mi[142] */ 
    -3.90998276339861143341660977862311141233961685102469e-33, /* twoPowerIndex2lo[142] */ 
  } , 
  { 
    1.47283289086936752809720019286032766103744506835938e+00, /* twoPowerIndex2hi[143] */ 
    6.69177408194058937165142250867005391292400049525410e-17, /* twoPowerIndex2mi[143] */ 
    -8.03669204969698754299165627994407636733379029439982e-34, /* twoPowerIndex2lo[143] */ 
  } , 
  { 
    1.47682614593949934622685304930200800299644470214844e+00, /* twoPowerIndex2hi[144] */ 
    -3.48399455689279579579151031868718147769491495422105e-17, /* twoPowerIndex2mi[144] */ 
    -1.21157704523090580028169713170353136148082368354920e-34, /* twoPowerIndex2lo[144] */ 
  } , 
  { 
    1.48083022782247186732718091661809012293815612792969e+00, /* twoPowerIndex2hi[145] */ 
    -9.68695210263061857840747540204704607519762865792956e-17, /* twoPowerIndex2mi[145] */ 
    -1.83093426853584085824897446366702716297781292402913e-33, /* twoPowerIndex2lo[145] */ 
  } , 
  { 
    1.48484516587275239274390514765400439500808715820312e+00, /* twoPowerIndex2hi[146] */ 
    1.07800867644074807558776439636082922597575014362313e-16, /* twoPowerIndex2mi[146] */ 
    -5.64322930459841965610869302140803670685265398096703e-33, /* twoPowerIndex2lo[146] */ 
  } , 
  { 
    1.48887098952439700383365561719983816146850585937500e+00, /* twoPowerIndex2hi[147] */ 
    6.15536715774287133031442683555328448918198696888232e-17, /* twoPowerIndex2mi[147] */ 
    -4.97910816988088435273822881157670080090569125411939e-33, /* twoPowerIndex2lo[147] */ 
  } , 
  { 
    1.49290772829126483500772337720263749361038208007812e+00, /* twoPowerIndex2hi[148] */ 
    1.41929201542840357707378184476885202767753055101956e-17, /* twoPowerIndex2mi[148] */ 
    2.77326329344780505247628358108799734324783290873618e-34, /* twoPowerIndex2lo[148] */ 
  } , 
  { 
    1.49695541176723545540028226241702213883399963378906e+00, /* twoPowerIndex2hi[149] */ 
    -2.86166325389915821108552064438047364932070584938283e-17, /* twoPowerIndex2mi[149] */ 
    1.69686608128918952548566738297292377457978745974095e-33, /* twoPowerIndex2lo[149] */ 
  } , 
  { 
    1.50101406962642558440279572096187621355056762695312e+00, /* twoPowerIndex2hi[150] */ 
    -6.41376727579023503858812048925241405475211237704851e-17, /* twoPowerIndex2mi[150] */ 
    2.82195851325152411917232690264483764919093983459578e-33, /* twoPowerIndex2lo[150] */ 
  } , 
  { 
    1.50508373162340647333223841997096315026283264160156e+00, /* twoPowerIndex2hi[151] */ 
    7.07471061358284636428966552102679897344999964477370e-17, /* twoPowerIndex2mi[151] */ 
    5.47182451113168633513345414695618261455556199846033e-33, /* twoPowerIndex2lo[151] */ 
  } , 
  { 
    1.50916442759342284141155232646269723773002624511719e+00, /* twoPowerIndex2hi[152] */ 
    -1.01645532775429503910501990740249618370059871055172e-16, /* twoPowerIndex2mi[152] */ 
    2.04191706967403438352422808603561166583202022922508e-34, /* twoPowerIndex2lo[152] */ 
  } , 
  { 
    1.51325618745260981334865846292814239859580993652344e+00, /* twoPowerIndex2hi[153] */ 
    8.88449785133871209092649041499311129526944241199989e-17, /* twoPowerIndex2mi[153] */ 
    2.91936471176098668822594707319785335362070597228113e-33, /* twoPowerIndex2lo[153] */ 
  } , 
  { 
    1.51735904119821474189677701360778883099555969238281e+00, /* twoPowerIndex2hi[154] */ 
    -4.30869947204334080070359075619950231322291381069658e-17, /* twoPowerIndex2mi[154] */ 
    -2.07710051583928391994432084290324754641836773161677e-33, /* twoPowerIndex2lo[154] */ 
  } , 
  { 
    1.52147301890881458952264893014216795563697814941406e+00, /* twoPowerIndex2hi[155] */ 
    -5.99638767594568341984511314492633394994506478752408e-18, /* twoPowerIndex2mi[155] */ 
    3.17143766271956082831607786726725332519992796566057e-34, /* twoPowerIndex2lo[155] */ 
  } , 
  { 
    1.52559815074453841710067081294255331158638000488281e+00, /* twoPowerIndex2hi[156] */ 
    -1.10249417123425609363148008789604625195179292613569e-16, /* twoPowerIndex2mi[156] */ 
    -2.99382882637137806007903782085057425945683820190483e-33, /* twoPowerIndex2lo[156] */ 
  } , 
  { 
    1.52973446694728698602716576715465635061264038085938e+00, /* twoPowerIndex2hi[157] */ 
    3.78579211515721965312581373704701424608681121499690e-17, /* twoPowerIndex2mi[157] */ 
    -1.13571103486415982326219089189691662922640586007719e-33, /* twoPowerIndex2lo[157] */ 
  } , 
  { 
    1.53388199784095591304833305912325158715248107910156e+00, /* twoPowerIndex2hi[158] */ 
    8.87522684443844614134710276926299051548575116130438e-17, /* twoPowerIndex2mi[158] */ 
    5.65828980010215437966290324879670843424190599145086e-33, /* twoPowerIndex2lo[158] */ 
  } , 
  { 
    1.53804077383165682668675344757502898573875427246094e+00, /* twoPowerIndex2hi[159] */ 
    1.01746723511613592944060366030036337911942910864054e-16, /* twoPowerIndex2mi[159] */ 
    -6.16113785188921653281369270464531950196652324750545e-33, /* twoPowerIndex2lo[159] */ 
  } , 
  { 
    1.54221082540794074411394376511452719569206237792969e+00, /* twoPowerIndex2hi[160] */ 
    7.94983480969762085616103882937991564856794389991833e-17, /* twoPowerIndex2mi[160] */ 
    -9.15995637410036729585390444224530830478731117122757e-34, /* twoPowerIndex2lo[160] */ 
  } , 
  { 
    1.54639218314102144802291149972006678581237792968750e+00, /* twoPowerIndex2hi[161] */ 
    1.06839600056572198027549065429961389678954641782420e-16, /* twoPowerIndex2mi[161] */ 
    5.83718082376326468071834720519101607593932706278383e-33, /* twoPowerIndex2lo[161] */ 
  } , 
  { 
    1.55058487768499997372373400139622390270233154296875e+00, /* twoPowerIndex2hi[162] */ 
    -1.46007065906893851790690523707186238729906746210228e-17, /* twoPowerIndex2mi[162] */ 
    -4.77975052472883005267659258241957348576642768400574e-34, /* twoPowerIndex2lo[162] */ 
  } , 
  { 
    1.55478893977708865214992783876368775963783264160156e+00, /* twoPowerIndex2hi[163] */ 
    -8.00316135011603564103663107910618902189361743978666e-17, /* twoPowerIndex2mi[163] */ 
    3.43160502571587532396871747107270731912475137535806e-33, /* twoPowerIndex2lo[163] */ 
  } , 
  { 
    1.55900440023783692922165755589958280324935913085938e+00, /* twoPowerIndex2hi[164] */ 
    3.78120705335752750188190562589679090842557793649900e-17, /* twoPowerIndex2mi[164] */ 
    5.94230221045385633407443935898656310894518533675204e-35, /* twoPowerIndex2lo[164] */ 
  } , 
  { 
    1.56323128997135762929815427924040704965591430664062e+00, /* twoPowerIndex2hi[165] */ 
    7.48477764559073438896405945862770341857979941287485e-17, /* twoPowerIndex2mi[165] */ 
    4.94341409405079431354025041618045920322070178828810e-33, /* twoPowerIndex2lo[165] */ 
  } , 
  { 
    1.56746963996555299658552939945366233587265014648438e+00, /* twoPowerIndex2hi[166] */ 
    -1.03520617688497219882501733748772197895029551157134e-16, /* twoPowerIndex2mi[166] */ 
    2.69762629340863925921698542881054318260398435611831e-33, /* twoPowerIndex2lo[166] */ 
  } , 
  { 
    1.57171948129234140267840302840340882539749145507812e+00, /* twoPowerIndex2hi[167] */ 
    -3.34298400468720006928343525035325490394427299333229e-17, /* twoPowerIndex2mi[167] */ 
    -2.50544082539015029477640638701507533908898561837361e-33, /* twoPowerIndex2lo[167] */ 
  } , 
  { 
    1.57598084510788649659218663146020844578742980957031e+00, /* twoPowerIndex2hi[168] */ 
    -1.01369164712783039807957177429288269249745537889645e-17, /* twoPowerIndex2mi[168] */ 
    5.43913851556220712785038586461119929989856637311730e-34, /* twoPowerIndex2lo[168] */ 
  } , 
  { 
    1.58025376265282457843852625956060364842414855957031e+00, /* twoPowerIndex2hi[169] */ 
    -5.16340292955446806158689134977166394905402588028521e-17, /* twoPowerIndex2mi[169] */ 
    -1.98856458425291225043917897550918006467398545517999e-33, /* twoPowerIndex2lo[169] */ 
  } , 
  { 
    1.58453826525249374945758518151706084609031677246094e+00, /* twoPowerIndex2hi[170] */ 
    -1.93377170345857029303925724496164498303135170130746e-17, /* twoPowerIndex2mi[170] */ 
    -9.89372992541829104414473016298122291261880812772281e-35, /* twoPowerIndex2lo[170] */ 
  } , 
  { 
    1.58883438431716395022874621645314618945121765136719e+00, /* twoPowerIndex2hi[171] */ 
    -5.99495011882447940051706621855722696087552777078266e-18, /* twoPowerIndex2mi[171] */ 
    3.40432693814393853234442560718610272389282350802004e-34, /* twoPowerIndex2lo[171] */ 
  } , 
  { 
    1.59314215134226699888131406623870134353637695312500e+00, /* twoPowerIndex2hi[172] */ 
    -1.00944065423119637216151952902063201612012779755882e-16, /* twoPowerIndex2mi[172] */ 
    4.60848399034962572477662350836868643017178368092553e-33, /* twoPowerIndex2lo[172] */ 
  } , 
  { 
    1.59746159790862707339442749798763543367385864257812e+00, /* twoPowerIndex2hi[173] */ 
    2.48683927962209992068662736190579938975994331984811e-17, /* twoPowerIndex2mi[173] */ 
    -1.50139044932662639156159749783676630723204028336974e-33, /* twoPowerIndex2lo[173] */ 
  } , 
  { 
    1.60179275568269341434302077686879783868789672851562e+00, /* twoPowerIndex2hi[174] */ 
    -6.05491745352778434252262534739031747865810833110836e-17, /* twoPowerIndex2mi[174] */ 
    -7.86094560028510434095753390665330649540069137640692e-34, /* twoPowerIndex2lo[174] */ 
  } , 
  { 
    1.60613565641677102924234077363507822155952453613281e+00, /* twoPowerIndex2hi[175] */ 
    -1.03545452880599952590528959597961463687339938363058e-16, /* twoPowerIndex2mi[175] */ 
    1.51213609096324399449109200330291470931948233371206e-33, /* twoPowerIndex2lo[175] */ 
  } , 
  { 
    1.61049033194925428347232809755951166152954101562500e+00, /* twoPowerIndex2hi[176] */ 
    2.47071925697978878522451183466139791436957933053447e-17, /* twoPowerIndex2mi[176] */ 
    1.06968477888935897586507304780358756526593706030066e-33, /* twoPowerIndex2lo[176] */ 
  } , 
  { 
    1.61485681420486071324660315440269187092781066894531e+00, /* twoPowerIndex2hi[177] */ 
    -7.31666339912512326264416948227914471406433964055342e-17, /* twoPowerIndex2mi[177] */ 
    -1.01595252547599872757692201057811430532632162793873e-33, /* twoPowerIndex2lo[177] */ 
  } , 
  { 
    1.61923513519486372835842757922364398837089538574219e+00, /* twoPowerIndex2hi[178] */ 
    2.09413341542290924068018622986227170935043667427799e-17, /* twoPowerIndex2mi[178] */ 
    1.27693128474282181836038535044586644559852980247542e-35, /* twoPowerIndex2lo[178] */ 
  } , 
  { 
    1.62362532701732886764034446969162672758102416992188e+00, /* twoPowerIndex2hi[179] */ 
    -3.58451285141447470995906396542340522908345291030162e-17, /* twoPowerIndex2mi[179] */ 
    2.01654731462508044313244700316326841947169625164993e-33, /* twoPowerIndex2lo[179] */ 
  } , 
  { 
    1.62802742185734783397776936908485367894172668457031e+00, /* twoPowerIndex2hi[180] */ 
    -6.71295508470708408629558620522800193343463268850872e-17, /* twoPowerIndex2mi[180] */ 
    1.86124288813399584090278118171650158752835667500490e-33, /* twoPowerIndex2lo[180] */ 
  } , 
  { 
    1.63244145198727497181323542463360354304313659667969e+00, /* twoPowerIndex2hi[181] */ 
    9.85281923042999296413676989512408187295863462194442e-17, /* twoPowerIndex2mi[181] */ 
    5.29569525404258920205362940337854972086009006345576e-33, /* twoPowerIndex2lo[181] */ 
  } , 
  { 
    1.63686744976696441078445332095725461840629577636719e+00, /* twoPowerIndex2hi[182] */ 
    7.69832507131987557450420469117071256581189667741842e-17, /* twoPowerIndex2mi[182] */ 
    4.09860242950305193227828568999385703476733354155568e-33, /* twoPowerIndex2lo[182] */ 
  } , 
  { 
    1.64130544764400632118395151337608695030212402343750e+00, /* twoPowerIndex2hi[183] */ 
    -9.24756873764070550805453694792420241616904847542502e-17, /* twoPowerIndex2mi[183] */ 
    -5.66841671716411725558391721762496706416420121341510e-33, /* twoPowerIndex2lo[183] */ 
  } , 
  { 
    1.64575547815396494577555586147354915738105773925781e+00, /* twoPowerIndex2hi[184] */ 
    -1.01256799136747726037875241569662212149731136230039e-16, /* twoPowerIndex2mi[184] */ 
    -6.73838498803664271467304077725442401461793880458369e-34, /* twoPowerIndex2lo[184] */ 
  } , 
  { 
    1.65021757392061774183389388781506568193435668945312e+00, /* twoPowerIndex2hi[185] */ 
    9.13327958872990419009159019732303823956193063692260e-18, /* twoPowerIndex2mi[185] */ 
    3.31329049471088319516103160150508562888797231765374e-34, /* twoPowerIndex2lo[185] */ 
  } , 
  { 
    1.65469176765619430113929411163553595542907714843750e+00, /* twoPowerIndex2hi[186] */ 
    9.64329430319602866138745392638249192962312397541490e-17, /* twoPowerIndex2mi[186] */ 
    -4.32763297888919888932772949708066540512036129088577e-33, /* twoPowerIndex2lo[186] */ 
  } , 
  { 
    1.65917809216161615815110508265206590294837951660156e+00, /* twoPowerIndex2hi[187] */ 
    -7.27554555082305065439455737740507311483946617362319e-17, /* twoPowerIndex2mi[187] */ 
    3.10484891456420478411627075503167773401278965655170e-33, /* twoPowerIndex2lo[187] */ 
  } , 
  { 
    1.66367658032673637613640948984539136290550231933594e+00, /* twoPowerIndex2hi[188] */ 
    5.89099269671309967045155789620226639428173542900082e-17, /* twoPowerIndex2mi[188] */ 
    2.37785299276765025315795732233641105960161859663372e-33, /* twoPowerIndex2lo[188] */ 
  } , 
  { 
    1.66818726513058246396781214571092277765274047851562e+00, /* twoPowerIndex2hi[189] */ 
    4.26917801957061509059398373181907237215463008872616e-17, /* twoPowerIndex2mi[189] */ 
    -1.29778952562173962775902833320678339532997660143370e-33, /* twoPowerIndex2lo[189] */ 
  } , 
  { 
    1.67271017964159662838596887013409286737442016601562e+00, /* twoPowerIndex2hi[190] */ 
    -5.47671596459956307615994670748846981852905207478754e-17, /* twoPowerIndex2mi[190] */ 
    -6.83184087311466618520328543794554690349915956941633e-34, /* twoPowerIndex2lo[190] */ 
  } , 
  { 
    1.67724535701787846875276954961009323596954345703125e+00, /* twoPowerIndex2hi[191] */ 
    8.30394950995073278534724188038576562525621449256837e-17, /* twoPowerIndex2mi[191] */ 
    -3.67907931420049303621015743180896250029187335304385e-33, /* twoPowerIndex2lo[191] */ 
  } , 
  { 
    1.68179283050742900407215074665145948529243469238281e+00, /* twoPowerIndex2hi[192] */ 
    8.19901002058149652012724391042374107310082144797238e-17, /* twoPowerIndex2mi[192] */ 
    5.10351519472809316392686812760480457926425713861784e-33, /* twoPowerIndex2lo[192] */ 
  } , 
  { 
    1.68635263344839336774327875900780782103538513183594e+00, /* twoPowerIndex2hi[193] */ 
    -7.18146327835801067471572934253931013376714544778519e-17, /* twoPowerIndex2mi[193] */ 
    3.52898289014887861077288846281933083915589270719972e-33, /* twoPowerIndex2lo[193] */ 
  } , 
  { 
    1.69092479926930527867057207913603633642196655273438e+00, /* twoPowerIndex2hi[194] */ 
    -9.66967147439488016589832627855454450790922345010565e-17, /* twoPowerIndex2mi[194] */ 
    1.93673800521759096892309246646768463294752053454796e-33, /* twoPowerIndex2lo[194] */ 
  } , 
  { 
    1.69550936148933262259674847882706671953201293945312e+00, /* twoPowerIndex2hi[195] */ 
    7.23841687284516664081325689368355266258278971330115e-17, /* twoPowerIndex2mi[195] */ 
    -4.72142878783650889336226782989306533177552216168780e-33, /* twoPowerIndex2lo[195] */ 
  } , 
  { 
    1.70010635371852347752508194389520213007926940917969e+00, /* twoPowerIndex2hi[196] */ 
    -8.02371937039770024588528464451482959960563128920877e-18, /* twoPowerIndex2mi[196] */ 
    4.50894675051846528463958043437010583905518288996850e-34, /* twoPowerIndex2lo[196] */ 
  } , 
  { 
    1.70471580965805125096323990874225273728370666503906e+00, /* twoPowerIndex2hi[197] */ 
    -2.72888328479728156256649817220242427763035044600143e-17, /* twoPowerIndex2mi[197] */ 
    -4.78966969731514783785812327748180984426830295688131e-34, /* twoPowerIndex2lo[197] */ 
  } , 
  { 
    1.70933776310046292579158944135997444391250610351562e+00, /* twoPowerIndex2hi[198] */ 
    -9.86877945663293107628372224517314496289872901148114e-17, /* twoPowerIndex2mi[198] */ 
    -6.85025222060857007426626094774522285678578778256981e-34, /* twoPowerIndex2lo[198] */ 
  } , 
  { 
    1.71397224792992597386387387814465910196304321289062e+00, /* twoPowerIndex2hi[199] */ 
    6.47397510775336706412073988816560535911210776420163e-17, /* twoPowerIndex2mi[199] */ 
    2.27573149080872552498096897849055426251128097439426e-33, /* twoPowerIndex2lo[199] */ 
  } , 
  { 
    1.71861929812247793414314855908742174506187438964844e+00, /* twoPowerIndex2hi[200] */ 
    -1.85138041826311098821086356969536380719870481925638e-17, /* twoPowerIndex2mi[200] */ 
    6.41562962530571009881963439719259893730039269925891e-34, /* twoPowerIndex2lo[200] */ 
  } , 
  { 
    1.72327894774627399243627223768271505832672119140625e+00, /* twoPowerIndex2hi[201] */ 
    -9.52212380039379996274889157686297699809734122180713e-17, /* twoPowerIndex2mi[201] */ 
    2.02866645853394952359480765489840261160247275266736e-33, /* twoPowerIndex2lo[201] */ 
  } , 
  { 
    1.72795123096183766975286744127515703439712524414062e+00, /* twoPowerIndex2hi[202] */ 
    -1.07509818612046424458879695751780763147087565420428e-16, /* twoPowerIndex2mi[202] */ 
    -1.61412967076299755734407780884081362069739071884994e-34, /* twoPowerIndex2lo[202] */ 
  } , 
  { 
    1.73263618202231106657507098134374246001243591308594e+00, /* twoPowerIndex2hi[203] */ 
    -1.69805107431541549406538664930124317335159068906677e-18, /* twoPowerIndex2mi[203] */ 
    -2.66402312008479346328768862816128097997745127782773e-35, /* twoPowerIndex2lo[203] */ 
  } , 
  { 
    1.73733383527370621735030908894259482622146606445312e+00, /* twoPowerIndex2hi[204] */ 
    3.16438929929295694659064288262436215220581330791541e-17, /* twoPowerIndex2mi[204] */ 
    2.46812086524635182684409036079744664142196277491485e-33, /* twoPowerIndex2lo[204] */ 
  } , 
  { 
    1.74204422515515644498407255014171823859214782714844e+00, /* twoPowerIndex2hi[205] */ 
    -1.52595911895078879235703824049564298322445354780003e-18, /* twoPowerIndex2mi[205] */ 
    -8.17523608900014455382082672926541929180458870718501e-35, /* twoPowerIndex2lo[205] */ 
  } , 
  { 
    1.74676738619916904760032139165559783577919006347656e+00, /* twoPowerIndex2hi[206] */ 
    -1.07522904835075145041783457030040618806351398410292e-16, /* twoPowerIndex2mi[206] */ 
    8.90461808811939147294432800114435837044658194814041e-34, /* twoPowerIndex2lo[206] */ 
  } , 
  { 
    1.75150335303187820734649449150310829281806945800781e+00, /* twoPowerIndex2hi[207] */ 
    -5.12445042059672465938775283877530577740069995954300e-17, /* twoPowerIndex2mi[207] */ 
    -1.10691385189430357525360305608492620313871007739409e-33, /* twoPowerIndex2lo[207] */ 
  } , 
  { 
    1.75625216037329945351075366488657891750335693359375e+00, /* twoPowerIndex2hi[208] */ 
    2.96014069544887330703087179323550026749650613893620e-17, /* twoPowerIndex2mi[208] */ 
    1.23348227448930022362949427574612725745479960698002e-33, /* twoPowerIndex2lo[208] */ 
  } , 
  { 
    1.76101384303758390359462282503955066204071044921875e+00, /* twoPowerIndex2hi[209] */ 
    -7.94325312503922771056589226542000745919657831036441e-17, /* twoPowerIndex2mi[209] */ 
    -1.04403750867744833163298565704167076212852668996068e-33, /* twoPowerIndex2lo[209] */ 
  } , 
  { 
    1.76578843593327272643023206910584121942520141601562e+00, /* twoPowerIndex2hi[210] */ 
    9.46131501808326786659595799515277320480429557947658e-17, /* twoPowerIndex2mi[210] */ 
    1.98867486219252293915985766016443087286320281152529e-33, /* twoPowerIndex2lo[210] */ 
  } , 
  { 
    1.77057597406355471392203071445692330598831176757812e+00, /* twoPowerIndex2hi[211] */ 
    5.96179451004055584766584184178983874814969039896383e-17, /* twoPowerIndex2mi[211] */ 
    2.25217410358405709867930003709735313542997798337535e-33, /* twoPowerIndex2lo[211] */ 
  } , 
  { 
    1.77537649252652118825324123463360592722892761230469e+00, /* twoPowerIndex2hi[212] */ 
    6.42973179655657203395602172161574258202382771355994e-17, /* twoPowerIndex2mi[212] */ 
    -3.05903038196122316059732104267589318807211463677414e-33, /* twoPowerIndex2lo[212] */ 
  } , 
  { 
    1.78019002651542446180599199578864499926567077636719e+00, /* twoPowerIndex2hi[213] */ 
    -5.28462728909161736516945207213792976192807478608583e-17, /* twoPowerIndex2mi[213] */ 
    -8.77486215604854126189970187247268663448961942332927e-34, /* twoPowerIndex2lo[213] */ 
  } , 
  { 
    1.78501661131893496481382044294150546193122863769531e+00, /* twoPowerIndex2hi[214] */ 
    1.53304001210313138183913113480738748539708581780129e-17, /* twoPowerIndex2mi[214] */ 
    5.51980832680936081410203965527728574047454546736523e-34, /* twoPowerIndex2lo[214] */ 
  } , 
  { 
    1.78985628232140103754943538660882040858268737792969e+00, /* twoPowerIndex2hi[215] */ 
    -4.15435466068335038727327499723453563952032099924980e-17, /* twoPowerIndex2mi[215] */ 
    6.11515946295708221189397364669019622476882042095523e-35, /* twoPowerIndex2lo[215] */ 
  } , 
  { 
    1.79470907500310716820024481421569362282752990722656e+00, /* twoPowerIndex2hi[216] */ 
    1.82274584279120867697625715862678123206602563412216e-17, /* twoPowerIndex2mi[216] */ 
    1.42176433874694971095041068746172287320972847635154e-33, /* twoPowerIndex2lo[216] */ 
  } , 
  { 
    1.79957502494053511732374772691400721669197082519531e+00, /* twoPowerIndex2hi[217] */ 
    -2.52688923335889795224096886042608995683536858583738e-17, /* twoPowerIndex2mi[217] */ 
    1.44522688753239826542123866099361934109399231372306e-33, /* twoPowerIndex2lo[217] */ 
  } , 
  { 
    1.80445416780662393207990135124418884515762329101562e+00, /* twoPowerIndex2hi[218] */ 
    -5.17722240879331788327618111907586559317876939907178e-17, /* twoPowerIndex2mi[218] */ 
    -3.23967570721982535791533521021663088881060430531174e-34, /* twoPowerIndex2lo[218] */ 
  } , 
  { 
    1.80934653937103195886493267607875168323516845703125e+00, /* twoPowerIndex2hi[219] */ 
    -9.03264140245002968190484653709605673138415565955571e-17, /* twoPowerIndex2mi[219] */ 
    -1.12019787608951203920985462435640152244227583657230e-33, /* twoPowerIndex2lo[219] */ 
  } , 
  { 
    1.81425217550039885594514998956583440303802490234375e+00, /* twoPowerIndex2hi[220] */ 
    -9.96953153892034881983229632097342495877571562964276e-17, /* twoPowerIndex2mi[220] */ 
    -5.86224914377491774994695195482808191103744720514440e-33, /* twoPowerIndex2lo[220] */ 
  } , 
  { 
    1.81917111215860849426917411619797348976135253906250e+00, /* twoPowerIndex2hi[221] */ 
    7.40267690114583888997332201107850297829481646698022e-17, /* twoPowerIndex2mi[221] */ 
    -4.89675321347547219472440109911293831971254102711009e-33, /* twoPowerIndex2lo[221] */ 
  } , 
  { 
    1.82410338540705341259240412910003215074539184570312e+00, /* twoPowerIndex2hi[222] */ 
    -1.01596278622770830649733223898080028655802910502598e-16, /* twoPowerIndex2mi[222] */ 
    4.53871114850207724131140654395208935819981398894467e-34, /* twoPowerIndex2lo[222] */ 
  } , 
  { 
    1.82904903140489727420003873703535646200180053710938e+00, /* twoPowerIndex2hi[223] */ 
    6.88919290883569563696897029598215713285030905189271e-17, /* twoPowerIndex2mi[223] */ 
    3.87648962331697016857882013569485482520267614310710e-33, /* twoPowerIndex2lo[223] */ 
  } , 
  { 
    1.83400808640934243065601094713201746344566345214844e+00, /* twoPowerIndex2hi[224] */ 
    3.28310722424562720351405816760294702167288526703081e-17, /* twoPowerIndex2mi[224] */ 
    -6.42508934795304248095271046696049734574532048424330e-34, /* twoPowerIndex2lo[224] */ 
  } , 
  { 
    1.83898058677589371079363900207681581377983093261719e+00, /* twoPowerIndex2hi[225] */ 
    6.91896974027251194233158929971981865763925505317250e-18, /* twoPowerIndex2mi[225] */ 
    8.15206232016177839312277544008762312093325605950960e-35, /* twoPowerIndex2lo[225] */ 
  } , 
  { 
    1.84396656895862598446456104284152388572692871093750e+00, /* twoPowerIndex2hi[226] */ 
    -5.93974202694996455028254223192510163033537942157969e-17, /* twoPowerIndex2mi[226] */ 
    -1.48362556800548453304632576499694052761575815131607e-33, /* twoPowerIndex2lo[226] */ 
  } , 
  { 
    1.84896606951045083810925007128389552235603332519531e+00, /* twoPowerIndex2hi[227] */ 
    9.02758044626108928815754968893534423196214872648843e-17, /* twoPowerIndex2mi[227] */ 
    3.66962637780002837100397510992219276952101768763175e-33, /* twoPowerIndex2lo[227] */ 
  } , 
  { 
    1.85397912508338547077357816306175664067268371582031e+00, /* twoPowerIndex2hi[228] */ 
    9.76188749072759353840331670682321086158335176176729e-17, /* twoPowerIndex2mi[228] */ 
    4.61481577205566482307976345637533484680898060020057e-33, /* twoPowerIndex2lo[228] */ 
  } , 
  { 
    1.85900577242882047990235605539055541157722473144531e+00, /* twoPowerIndex2hi[229] */ 
    -9.52870546198994068663058182042478513584534522643660e-17, /* twoPowerIndex2mi[229] */ 
    -3.18046180210394448463313927892837392059725438136108e-33, /* twoPowerIndex2lo[229] */ 
  } , 
  { 
    1.86404604839778897940050228498876094818115234375000e+00, /* twoPowerIndex2hi[230] */ 
    6.54091268062057171050111940599879934004515525942762e-17, /* twoPowerIndex2mi[230] */ 
    -5.47450840369931668676283513826314309520282956450186e-33, /* twoPowerIndex2lo[230] */ 
  } , 
  { 
    1.86909998994123860427407635143026709556579589843750e+00, /* twoPowerIndex2hi[231] */ 
    -9.93850521425506708290021081667794428086842804782007e-17, /* twoPowerIndex2mi[231] */ 
    2.01996583148501250135094900859003261161238917514540e-33, /* twoPowerIndex2lo[231] */ 
  } , 
  { 
    1.87416763411029996255763307999586686491966247558594e+00, /* twoPowerIndex2hi[232] */ 
    -6.12276341300414256163658402373731493255704994623650e-17, /* twoPowerIndex2mi[232] */ 
    5.28588559402507397372575432425046614667899080733482e-33, /* twoPowerIndex2lo[232] */ 
  } , 
  { 
    1.87924901805656019426749026024481281638145446777344e+00, /* twoPowerIndex2hi[233] */ 
    -1.62263155578358447798931987572415275848558528109557e-17, /* twoPowerIndex2mi[233] */ 
    9.40055036844163004544204966638003638688147648501487e-34, /* twoPowerIndex2lo[233] */ 
  } , 
  { 
    1.88434417903233453195355195930460467934608459472656e+00, /* twoPowerIndex2hi[234] */ 
    -8.22659312553371090551493304223608514657111026374334e-17, /* twoPowerIndex2mi[234] */ 
    -5.31443494561164967610191190946004049645366520601710e-33, /* twoPowerIndex2lo[234] */ 
  } , 
  { 
    1.88945315439093919351876138534862548112869262695312e+00, /* twoPowerIndex2hi[235] */ 
    -9.00516828505912671790149612791654138076908000967551e-17, /* twoPowerIndex2mi[235] */ 
    4.76098007513107821420081485428133742005900358438723e-33, /* twoPowerIndex2lo[235] */ 
  } , 
  { 
    1.89457598158696560730618330126162618398666381835938e+00, /* twoPowerIndex2hi[236] */ 
    3.40340353521652967060147928999507962708632290832738e-17, /* twoPowerIndex2mi[236] */ 
    1.72475099549343225430579028439403217279441019556785e-33, /* twoPowerIndex2lo[236] */ 
  } , 
  { 
    1.89971269817655530331990121339913457632064819335938e+00, /* twoPowerIndex2hi[237] */ 
    -3.85973976937851432307271295292856183526693379019865e-17, /* twoPowerIndex2mi[237] */ 
    8.54252722580247976290671190391307753063293836872304e-34, /* twoPowerIndex2lo[237] */ 
  } , 
  { 
    1.90486334181767413831209978525293990969657897949219e+00, /* twoPowerIndex2hi[238] */ 
    6.53385751471827862894642310249671518446001303214235e-17, /* twoPowerIndex2mi[238] */ 
    -4.74812640133837504404873359767131188363298319607458e-33, /* twoPowerIndex2lo[238] */ 
  } , 
  { 
    1.91002795027038985153922112658619880676269531250000e+00, /* twoPowerIndex2hi[239] */ 
    -5.90968800674406023685750489615373077589386094387626e-17, /* twoPowerIndex2mi[239] */ 
    1.83214657152134469549465915038517283323758050529819e-33, /* twoPowerIndex2lo[239] */ 
  } , 
  { 
    1.91520656139714740007207183225546032190322875976562e+00, /* twoPowerIndex2hi[240] */ 
    -1.06199460561959626376283195555328606320260702029334e-16, /* twoPowerIndex2mi[240] */ 
    -3.05776975679132548538006102719337626149343902119718e-33, /* twoPowerIndex2lo[240] */ 
  } , 
  { 
    1.92039921316304740273039897147100418806076049804688e+00, /* twoPowerIndex2hi[241] */ 
    7.11668154063031418621133275838618151517201202262489e-17, /* twoPowerIndex2mi[241] */ 
    -4.82668562559464286199698217483008854466173164582353e-33, /* twoPowerIndex2lo[241] */ 
  } , 
  { 
    1.92560594363612502810667592711979523301124572753906e+00, /* twoPowerIndex2hi[242] */ 
    -9.91496376969374092749319194821921356369769258703312e-17, /* twoPowerIndex2mi[242] */ 
    -3.22132452692376239436249260443042416373307145576578e-33, /* twoPowerIndex2lo[242] */ 
  } , 
  { 
    1.93082679098762710623304883483797311782836914062500e+00, /* twoPowerIndex2hi[243] */ 
    6.16714970616910955283771024520843382562539181719792e-17, /* twoPowerIndex2mi[243] */ 
    9.20187048243808720717080369504670367609474211649437e-34, /* twoPowerIndex2lo[243] */ 
  } , 
  { 
    1.93606179349229434727419629780342802405357360839844e+00, /* twoPowerIndex2hi[244] */ 
    1.03323859606763257447769151803649788699571393339738e-16, /* twoPowerIndex2mi[244] */ 
    6.05301367682062275405664830597304146844867569493449e-33, /* twoPowerIndex2lo[244] */ 
  } , 
  { 
    1.94131098952864045159572015109006315469741821289062e+00, /* twoPowerIndex2hi[245] */ 
    -6.63802989162148798984357531389107673024275126550005e-17, /* twoPowerIndex2mi[245] */ 
    -3.84589208047361365184351178085214844173829595098042e-33, /* twoPowerIndex2lo[245] */ 
  } , 
  { 
    1.94657441757923321823398055130382999777793884277344e+00, /* twoPowerIndex2hi[246] */ 
    6.81102234953387718436390433460451017868586507937427e-17, /* twoPowerIndex2mi[246] */ 
    4.00132790381313470943337752360672827257448941559276e-33, /* twoPowerIndex2lo[246] */ 
  } , 
  { 
    1.95185211623097831790119016659446060657501220703125e+00, /* twoPowerIndex2hi[247] */ 
    -2.19901696997935108602521778603883611528020250783493e-17, /* twoPowerIndex2mi[247] */ 
    2.41215894734058348862039105065931631090122373298988e-34, /* twoPowerIndex2lo[247] */ 
  } , 
  { 
    1.95714412417540017941064434126019477844238281250000e+00, /* twoPowerIndex2hi[248] */ 
    8.96076779103666776760155050762912042076490756639488e-17, /* twoPowerIndex2mi[248] */ 
    -9.63267661361827588458686334472185443533033181828620e-34, /* twoPowerIndex2lo[248] */ 
  } , 
  { 
    1.96245048020892731699404976097866892814636230468750e+00, /* twoPowerIndex2hi[249] */ 
    1.09768440009135469492530703072443773737110713005320e-16, /* twoPowerIndex2mi[249] */ 
    2.22935494198572795986893315761753148481994138005007e-33, /* twoPowerIndex2lo[249] */ 
  } , 
  { 
    1.96777122323317588126201371778734028339385986328125e+00, /* twoPowerIndex2hi[250] */ 
    -1.03149280115311315108805777837120874149571671620808e-16, /* twoPowerIndex2mi[250] */ 
    4.19326590499492480228618720550851028485481027931040e-33, /* twoPowerIndex2lo[250] */ 
  } , 
  { 
    1.97310639225523432038755800022045150399208068847656e+00, /* twoPowerIndex2hi[251] */ 
    -7.45161786395603748608029025975637403620995816486529e-18, /* twoPowerIndex2mi[251] */ 
    -5.91616296363099671353015573028401106053667494395426e-34, /* twoPowerIndex2lo[251] */ 
  } , 
  { 
    1.97845602638795092786949680885300040245056152343750e+00, /* twoPowerIndex2hi[252] */ 
    4.03887531092781665749784154795462589642365074083484e-17, /* twoPowerIndex2mi[252] */ 
    3.58120371667786223934924900740488031476290303118010e-34, /* twoPowerIndex2lo[252] */ 
  } , 
  { 
    1.98382016485021939189437034656293690204620361328125e+00, /* twoPowerIndex2hi[253] */ 
    -2.20345441239106265715861919875136617618161805878720e-17, /* twoPowerIndex2mi[253] */ 
    1.30241601884067628906145032934477933888241617967293e-33, /* twoPowerIndex2lo[253] */ 
  } , 
  { 
    1.98919884696726634309982273407513275742530822753906e+00, /* twoPowerIndex2hi[254] */ 
    8.20513263836919941553211296435337826280802285479647e-18, /* twoPowerIndex2mi[254] */ 
    4.55959041696793749483275697431418566719882990414142e-34, /* twoPowerIndex2lo[254] */ 
  } , 
  { 
    1.99459211217094023460560947569319978356361389160156e+00, /* twoPowerIndex2hi[255] */ 
    1.79097103520026450854305804947681496082855314328245e-17, /* twoPowerIndex2mi[255] */ 
    3.33253733318286084576384624967661010994920841819939e-34, /* twoPowerIndex2lo[255] */ 
  } }; 
 


