%%NAME
%%  eppmread  - read PPM-file 
%%
%%SYNOPSIS
%%  [image,colormap]=eppmread(filename)
%%
%%PARAMETER(S)
%%  filename    name of PPM-file
%%  image       image matrix 
%%  colormap    color table 
%% 
% written by Stefan Mueller stefan.mueller@fgan.de 2001
function [image,colormap]= eppmread (filename)
  if (nargin ~= 1)
    usage ('[image,colormap] = eppmread(filename)');
  end

% read ppm-file
  ppmFile=fopen(filename ,'r');
  line= fgetl(ppmFile);
  if      strcmp(line,'P3'); bindata=0; 
  elseif  strcmp(line,'P6'); bindata=1; 
  else error([filename 'does not appear to be a ppm file']);
  end
  line= fgetl(ppmFile);
  skip=1;
  while skip
    if length(line)==0;line= fgetl(ppmFile);
    elseif line(1)=='#';line= fgetl(ppmFile);
    else skip=0;
    end
  end
  imgSize= sscanf( line,'%d %d');
  maxValue= sscanf( fgetl(ppmFile),'%d'); 
  if bindata; [data n]= fread(ppmFile,imgSize(1)*imgSize(2)*3,'uchar');
  else        [data n]= fscanf(ppmFile,'%d',imgSize(1)*imgSize(2)*3);
  end
  fclose(ppmFile);

% generate colormap
  data=reshape(data,3,size(data,1)/3)';
  id=data*[65636;256;1];
  [cmap index]=sort(id);
  change=diff(cmap);
  dIndex=[1;find(change)+1];
  colorId=cmap(dIndex);
  colormap=data(index(dIndex),:)/maxValue;

% generate image 
  dIndex=[dIndex;size(cmap,1)+1];
  for i=1:size(colorId,1)
    data(index(dIndex(i):dIndex(i+1)-1),1)=i;
  end 
  image=reshape(data(:,1),imgSize(1),imgSize(2))'; 
