%%NAME
%%  eimage  - draw image of a matrix 
%%
%%SYNOPSIS
%%  eimage(matrix[,colorMap])
%%
%%PARAMETER(S)
%%  matrix     matrix for image 
%%             each value of the matrix is a row index of the colormap
%%  colorMap   define own colormap  
%% 
%%GLOBAL PARAMETER(S)
%%  eImageDefaultColorMap 
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  eImageFrameVisible
%%  eAxesLineWidth
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function x=eimage(matrix,colorMap)
  if  nargin >2
    usage('eimage(matrix[,colorMap])');
  end
  eglobpar;
  if nargin<2
    colorMap=ecolors(eImageDefaultColorMap); 
  end
  if nargin<1
    [matrix colorMap]=eppmread([ePath 'default.ppm']);
    x=matrix;
  end
  % write title
  etitle;
  eimagexy(eFile,matrix,colorMap,...
           ePlotAreaPos(1)*eFac,ePlotAreaPos(2)*eFac,...
           ePlotAreaWidth*eFac,ePlotAreaHeight*eFac);
  if eImageFrameVisible
    erect(eFile,ePlotAreaPos(1)*eFac,ePlotAreaPos(2)*eFac,...
          ePlotAreaWidth*eFac,ePlotAreaHeight*eFac,...
          eAxesLineWidth*eFac,[0 0 0],0);
  end
