%%NAME
%%  ebitmap  -  transform  the current eps-file to bitmap-file
%%
%%SYNOPSIS
%%  ebitmap([bitmapType[,resolution[,mapFileName[,epsFileName]]]])
%%
%%PARAMETER(S)
%%  bitmapType     bitmap-type
%%                 default: 0
%%                 0 = PNG -format
%%                 1 = JPEG-format 
%%                 2 = TIFF-format 
%%                 3 = PPM-format 
%%                 4 = PCX-format 
%%  resolution     in dpi,resolution of bitmap-file 
%%                 default: 200 
%%  mapFileName    name of bitmap-file
%%                 default: 'eFileName.typeSuffix' 
%%  epsFileName    name of eps-file
%%                 default: 'eFileName' 
%%GLOBAL PARAMETER(S)
%%  eFileName
%%  eGhostscript
%written by stefan.mueller stefan.mueller@fgan.de 2001

function ebitmap(bitmapType,resolution,mapFileName,epsFileName)
  if nargin>4
    usage('ebitmap([bitmapType[,resolution[,mapFileName[,epsFileName]]]])');
  end
  eglobpar;
  if nargin<1
    bitmapType=0;
  end
  if bitmapType==0
    outputFormat='png256';
    suffix='png';
  elseif bitmapType==1
    outputFormat='jpeg';
    suffix='jpg';
  elseif bitmapType==2
    outputFormat='tiff24nc';
    suffix='tif';
  elseif bitmapType==3
    outputFormat='ppmraw';
    suffix='ppm';
  elseif bitmapType==4
    outputFormat='pcx24b';
    suffix='pcx';
  end
  if nargin<2
    resolution=200;
  end
  if nargin<3
    pos=findstr(eFileName,'.eps');
    if length(pos)>0
      mapFileName=[eFileName(1:pos(1)) suffix];
    else
      mapFileName=[eFileName '.' suffix];
    end
  end
  if nargin<4
    epsFileName=eFileName;
  end
  initOk=exist('eGhostsript');
  if initOk
    eFileNameSave=eFileName;
  else
    einit;
    eglobpar;
    if strcmp(eUserUnit,'mm')
      eFac=2.834646;
    elseif strcmp(eUserUnit,'cm')
      eFac=28.34646;
    elseif strcmp(eUserUnit,'inch')
      eFac=72;
    else
      eFac=1;
    end
  end

  headsize=500;
  epsFile=fopen(epsFileName,'r');
  data=fread(epsFile,headsize,'uchar');
  fclose(epsFile);

  head=setstr(data');
  pos=findstr(head,'epsTk');
  if length(pos)<1
    pos=findstr(head,'BoundingBox:')+12;
    win=sscanf(head(pos(1):pos(1)+40),'%f',4);
    win=win/eFac;
    xPos=win(1);
    yPos=win(2);
    width=win(3)-win(1);
    height=win(4)-win(2);
   
    eopen(mapFileName,0,width,height,[0 0]);
    einseps(0,0,epsFileName);
    eclose(1,0);
    epsFileName=mapFileName;
  end

  epsFile=fopen(epsFileName,'r');
  data=fread(epsFile,inf,'uchar');
  fclose(epsFile);
  headsize=500;
  head=setstr(data(1:headsize)');
  pos=findstr(head,'BoundingBox:')+12;
  win=sscanf(head(pos(1):headsize),'%f',4);
  match=sscanf(head(pos(1):headsize),'%s',1);
  pos=findstr(head,match);
  if length(pos)>1
    pos2=findstr(head,'translate')+8;
    data(pos(2):pos2(1))=ones(1,(pos2(1)-pos(2)+1))*32; 
  end
  mapFile=fopen(mapFileName,'w');
  fwrite(mapFile,data,'uchar');
  fclose(mapFile);

  options='-q -dNOPAUSE -dSAFER -dBATCH';
  xPixel=(win(3)-win(1))/72*resolution;
  yPixel=(win(4)-win(2))/72*resolution;
  pixelSize=sprintf('-g%dx%d',fix(xPixel),fix(yPixel));
  resDpi=sprintf('-r%d',resolution);
  device=sprintf('-sDEVICE=%s',outputFormat);
  outFileName=sprintf('-sOutputFile=%s',mapFileName);
  ghostscript=sprintf('%s %s %s %s %s %s %s',...
    eGhostscript,options,pixelSize,resDpi,device,outFileName,mapFileName);
  if exist('matlabpath')~=5
    system(ghostscript);
  else
    unix(ghostscript);
  end
  message=sprintf('%s is written',mapFileName);
  disp(message);
  if initOk
    eFileName=eFileNameSave;
  end

