// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _LocalAnalysis_SurfaceContinuity_HeaderFile
#define _LocalAnalysis_SurfaceContinuity_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _LocalAnalysis_StatusErrorType_HeaderFile
#include <LocalAnalysis_StatusErrorType.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class StdFail_NotDone;
class Geom_Surface;
class Geom2d_Curve;
class GeomLProp_SLProps;



//!          This class gives tools to check local continuity C0 <br>
//!          C1 C2 G1 G2 between  two points situated on two surfaces <br>
class LocalAnalysis_SurfaceContinuity  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!           -u1,v1 are  the parameters of the point on Surf1 <br>
//!           -u2,v2  are  the  parameters of the point on Surf2 <br>
//!           -Order  is the required continuity: <br>
//!            GeomAbs_C0    GeomAbs_C1  GeomAbs_C2 <br>
//!            GeomAbs_G1 GeomAbs_G2 <br>
//! <br>
//!           -EpsNul  is  used to  detect a  a vector with nul <br>
//!           magnitude <br>
//! <br>
//!           -EpsC0 is used for C0  continuity to confuse two <br>
//!            points (in mm) <br>
//! <br>
//!           -EpsC1 is  an angular  tolerance in radians  used <br>
//!            for C1 continuity  to compare the angle between <br>
//!            the first derivatives <br>
//! <br>
//!           -EpsC2 is an   angular tolerance in radians  used <br>
//!           for C2  continuity to  compare the angle  between <br>
//!           the second derivatives <br>
//! <br>
//!           -EpsG1 is an  angular  tolerance in radians  used <br>
//!           for G1  continuity to compare  the angle  between <br>
//!           the  normals <br>
//! <br>
//! <br>
//!           -Percent  : percentage of  curvature variation (unitless) <br>
//!           used for G2 continuity <br>
//! <br>
//!           - Maxlen is the maximum length of Surf1 or Surf2  in <br>
//!           meters used to detect null curvature (in mm) <br>
//! <br>
//! <br>
//! <br>
//!           the constructor computes the quantities  which are <br>
//!           necessary to check the continuity in the following cases: <br>
//! <br>
//!           case  C0 <br>
//!           -------- <br>
//!           - the distance between P1 and P2  with P1=Surf (u1,v1)  and <br>
//!           P2=Surfv2(u2,v2) <br>
//! <br>
//! <br>
//!           case C1 <br>
//!           ------- <br>
//! <br>
//!           - the angle between the first derivatives in u : <br>
//! <br>
//!             dSurf1(u1,v1)               dSurf2(u2,v2) <br>
//!             -----------      and        --------- <br>
//!             du                           du <br>
//! <br>
//!             the angle value is between 0 and PI/2 <br>
//! <br>
//!           - the angle between the first derivatives in v : <br>
//! <br>
//!             dSurf1(u1,v1)               dSurf2(u2,v2) <br>
//!             --------         and         --------- <br>
//!             dv                           dv <br>
//! <br>
//!           - the ratio between  the magnitudes of  the first derivatives  in  u <br>
//!           - the  ratio  between  the magnitudes of the first derivatives in v <br>
//! <br>
//!             the angle value is between  0 and pi/2 <br>
//! <br>
//!           case  C2 <br>
//!           ------- <br>
//!           - the  angle  between the second derivatives in u <br>
//!                2                  2 <br>
//!               d Surf1(u1,v1)    d  Surf2(u2,v2) <br>
//!               ----------        ---------- <br>
//!                2                  2 <br>
//!               d u               d  u <br>
//! <br>
//!          - the ratio between the  magnitudes of the second derivatives in  u <br>
//!          - the  ratio between the  magnitudes of the  second derivatives in v <br>
//! <br>
//!            the angle value is between 0 and PI/2 <br>
//! <br>
//!           case G1 <br>
//!           ------- <br>
//!           -the angle between  the normals  at each point <br>
//!           the angle value is between 0 and PI/2 <br>
//! <br>
//!           case  G2 <br>
//!           ------- <br>
//!           - the maximum  normal curvature gap between the two <br>
//!           points <br>
//! <br>
  Standard_EXPORT   LocalAnalysis_SurfaceContinuity(const Handle(Geom_Surface)& Surf1,const Standard_Real u1,const Standard_Real v1,const Handle(Geom_Surface)& Surf2,const Standard_Real u2,const Standard_Real v2,const GeomAbs_Shape Order,const Standard_Real EpsNul = 0.001,const Standard_Real EpsC0 = 0.001,const Standard_Real EpsC1 = 0.001,const Standard_Real EpsC2 = 0.001,const Standard_Real EpsG1 = 0.001,const Standard_Real Percent = 0.01,const Standard_Real Maxlen = 10000);
  
  Standard_EXPORT   LocalAnalysis_SurfaceContinuity(const Handle(Geom2d_Curve)& curv1,const Handle(Geom2d_Curve)& curv2,const Standard_Real U,const Handle(Geom_Surface)& Surf1,const Handle(Geom_Surface)& Surf2,const GeomAbs_Shape Order,const Standard_Real EpsNul = 0.001,const Standard_Real EpsC0 = 0.001,const Standard_Real EpsC1 = 0.001,const Standard_Real EpsC2 = 0.001,const Standard_Real EpsG1 = 0.001,const Standard_Real Percent = 0.01,const Standard_Real Maxlen = 10000);
  
//! This  constructor  is  used  when  we  want  to compute  many  analysis. <br>
//! After  we  use  the  method  ComputeAnalysis <br>
  Standard_EXPORT   LocalAnalysis_SurfaceContinuity(const Standard_Real EpsNul = 0.001,const Standard_Real EpsC0 = 0.001,const Standard_Real EpsC1 = 0.001,const Standard_Real EpsC2 = 0.001,const Standard_Real EpsG1 = 0.001,const Standard_Real Percent = 0.01,const Standard_Real Maxlen = 10000);
  
  Standard_EXPORT     void ComputeAnalysis(GeomLProp_SLProps& Surf1,GeomLProp_SLProps& Surf2,const GeomAbs_Shape Order) ;
  
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
  Standard_EXPORT     GeomAbs_Shape ContinuityStatus() const;
  
  Standard_EXPORT     LocalAnalysis_StatusErrorType StatusError() const;
  
  Standard_EXPORT     Standard_Real C0Value() const;
  
  Standard_EXPORT     Standard_Real C1UAngle() const;
  
  Standard_EXPORT     Standard_Real C1URatio() const;
  
  Standard_EXPORT     Standard_Real C1VAngle() const;
  
  Standard_EXPORT     Standard_Real C1VRatio() const;
  
  Standard_EXPORT     Standard_Real C2UAngle() const;
  
  Standard_EXPORT     Standard_Real C2URatio() const;
  
  Standard_EXPORT     Standard_Real C2VAngle() const;
  
  Standard_EXPORT     Standard_Real C2VRatio() const;
  
  Standard_EXPORT     Standard_Real G1Angle() const;
  
  Standard_EXPORT     Standard_Real G2CurvatureGap() const;
  
  Standard_EXPORT     Standard_Boolean IsC0() const;
  
  Standard_EXPORT     Standard_Boolean IsC1() const;
  
  Standard_EXPORT     Standard_Boolean IsC2() const;
  
  Standard_EXPORT     Standard_Boolean IsG1() const;
  
  Standard_EXPORT     Standard_Boolean IsG2() const;





protected:





private:

  
  Standard_EXPORT     void SurfC0(const GeomLProp_SLProps& Surf1,const GeomLProp_SLProps& Surf2) ;
  
  Standard_EXPORT     void SurfC1(GeomLProp_SLProps& Surf1,GeomLProp_SLProps& Surf2) ;
  
  Standard_EXPORT     void SurfC2(GeomLProp_SLProps& Surf1,GeomLProp_SLProps& Surf2) ;
  
  Standard_EXPORT     void SurfG1(GeomLProp_SLProps& Surf1,GeomLProp_SLProps& Surf2) ;
  
  Standard_EXPORT     void SurfG2(GeomLProp_SLProps& Surf1,GeomLProp_SLProps& Surf2) ;


Standard_Real myContC0;
Standard_Real myContC1U;
Standard_Real myContC1V;
Standard_Real myContC2U;
Standard_Real myContC2V;
Standard_Real myContG1;
Standard_Real myLambda1U;
Standard_Real myLambda2U;
Standard_Real myLambda1V;
Standard_Real myLambda2V;
Standard_Real myETA1;
Standard_Real myETA2;
Standard_Real myETA;
Standard_Real myZETA1;
Standard_Real myZETA2;
Standard_Real myZETA;
Standard_Real myAlpha;
GeomAbs_Shape myTypeCont;
Standard_Real myepsC0;
Standard_Real myepsnul;
Standard_Real myepsC1;
Standard_Real myepsC2;
Standard_Real myepsG1;
Standard_Real myperce;
Standard_Real mymaxlen;
Standard_Real myGap;
Standard_Boolean myIsDone;
LocalAnalysis_StatusErrorType myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
