/* $Id: nws_db.h,v 1.2 2004/02/12 22:43:27 graziano Exp $ */

#ifndef NWS_DB_H
#define NWS_DB_H


#ifdef __cplusplus
extern "C" {
#endif

/* Largest allowable record size. */
#ifndef MAX_RECORD_SIZE
#	define MAX_RECORD_SIZE 512
#endif

/**
 * Connect to an already existing database named #name#. Returns 1 on
 * success, 0 otherwise.
 */
int
ConnectToNwsDB(	const char *name);

/**
 * Write a record into the database. #name# is the table name to use,
 * #timeout# is the memory timeout, #seq# is the sequence number,
 * #data# is the data to write and #dataLen# is how many char from #data#
 * we write this time.
 * Returns 1 on success, 0 otherwise.
 */
int
WriteNwsDB(	const char *name,
		double timeout,
		double seq,
		const char *data,
		unsigned int dataLen);

/**
 * Ask to read #howMany# records from table #name# into #whereSize#-long
 * #where#, starting from record with sequence number #seq#. It returns
 * #howMany# have been effectively read, and their size (#recSize#). 
 * Returns 1 on success.
 */
int
ReadNwsDB(	const char *name,
		char *where,
		int wanted,
		int whereSize,
		double seq,
		double *timeout,
		double *seqOut,
		int *howMany,
		int *recSize);


/**
 * get a list of pubblicly accessible table for the database. It can
 * returns NULL.
 */
char *
GetTables();

/**
 * check if table #name# is a valid NWS table. Returns 1 on success 0
 * otherwise.
 */
int
CheckTable(const char *name);

#ifdef __cplusplus
}
#endif

#endif
