/* NVTV Philips chip data -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Data tables and routines for the Philips
 *
 */

#include <stddef.h>
#include "data_ph.h"

/* -------- PH -------- NTSC -------- */

/* -------- 640x480 -------- */

/* -------- 800x600 -------- */

/* -------- PH -------- PAL -------- */

/* -------- 640x480 -------- */

/* -------- 800x600 -------- */

/* -------- PH -------- Test -------- */

NVBtRegs bt_pal_test = { /* 640x480, half fl, regular, ofs=0, line=259 */
  fal    : 37,
  lal    : 296,
  pcl    : 1805104,
  yinc   : 3305,
  yskip  : 2048
  yofso  : 66,
  yofse  : 66,
  yiwgto : 3698,
  yiwgte : 626,
};

/* -------- All modes -------- */

NVMode ph_modes [] = {
  {TV_SYSTEM_NTSC, 640, 480, "Small", 13.79, 13.58, 
   &bt_crt_ntsc_small_a, (NVTvRegs *) &bt_ntsc_small_a},
  {TV_SYSTEM_NONE, 0, 0, NULL, 0.0, 0.0, NULL, NULL}
};

/* -------- -------- */

void data_init_ph (NVSystem system, NVTvRegs *r)
{
  switch (system)
  {
    case TV_SYSTEM_NONE:
    case TV_SYSTEM_NTSC:
    case TV_SYSTEM_NTSC_J: 
    case TV_SYSTEM_PAL:
    case TV_SYSTEM_PAL_X:
    case TV_SYSTEM_PAL_60: 
    case TV_SYSTEM_PAL_N:  
    case TV_SYSTEM_PAL_NC: 
    case TV_SYSTEM_PAL_M:  
    case TV_SYSTEM_PAL_M60:  
  }
}

void data_default_ph (NVSettings *s)
{
  s->tv_hoffset = s->mon_hoffset = 0;
  s->tv_voffset = s->mon_voffset = 0;
  s->brightness = 100;
  s->color = 100;
  s->contrast = 100;
  s->saturation = 100;
  s->flicker = 75;
  s->sharpness = 100;
  s->bandwidth = 150;
  s->macrovision = 0;
  s->monochrome = 0;
}

void data_clamp_ph (NVSettings *s)
{
  if (s->tv_hoffset <= -100) s->tv_hoffset = -100;
  if (s->tv_hoffset >=  100) s->tv_hoffset =  100;
  if (s->tv_voffset <= -100) s->tv_voffset = -100;
  if (s->tv_voffset >=  100) s->tv_voffset =  100;
  if (s->mon_hoffset <= -100) s->mon_hoffset = -100;
  if (s->mon_hoffset >=  100) s->mon_hoffset =  100;
  if (s->mon_voffset <= -100) s->mon_voffset = -100;
  if (s->mon_voffset >=  100) s->mon_voffset =  100;
  s->tv_voffset = 0; /* FIXME. Clamp to 0 for now, util 'VTotal magic' */
  if (s->brightness <   0) s->brightness = 0;
  if (s->brightness > 200) s->brightness = 200;
  if (s->color <   0) s->color = 0;
  if (s->color > 200) s->color = 200;
}

void data_setup_ph (NVSettings *s, NVCrtRegs *c, NVTvRegs *r)
{
}

DataFunc ph_func = {
  modes: ph_modes,
  init: data_init_ph, 
  defaults: data_default_ph,
  setup: data_setup_ph, 
  clamp: data_clamp_ph
};

/*

adwhs
adwhe
xofs
xpix
xinc
hlen
fal
lal
pcl
yinc
yskip
yofso
yofse
yiwgto
yiwgte
bsta
fsc /* ntsc_m: 569408543, pal: 705268427 */
bcy
bcu
bcv
gy; 
ccrs; /* cross color reduction */
idel
bs;  /* pal: 33, nstc: 25 */
be;  /* pal: 29, ntsc: 29 */
chps; /* pal: 0x6b, ntsc_m: 0x46 */
gainu; /* 92.5IRE: 118, 100IRE: 125 */
gainv; /* 92.5IRE: 165, 100IRE: 175 */
blckl; /* 140IRE: 58, 143IRE: 51 */
blnnl; /* 140IRE: 64, 143IRE: 53 */
bsta;  /* 92.5IRE/NTSC: 63, 92.5IRE/PAL: 45, 100IRE/NTSC: 67, 100IRE/PAL 47 */
vbs; /* FLAGS for output, needed for CONNECT_CONVERT */
yfil flag;
ygs/scbw/pal/fise

100IRE
92.5IRE + 7.5setup (= bt setup??)

See table A-1 of CX docs for TV System characteristics

NTSC-M, PAL-M and PAL-N have setup (92.5IRE?)



