/* NVTV data -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Common routines for data access
 *
 */

#include <string.h>

#include "debug.h"
#include "data.h"
#include "data_bt.h"
#include "data_ch.h"

int data_clamp (int val, int size, int ticks[])
{
  int i;

  for (i = 0; i <= size; i++) 
    if (i >= size || val <= ticks[i]) break;
  if (i <= 0) return ticks[0];
  if (i >= size) return ticks[size-1];
  if (val <= ticks[i-1] + (ticks[i] - ticks[i-1]) / 2) {
    return ticks[i-1];
  } else {
    return ticks[i];
  }
}

int data_pick (int val, int size, int ticks[])
{
  int i;

  for (i = 0; i < size; i++) if (ticks[i] == val) return i;
  return 0;
}

/* -------- -------- */

/*
 * find mode by size
 */

NVMode *data_find (NVMode *modes, NVSystem system, 
  int res_x, int res_y, char *size)
{
  if (!modes) return NULL;
  while (modes->system != TV_SYSTEM_NONE) {
    if ((res_x < 0 || modes->res_x == res_x) && 
	(res_y < 0 || modes->res_y == res_y) &&
	(system == modes->system) &&
        strcasecmp (modes->size, size) == 0) break;
    modes++;
  }
  if (modes->system != TV_SYSTEM_NONE) {
    DPRINTF ("found mode\n");
    return modes;
  } else {
    DPRINTF ("found no mode\n");
    return NULL;
  }
}

/* -------- -------- */

DataFunc *data_func (NVTvChip chip)
{
  switch (chip) {
    case NV_BROOKTREE: 
    case NV_CONEXANT: 
      return &bt_func;
    case NV_CHRONTEL:  
      return &ch_func; 
    default: 
      return NULL;
  }
}
