/* NVTV direct backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header for direct backend (root and nvdev)
 */

#ifndef _BACK_DIRECT_H
#define _BACK_DIRECT_H

#include "backend.h"

Bool back_root_avail (void);
CardPtr back_root_init (void);

Bool back_nvdev_avail (Bool force);
CardPtr back_nvdev_init (void);

/* back_direct methods */

void bdir_openCard (CardPtr card);
void bdir_closeCard (void);
void bdir_probeChips (void);
void bdir_setChip (ChipPtr chip, Bool init);
void bdir_setSettings (NVSettings *set);
void bdir_getSettings (NVSettings *set);
void bdir_setMode (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv);
void bdir_getMode (NVCrtRegs *crt, NVTvRegs *tv);
void bdir_setModeSettings (int ModeFlags, NVCrtRegs *crt, 
			   NVTvRegs *tv, NVSettings *set);
void bdir_setTestImage (NVTvRegs *tv, NVSettings *set);
long bdir_getStatus (int index);
NVConnect bdir_getConnection (void);
Bool bdir_findBySize (NVSystem system, int xres, int yres, char *size, 
    NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);
Bool bdir_findByOverscan (NVSystem system, int xres, int yres, 
    double hoc, double voc, NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);

#endif /* _BACK_DIRECT_H */

