/* NVTV client backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header for client backend
 */

#ifndef _BACK_CLIENT_H
#define _BACK_CLIENT_H

#include "backend.h"

Bool back_client_avail (void);
CardPtr back_client_init (void);

/* client backend methods */

void bcl_openCard (CardPtr card);
void bcl_closeCard (void);
void bcl_probeChips (void);
void bcl_setChip (ChipPtr chip, Bool init);
void bcl_setSettings (NVSettings *set);
void bcl_getSettings (NVSettings *set);
void bcl_setMode (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv);
void bcl_getMode (NVCrtRegs *crt, NVTvRegs *tv);
void bcl_setModeSettings (int ModeFlags, NVCrtRegs *crt, 
			  NVTvRegs *tv, NVSettings *set);
void bcl_setTestImage (NVTvRegs *tv, NVSettings *set);
long bcl_getStatus (int index);
NVConnect bcl_getConnection (void);
Bool bcl_findBySize (NVSystem system, int xres, int yres, char *size, 
    NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);
Bool bcl_findByOverscan (NVSystem system, int xres, int yres, 
    double hoc, double voc, NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);

#endif /* _BACK_CLIENT_H */

