/* upsfetch.h - prototypes for important functions used when linking

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/* like strerror, but for errors that are related to the UPS code */
const char *upsstrerror (int errnum);

/* get <varname> from <host> and put the reply in <buf> */
int getupsvar (const char *host, const char *varname, char *buf, int buflen);

/* get a list of all variables from <host> and put it in <buf> */
int getupsvarlist (const char *host, char *buf, int buflen);

/* open a tcp connection to <host> and return the fd if successful */
int upsconnect (const char *host);

/* close tcp connection cleanly */
void closeupsfd (int fd);

/* get variable list via open connection <fd> and put it in <buf> */
int getupsvarlistfd (int fd, const char *upsname, char *buf, int buflen);

/* get variable via open connection <fd> and put it in <buf> */
int getupsvarfd (int fd, const char *upsname, const char *varname, char *buf, int buflen);

extern int upserror;

/* send a raw buffer to the ups */
int upssendraw (int fd, const char *cmd);

/* get a raw buffer from the ups */
int upsreadraw (int fd, char *buf, int buflen);

/* errors that can be returned in upserror */

#define UPSF_UNKNOWN         0x1000
#define UPSF_VARNOTSUPP      0x1001
#define UPSF_NOSUCHHOST      0x1002
#define UPSF_SENDFAILURE     0x1003
#define UPSF_RECVFAILURE     0x1004
#define UPSF_SOCKFAILURE     0x1005
#define UPSF_BINDFAILURE     0x1006
#define UPSF_RECVTIMEOUT     0x1007
#define UPSF_NOCOMM1         0x1008
#define UPSF_UNKNOWNUPS      0x1009
#define UPSF_ACCESSDENIED    0x100A
#define UPSF_CONNFAILURE     0x100B
#define UPSF_READERROR       0x100C
#define UPSF_WRITEERROR      0x100D
#define UPSF_INVALIDPW       0x100E
#define UPSF_BADPASSWD       0x100F
#define UPSF_WRONGVAR        0x1010
#define UPSF_UNKNOWNLVL      0x1011
#define UPSF_UNKNOWNCMD      0x1012
#define UPSF_DATASTALE       0x1013
#define UPSF_VARUNKNOWN	     0x1014
#define UPSF_CMDNOTSUPP      0x1015
