/*
 ** Copyright 2004-2007 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <nuclient.h>
#include <QtGui>

#include "systray.h"
#include "auth_dlg.h"
#include "auth_dlg.moc"
#include "systray.h"

/*
 * See http://doc.trolltech.com/4.3/mainwindows-application.html
 */

NuAppAuthDialog::NuAppAuthDialog(QObject* _parent) : QDialog(NULL, Qt::Dialog),
	parent(_parent)
{
	createDialog();

	resize(250, 10);
}

void NuAppAuthDialog::createDialog()
{
	settings.sync();

	// Logo
	QPixmap logo(":/images/bouclier.png");
	QLabel* logo_label = new QLabel();
	logo_label->setPixmap(logo);
	logo_label->setAlignment(Qt::AlignHCenter);

	// Username
	QLabel *usernameLabel = new QLabel( tr("Username"));
	username = new NuEditBox();
	username->setFocus();
	QObject::connect(username, SIGNAL(returnPressed()), this, SLOT(get_user_infos()));
	QObject::connect(username, SIGNAL(escapePressed()), this, SLOT(reject()));

	// Password
	QLabel *passwordLabel = new QLabel( tr("Password"));
	password = new NuEditBox();
	password->setEchoMode(QLineEdit::Password);
	QObject::connect(password, SIGNAL(returnPressed()), this, SLOT(get_user_infos()));
	QObject::connect(password, SIGNAL(escapePressed()), this, SLOT(reject()));

	QVBoxLayout *v_layout = new QVBoxLayout();
	v_layout->addWidget(usernameLabel);
	v_layout->addWidget(username);
	v_layout->addWidget(passwordLabel);
	v_layout->addWidget(password);

	QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Horizontal);
	v_layout->addWidget(buttonBox);

	QHBoxLayout *h_layout = new QHBoxLayout(this);
	h_layout->addWidget(logo_label);
	h_layout->addLayout(v_layout);

	QObject::connect(this, SIGNAL(start_auth(QString, QString)), parent, SLOT(start_auth(QString, QString)));
	QObject::connect(buttonBox, SIGNAL(accepted()), this, SLOT(get_user_infos()));
	QObject::connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

	QIcon icon = QIcon(":/images/nuapplet2-running.png");
	setWindowIcon(icon);
	setWindowTitle(tr("Authentication"));
}

void NuAppAuthDialog::get_user_infos()
{
	settings.setValue("username", username->text());
	settings.sync();
	emit start_auth(username->text(), password->text());
	password->setText("");

	accept();
}

void NuAppAuthDialog::show()
{
	if(settings.value("username").toString() != "")
		password->setFocus();
	username->setText(settings.value("username").toString());
	QDialog::show();
}

