/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "midiimportdialog.h"
#include "localization.h"
#include "resource.h"
#include "mainwindow.h"


NedMidiImportDialog::NedMidiImportDialog(GtkWindow *parent) : m_with_triplets(true), m_with_single_triplets(true),
	m_tempo_change_density(20), m_volume_change_density(20), m_voice_num(4) {
	GtkWidget *dialog;
	GtkWidget *triplet_frame;
	GtkWidget *triplet_vbox;
	GtkWidget *voice_frame;
	GtkWidget *voice_hbox;
	GtkWidget *voice_label;
	GtkWidget *tempo_sensity_frame;
	GtkWidget *volume_sensity_frame;

	dialog = gtk_dialog_new_with_buttons(_("MIDI import"), parent, (GtkDialogFlags) (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
		GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);

	g_signal_connect(dialog, "response", G_CALLBACK (OnClose), (void *) this);

	triplet_frame = gtk_frame_new(_("triplets"));

	triplet_vbox = gtk_vbox_new(FALSE, 2);

	m_with_triplet_box = gtk_check_button_new_with_label(_("triplet recognition"));
	m_with_single_triplets_box = gtk_check_button_new_with_label(_("triplets with rests"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_with_triplet_box), TRUE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_with_single_triplets_box), TRUE);
	g_signal_connect(m_with_triplet_box, "toggled", G_CALLBACK(triplet_modus_changed), (void *) this);
	gtk_box_pack_start(GTK_BOX(triplet_vbox), m_with_triplet_box, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(triplet_vbox), m_with_single_triplets_box, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER(triplet_frame), triplet_vbox);

	voice_frame = gtk_frame_new(_("voices"));

	voice_hbox = gtk_vbox_new(FALSE, 2);

	voice_label = gtk_label_new(_("Number of voices:"));
	m_voice_num_spin_box = gtk_spin_button_new_with_range(1.0, 4.0, 1.0);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(m_voice_num_spin_box), 4.0);

	gtk_box_pack_start(GTK_BOX(voice_hbox), voice_label, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(voice_hbox), m_voice_num_spin_box, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER(voice_frame), voice_hbox);

	tempo_sensity_frame = gtk_frame_new(_("tempo density"));

	m_tempo_change_density_scale = gtk_hscale_new_with_range(0.0, 100.0, 1.0);
	gtk_range_set_value(GTK_RANGE(m_tempo_change_density_scale), 20.0);
	gtk_container_add (GTK_CONTAINER(tempo_sensity_frame), m_tempo_change_density_scale);

	volume_sensity_frame = gtk_frame_new(_("volume density"));

	m_volume_change_density_scale = gtk_hscale_new_with_range(0.0, 100.0, 1.0);
	gtk_range_set_value(GTK_RANGE(m_volume_change_density_scale), 20.0);
	gtk_container_add (GTK_CONTAINER(volume_sensity_frame), m_volume_change_density_scale);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), triplet_frame);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), voice_frame);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), tempo_sensity_frame);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), volume_sensity_frame);
	gtk_widget_show_all (dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));

}

void NedMidiImportDialog::OnClose(GtkDialog *dialog, gint result, gpointer data) {
	NedMidiImportDialog *midi_import_dialog = (NedMidiImportDialog *) data;
	midi_import_dialog->m_with_triplets = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(midi_import_dialog->m_with_triplet_box));
	midi_import_dialog->m_with_single_triplets = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(midi_import_dialog->m_with_single_triplets_box));
	switch (result) {
		case GTK_RESPONSE_ACCEPT:
			midi_import_dialog->m_state = TRUE;
		break;
		default:
			midi_import_dialog->m_state = FALSE;
		break;
	}
	midi_import_dialog->m_tempo_change_density = (int) gtk_range_get_value(GTK_RANGE(midi_import_dialog->m_tempo_change_density_scale));
	midi_import_dialog->m_volume_change_density = (int) gtk_range_get_value(GTK_RANGE(midi_import_dialog->m_volume_change_density_scale));
	midi_import_dialog->m_voice_num = (int) gtk_spin_button_get_value(GTK_SPIN_BUTTON(midi_import_dialog->m_voice_num_spin_box));
	gtk_widget_destroy (GTK_WIDGET(dialog));
}


void NedMidiImportDialog::getValues(bool *state, bool *with_triplets, bool *with_single_triplets, int *voice_count,
	int *tempo_change_density, int *volume_change_density) {
	*state = m_state;
	*with_triplets = m_with_triplets;
	*with_single_triplets = m_with_single_triplets;
	*voice_count = m_voice_num;
	*tempo_change_density = 100.0 - m_tempo_change_density;
	*volume_change_density = 100.0 - m_volume_change_density;
	if (*tempo_change_density < 0) *tempo_change_density = 0;
	if (*tempo_change_density > 100) *tempo_change_density = 100;
	if (*volume_change_density < 0) *volume_change_density = 0;
	if (*volume_change_density > 100) *volume_change_density = 100;
}


void NedMidiImportDialog::triplet_modus_changed (GtkToggleButton *togglebutton, gpointer data) {
	NedMidiImportDialog *the_dialog = (NedMidiImportDialog *) data;
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(the_dialog->m_with_triplet_box))) {
		gtk_widget_set_sensitive(the_dialog->m_with_single_triplets_box, TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(the_dialog->m_with_single_triplets_box), TRUE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(the_dialog->m_with_single_triplets_box), FALSE);
		gtk_widget_set_sensitive(the_dialog->m_with_single_triplets_box, FALSE);
	}
}

