/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 2000 David Baum.
 * All Rights Reserved.
 */

#ifndef __DeclareStmt_h
#define __DeclareStmt_h

#ifndef __Stmt_h
#include "Stmt.h"
#endif

#ifndef __LexLocation_h
#include "LexLocation.h"
#endif

class Expr;
class ScopeStmt;

class DeclareStmt : public ChainStmt
{
public:
					DeclareStmt(int var, const struct LexLocation &loc, int count);
					~DeclareStmt();

	void			SetInitialValue(Expr *e);

	int				GetVar() const		{ return fVar; }
	const LexLocation&	GetLoc() const	{ return fLoc; }
	int				GetCount() const	{ return fCount; }

	void			ComputeNullable() { fNullable = false; }
	void			EmitActual(Bytecode &b);
	Stmt*			Clone(Mapping *b) const;
	
	// Binder is a function object that binds declarations to a scope
	class Binder
	{
	public:
				Binder(ScopeStmt *scope) : fScope(scope) {}
		bool	operator()(Stmt *s);
		
	private:
		ScopeStmt*	fScope;
	};

	friend class Binder;
	
private:
	int				fVar;
	ScopeStmt*		fScope;
	struct LexLocation fLoc;
	int				fCount;
};


#endif
