/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#include "Function.h"
#include "Stmt.h"
#include "Scope.h"

Function::Function()
{
	fBody = 0;
	fName = 0;
	fLocalCount = fLocalNext = 0;
}


Function::~Function()
{
	delete fBody;
}


bool Function::AddArg(const Symbol *name, ArgType type)
{
	Arg a;
	
	for(int i=0; i<fArgs.GetLength(); i++)
	{
		if (fArgs[i].fName == name) return false;
	}
	
	a.fName = name;
	a.fType = type;
	
	fArgs.Append(a);
	return true;
}


void Function::SetBody(Stmt *s)
{
	delete fBody;
	fBody = s;
}


int Function::AllocateVar(const Symbol * /* name */)
{
	int index = fLocalNext++;
	if (fLocalNext > fLocalCount)
		fLocalCount = fLocalNext;
		
	return kLocalVarBase + index;
}


int Function::GetMark() const
{
	return fLocalNext;
}


void Function::SetMark(int mark)
{
	fLocalNext = mark;
}


void Function::PrepareScope(Scope *s)
{
	for(int i=0; i<fArgs.GetLength(); i++)
	{
		int var = kLocalVarBase + fLocalCount++;
		
		switch(fArgs[i].fType)
		{
			case kConstantArg:
				var |= kLocalConstantFlag | kLocalReadOnlyFlag;
				break;
			case kConstRefArg:
				var |= kLocalReadOnlyFlag;
				break;
			case kSensorArg:
				var |= kLocalReadOnlyFlag | kLocalSensorFlag;
				break;
			default:
				// do nothing 
				break;
		}
		
		s->Define(fArgs[i].fName, var);
	}
	
	fLocalNext = fLocalCount;
}
