#ifndef __Error_h
#define __Error_h

enum ErrorCode
{
	kErr_None = 0,
	kErr_Parser,
	kErr_UnterminatedIfdef,
	kErr_UnexpectedElse,
	kErr_UnknownDirective,
	kErr_IncludeNeedsName,
	kErr_FileOpen,
	kErr_SymbolNameNeeded,
	kErr_DefineRedef,
	kErr_DefineArgs,
	kErr_CircularDef,
	kErr_WrongArgCount,
	kErr_CondExpression,
	kErr_UnexpectedEOL,
	kErr_UnbalancedParens,
	
	kErr_SymRedef,
	kErr_NoVarDecl,
	kErr_MaxVars,
	kErr_Undeclared,
	kErr_ConstantNeeded,
	kErr_LValueNeeded,
	
	kErr_UndefinedTask,
	kErr_TooManySubs,
	kErr_TooManyTasks,
	kErr_UnknownInit,
	kErr_UndefinedMain,
	kErr_NoLoop,
	kErr_BadExpression,
	kErr_NoMoreTemps,
	kErr_TempsNotAllowed,
	kErr_NestedSubs,
	kErr_ParamCount,
	kErr_UndefinedFunction,
	kErr_ParamType,
	kErr_UndefinedVar,
	kErr_BadRepeatCount,
	
	// warnings
	kWarn_Base,
	kWarn_IllegalPragma,
	
	
	// deprecated
	kDep_Base,
	kDep_Inline,
	kDep_NoArgList,
	
	kErr_Last
};


class ErrorHandler;
class LexLocation;

class Error
{
public:
	enum
	{
		kMaxErrorMsg = 256
	};
	
			Error(ErrorCode code, int data=0) : fCode(code), fData(data) {}
			Error(ErrorCode code, const char *s) : fCode(code), fData((int)s) {}

	// raising errors
	void	Raise(const LexLocation *loc) const;	// raise error at specified location
	void	RaiseLex() const;						// raise error at current lex location
	
	// useful for error handlers
	ErrorCode	GetCode() const	{ return fCode; }
	int			GetData() const	{ return fData; }
	bool		IsWarning() const;
	bool		IsDeprecated() const;
	void		SPrint(char *str) const;
	
private:
	ErrorCode	fCode;
	int			fData;
};


class ErrorHandler
{
public:
			void	Raise(const Error&e, const LexLocation *loc);
			void	Reset(bool filterDeprecated);
			int		GetCount()	{ return fCount; }

	virtual void	ClearErrors();
	virtual void	AddError(const Error &e, const LexLocation *loc) = 0;

	static ErrorHandler*	Get()	{ return sErrorHandler; }

protected:
			ErrorHandler()	{ sErrorHandler = this; }
private:
	int		fCount;
	bool	fFilterDeprecated;

	static ErrorHandler*	sErrorHandler;
};

#endif
