%if 0%{?rhel} && 0%{?rhel} <= 5 || 0%{?fedora} <= 12
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}
%endif

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:           nordugrid-arc-gangliarc
Version:        1.0.1
Release:        1%{?dist}
Summary:        Ganglia monitoring for ARC services
Group:          Development/Libraries
License:        ASL 2.0
URL:            http://wiki.nordugrid.org/index.php/Gangliarc
Source0:        https://dcameron.web.cern.ch/dcameron/dev/rpmbuild/SOURCES/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires:  python-devel
BuildRequires:  python-setuptools
%if %{use_systemd}
BuildRequires:  systemd-units
%endif

Requires: nordugrid-arc-arex
Requires: ganglia-gmond >= 3.0
Requires: python >= 2.4

%if %{use_systemd}
Requires(post):    systemd-units
Requires(preun):   systemd-units
Requires(postun):  systemd-units
%else
Requires(post):    chkconfig
Requires(preun):   chkconfig
Requires(preun):   initscripts
Requires(postun):  initscripts
%endif

%description
gangliarc provides a way to monitor ARC services through an existing ganglia
installation. Running gangliarc adds various ARC metrics to ganglia which can
then be viewed along with regular ganglia metrics for the ARC host.


%prep
%setup -q

%build
%{__python} -c 'import setuptools; execfile("setup.py")' build

%install
rm -rf %{buildroot}
# /etc/init.d is hard-coded in setup.py so create a symlink to /etc/rc.d/init.d
# before installing
mkdir -p %{buildroot}/etc/rc.d/init.d && ln -s %{buildroot}/etc/rc.d/init.d %{buildroot}/etc/init.d
%{__python} -c 'import setuptools; execfile("setup.py")' install -O1 --skip-build --root %{buildroot}
# remove symlink
rm -f %{buildroot}/etc/init.d

%if %{use_systemd}
rm -rf %{buildroot}/etc/rc.d/init.d
mkdir -p %{buildroot}%{_unitdir}
install -m 644 gangliarc.service %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_datadir}/arc
install -m 755 gangliarc-start %{buildroot}%{_datadir}/arc
%endif

%clean
rm -rf %{buildroot}

%if %{use_systemd}

%post
%systemd_post gangliarc.service

%preun
%systemd_preun gangliarc.service

%postun
%systemd_postun_with_restart gangliarc.service

%else

%post
/sbin/chkconfig --add gangliarc

%preun
if [ $1 -eq 0 ]; then
  /sbin/service gangliarc stop > /dev/null 2>&1
  /sbin/chkconfig --del gangliarc
fi

%postun
if [ $1 -ge 1 ]; then
  /sbin/service gangliarc condrestart > /dev/null 2>&1
fi

%endif

%files
%defattr(-,root,root,-)
%doc README LICENSE NOTICE
%{python_sitelib}/gangliarc.*
%{python_sitelib}/nordugrid_arc_gangliarc-%{version}-py?.?.egg-info
%if %{use_systemd}
%{_unitdir}/gangliarc.service
%{_datadir}/arc/gangliarc-start
%else
%if 0%{?rhel} <= 5 || 0%{?fedora} <= 9
%{_initrddir}/gangliarc
%else
%{_initdir}/gangliarc
%endif
%endif


%changelog
* Mon Sep 05 2016 Anders Waananen <waananen@nbi.dk> - 1.0.1-1
- 1.0.1 Final Release

* Sun Dec 01 2013 Anders Waananen <waananen@nbi.dk> - 1.0.0-1
- 1.0.0 Final release

* Wed Jul 18 2012 David Cameron <d.g.cameron@fys.uio.no> 0.1.0-1
- Initial version
