# unset-value [![NPM version](https://badge.fury.io/js/unset-value.svg)](http://badge.fury.io/js/unset-value)

> Delete nested properties from an object using dot notation.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i unset-value --save
```

## Usage

```js
var unset = require('unset-value');

var obj = {a: {b: {c: 'd', e: 'f'}}};
unset(obj, 'a.b.c');
console.log(obj);
//=> {a: {b: {e: 'f'}}};
```

## Examples

### Updates the object when a property is deleted

```js
var obj = {a: 'b'};
unset(obj, 'a');
console.log(obj);
//=> {}
```

### Returns true when a property is deleted

```js
unset({a: 'b'}, 'a') // true
```

### Returns `true` when a property does not exist

This is consistent with `delete` behavior in that it does not
throw when a property does not exist.

```js
unset({a: {b: {c: 'd'}}}, 'd') // true
```

### delete nested values

```js
var one = {a: {b: {c: 'd'}}};
unset(one, 'a.b');
console.log(one);
//=> {a: {}}

var two = {a: {b: {c: 'd'}}};
unset(two, 'a.b.c');
console.log(two);
//=> {a: {b: {}}}

var three = {a: {b: {c: 'd', e: 'f'}}};
unset(three, 'a.b.c');
console.log(three);
//=> {a: {b: {e: 'f'}}}
```

### throws on invalid args

```js
unset();
// 'expected an object.'
```

## Related projects

* [get-value](https://www.npmjs.com/package/get-value): Use property paths (`  a.b.c`) to get a nested value from an object. | [homepage](https://github.com/jonschlinkert/get-value)
* [get-values](https://www.npmjs.com/package/get-values): Return an array of all values from the given object. | [homepage](https://github.com/jonschlinkert/get-values)
* [omit-value](https://www.npmjs.com/package/omit-value): Omit properties from an object or deeply nested property of an object using object path… [more](https://www.npmjs.com/package/omit-value) | [homepage](https://github.com/jonschlinkert/omit-value)
* [put-value](https://www.npmjs.com/package/put-value): Update only existing values from an object, works with dot notation paths like `  a.b.c` and… [more](https://www.npmjs.com/package/put-value) | [homepage](https://github.com/tunnckocore/put-value#readme)
* [set-value](https://www.npmjs.com/package/set-value): Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/jonschlinkert/set-value)
* [union-value](https://www.npmjs.com/package/union-value): Set an array of unique values as the property of an object. Supports setting deeply… [more](https://www.npmjs.com/package/union-value) | [homepage](https://github.com/jonschlinkert/union-value)
* [upsert-value](https://www.npmjs.com/package/upsert-value): Update or set nested values and any intermediaries with dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/doowb/upsert-value)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/unset-value/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 30, 2015._