# {%= name %} {%= badge("fury") %}

> {%= description %}

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var isExtendable = require('{%= name %}');
```

Returns true if the value is any of the following:

- `array`
- `regexp`
- `plain object`
- `function` 
- `date`
- `error`

## Notes

All objects in JavaScript can have keys, but it's a pain to check for this, since we ether need to verify that the value is not `null` or `undefined` and:

- the value is not a primitive, or
- that the object is an `object`, `function`

Also note that an `extendable` object is not the same as an [extensible object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/isExtensible), which is one that (in es6) is not sealed, frozen, or marked as non-extensible using `preventExtensions`.

## Related projects
{%= related(verbiage.related.list, {remove: name}) %}

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
