## Usage

```js
var brackets = require('expand-brackets');
brackets(string[, options]);
```

**Params**

The main export is a function that takes the following parameters:

- `pattern` **{String}**: the pattern to convert
- `options` **{Object}**: optionally supply an options object
- `returns` **{String}**: returns a string that can be used to create a regex

**Example**

```js
console.log(brackets('[![:lower:]]'));
//=> '[^a-z]'
```

## API
{%= apidocs("index.js") %}


## Options

### options.sourcemap

Generate a source map for the given pattern.

**Example**

```js
var res = brackets('[:alpha:]', {sourcemap: true});

console.log(res.map);
// { version: 3,
//   sources: [ 'brackets' ],
//   names: [],
//   mappings: 'AAAA,MAAS',
//   sourcesContent: [ '[:alpha:]' ] }
```


### POSIX Character classes

The following named POSIX bracket expressions are supported:

- `[:alnum:]`: Alphanumeric characters (`a-zA-Z0-9]`)
- `[:alpha:]`: Alphabetic characters (`a-zA-Z]`)
- `[:blank:]`: Space and tab (`[ t]`)
- `[:digit:]`: Digits (`[0-9]`)
- `[:lower:]`: Lowercase letters (`[a-z]`)
- `[:punct:]`: Punctuation and symbols. (`[!"#$%&'()*+, -./:;<=>?@ [\]^_``{|}~]`)
- `[:upper:]`: Uppercase letters (`[A-Z]`)
- `[:word:]`: Word characters (letters, numbers and underscores) (`[A-Za-z0-9_]`)
- `[:xdigit:]`: Hexadecimal digits (`[A-Fa-f0-9]`)

See [posix-character-classes][] for more details.

**Not supported**

- [equivalence classes][gnu] are not supported
- [POSIX.2 collating symbols][gnu] are not supported

[gnu]: https://www.gnu.org/software/gawk/manual/html_node/Bracket-Expressions.html

## History
{%= changelog("changelog.md") %}
