# -*- coding: ascii -*-
#
#  Copyright (C) 2003-2007 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import sys
import os
import md5
import gc

if 'DISPLAY' in os.environ:
    import gtk

def set_rgba_colormap(widget):
    screen = widget.get_screen()
    try: # XXX
        colormap = screen.get_rgba_colormap()
    except:
        visual = gtk.gdk.visual_get_best_with_depth(32) # RGBA
        if visual is not None:
            colormap = gtk.gdk.Colormap(visual, True)
        else:
            colormap = None
    if colormap is None:
        sys.stderr.write('screen does NOT support alpha.\n')
        colormap = screen.get_rgb_colormap()
    widget.set_colormap(colormap)

def create_blank_pixbuf(width, height):
    pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, width, height)
    pixbuf.fill(0xffffffffL)
    return pixbuf

def create_pixbuf_from_DGP_file(path):
    head, tail = os.path.split(path)
    filename = tail
    m_half = md5.new(filename[:len(filename) / 2]).hexdigest()
    m_full = md5.new(filename).hexdigest()
    tmp = ''.join((m_full, filename))
    key = ''
    j = 0
    for i in range(len(tmp)):
        value = ord(tmp[i]) ^ ord(m_half[j])
        if not value:
            break
        key = ''.join((key, chr(value)))
        j += 1
        if j >= len(m_half):
            j = 0
    key_length = len(key)
    if key_length == 0:
        print ''.join((filename, ' generates a null key.'))
        pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        return pixbuf # not encrypted
    key = ''.join((key[1:], key[0]))
    key_pos = 0
    f = open(path, 'r')
    loader = gtk.gdk.PixbufLoader('png')
    while 1:
        c = f.read(1)
        if c == '':
            break
        loader.write(chr(ord(c) ^ ord(key[key_pos])), 1)
        key_pos += 1
        if key_pos >= key_length:
            key_pos = 0
    f.close()
    pixbuf = loader.get_pixbuf()
    loader.close()
    return pixbuf

def create_pixbuf_from_DDP_file(path):
    f = open(path, 'r')
    buf = f.read()
    f.close()
    key = len(buf) << 2
    loader = gtk.gdk.PixbufLoader('png')
    for i in range(len(buf)):
        key = (key * 0x08088405 + 1) & 0xffffffff
        loader.write(chr((ord(buf[i]) ^ key >> 24) & 0xff), 1)
    pixbuf = loader.get_pixbuf()
    loader.close()
    return pixbuf

def create_pixbuf_from_file(path, is_pnr=1, use_pna=0):
    head, tail = os.path.split(path)
    basename, suffix = os.path.splitext(tail)
    if suffix == '.dgp':
        pixbuf = create_pixbuf_from_DGP_file(path)
    elif suffix == '.ddp':
        pixbuf = create_pixbuf_from_DDP_file(path)
    else:
        pixbuf = gtk.gdk.pixbuf_new_from_file(path)
    if is_pnr:
        array = pixbuf.get_pixels_array()
        if not pixbuf.get_has_alpha():
            r, g, b = array[0][0]
            pixbuf = pixbuf.add_alpha(True, chr(r), chr(g), chr(b))
        else:
            pixels = pixbuf.get_pixels()
            step = pixbuf.get_n_channels()
            assert step == 4 ## RGBA
            rgba = pixels[0:step]
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            for i in range(height):
                for j in range(width):
                    index = (i * width + j) * step
                    if pixels[index:index + step] == rgba:
                        array[i][j][3] = 0 ## RGB"A"
    if use_pna:
        path = os.path.join(head, ''.join((basename, '.pna')))
        if os.path.exists(path):
            assert pixbuf.get_has_alpha()
            pna_pixbuf = gtk.gdk.pixbuf_new_from_file(path)
            pna_array = pna_pixbuf.get_pixels_array()
            assert pna_pixbuf.get_bits_per_sample() / 8 == 1 ## FIXME
            pixbuf_array = pixbuf.get_pixels_array()
            pixbuf_array[:,:,3] = pna_array[:,:,0]
            del pna_pixbuf
            gc.collect()
    return pixbuf

def create_pixmap_from_file(path):
    pixbuf = create_pixbuf_from_file(path)
    pixmap, mask = pixbuf.render_pixmap_and_mask(1)
    del pixbuf
    gc.collect()
    return pixmap, mask
