/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.util.Internal;
import bossa.util.User;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.lang.reflect.Array;

public class SpecialArray
extends ArrayType {
    private static SpecialArray unknownTypeArray;
    private boolean primitive;
    private boolean unknown;
    public static final Method arraycopy;
    private static ClassType wrappedType;
    private Field field;
    private static ClassType objectType;
    private static ArrayType objectArray;
    private Method convertMethod;
    private Method genericConvertMethod;
    private static Method makeMethod;
    private String prefix;

    public static SpecialArray create(Type elements) {
        String prefix = elements instanceof PrimType ? elements.getName() : null;
        Type res = Type.lookupType("[" + elements.getSignature());
        if (res != null && res instanceof SpecialArray) {
            return (SpecialArray)res;
        }
        return new SpecialArray(elements, prefix, false, true);
    }

    public static SpecialArray unknownTypeArray() {
        if (unknownTypeArray == null) {
            unknownTypeArray = new SpecialArray(objectType, null, true, true);
        }
        return unknownTypeArray;
    }

    protected SpecialArray(Type elements) {
        this(elements, elements instanceof PrimType ? elements.getName() : null, false, false);
    }

    private SpecialArray(Type elements, String prefix, boolean unknown, boolean register) {
        super(elements);
        this.unknown = unknown;
        this.primitive = prefix != null;
        this.prefix = prefix;
        if (unknown) {
            this.setSignature("Ljava/lang/Object;");
        }
        this.field = new Field(wrappedType);
        this.field.setName("value");
        this.field.setType(objectType);
        if (register && !unknown) {
            Class<?> c = elements.getReflectClass();
            if (c == null) {
                Internal.warning("Null refclass for " + elements.getName());
            } else {
                if (c == Void.TYPE) {
                    User.error(null, "Arrays cannot contain void values");
                }
                c = Array.newInstance(c, 0).getClass();
                Type.registerTypeForClass(c, this);
            }
            Type.registerTypeForName("[" + elements.getSignature(), this);
        }
    }

    @Override
    public String getInternalName() {
        if (this.unknown) {
            return "java.lang.Object";
        }
        return this.getSignature();
    }

    private void callConvert(CodeAttr code) {
        if (this.convertMethod == null) {
            this.convertMethod = wrappedType.getDeclaredMethod("convert_" + this.prefix, 1);
        }
        code.emitInvokeStatic(this.convertMethod);
    }

    private void callGenericConvert(CodeAttr code) {
        if (this.genericConvertMethod == null) {
            this.genericConvertMethod = this.primitive ? wrappedType.getDeclaredMethod("gconvert_" + this.prefix, 1) : wrappedType.getDeclaredMethod("gconvert", 2);
        }
        code.emitInvokeStatic(this.genericConvertMethod);
    }

    @Override
    public void emitCoerceFrom(Type fromType, CodeAttr code) {
        if (fromType instanceof ArrayType) {
            if (this.unknown) {
                return;
            }
            ArrayType from = (ArrayType)fromType;
            if (this.elements.getSignature().equals(from.elements.getSignature())) {
                return;
            }
            code.emitCheckcast(this);
        } else if (this.isCollectionArray(fromType)) {
            this.emitCoerceFromCollection(code);
        } else {
            this.emitCoerceFromArray(code);
        }
    }

    private boolean isCollectionArray(Type t) {
        String name = t.getName();
        return "java.util.Collection".equals(name) || "java.util.List".equals(name);
    }

    @Override
    public void emitCoerceFromObject(CodeAttr code) {
        Internal.warning("SpecialArray.coerceFrom should probably be called instead of this");
        this.emitCoerceFromArray(code);
    }

    private void emitCoerceFromCollection(CodeAttr code) {
        code.emitCheckcast(wrappedType);
        code.emitGetField(this.field);
        this.emitCoerceFromArray(code);
    }

    private void emitCoerceFromArray(CodeAttr code) {
        if (this.unknown) {
            return;
        }
        Label convert = new Label(code);
        Label end = new Label(code);
        code.emitDup();
        code.emitInstanceof(this);
        code.emitGotoIfIntEqZero(convert);
        code.emitCheckcast(this);
        code.emitGoto(end);
        convert.define(code);
        code.emitCheckcast(objectArray);
        if (this.primitive) {
            this.callConvert(code);
        } else {
            SpecialArray.convertReferenceArray(code, this, this.elements);
        }
        end.define(code);
    }

    private static void convertReferenceArray(CodeAttr code, ArrayType toType, Type elements) {
        code.emitDup();
        code.emitIfNotNull();
        code.emitDup();
        code.emitArrayLength();
        code.pushScope();
        Variable len = code.addLocal(Type.int_type);
        code.emitStore(len);
        code.emitPushInt(0);
        code.emitLoad(len);
        code.emitNewArray(elements);
        Variable dest = code.addLocal(toType);
        code.emitDup();
        code.emitStore(dest);
        code.emitPushInt(0);
        code.emitLoad(len);
        code.emitInvokeStatic(arraycopy);
        code.emitLoad(dest);
        code.emitCheckcast(toType);
        code.popScope();
        code.emitElse();
        code.emitPop(1);
        code.emitPushNull(toType);
        code.emitFi();
    }

    @Override
    public void emitCoerceTo(Type toType, CodeAttr code) {
        if (toType instanceof ArrayType) {
            SpecialArray.coerce(code, this, (ArrayType)toType);
        } else if (toType != objectType) {
            this.emitCoerceToObject(code);
        }
    }

    @Override
    public void emitCoerceToObject(CodeAttr code) {
        SpecialArray.emitCoerceToCollection(code);
    }

    public static void emitCoerceToCollection(CodeAttr code) {
        code.emitInvokeStatic(makeMethod);
    }

    private static void coerce(CodeAttr code, ArrayType from, ArrayType to) {
        if (to == unknownTypeArray) {
            return;
        }
        Type elements = to.getComponentType();
        if (elements instanceof PrimType) {
            SpecialArray.create(elements).callGenericConvert(code);
        } else {
            boolean generic;
            boolean bl = generic = !from.getSignature().startsWith("[L");
            if (generic) {
                code.emitPushString(((ObjectType)elements).getInternalName().replace('/', '.'));
                unknownTypeArray.callGenericConvert(code);
                code.emitCheckcast(to);
            } else {
                SpecialArray.convertReferenceArray(code, to, elements);
            }
        }
    }

    @Override
    public Type getImplementationType() {
        if (this.unknown) {
            return objectType;
        }
        return this;
    }

    @Override
    public boolean isSubtype(Type other) {
        return other instanceof ArrayType && (other == unknownTypeArray || this.elements.isSubtype(((ArrayType)other).getComponentType()));
    }

    @Override
    public boolean isAssignableTo(Type other) {
        if (this == other) {
            return true;
        }
        if (this.unknown) {
            return other == objectType;
        }
        return other == objectType || other instanceof ArrayType && (other == unknownTypeArray || this.elements.isAssignableTo(((ArrayType)other).getComponentType()));
    }

    public static ClassType wrappedType() {
        return wrappedType;
    }

    @Override
    public String toString() {
        if (this.unknown) {
            return "Array with unknown element type";
        }
        return "SpecialArray(" + this.elements + ")";
    }

    static {
        arraycopy = ClassType.make("java.lang.System").getDeclaredMethod("arraycopy", 5);
        wrappedType = ClassType.make("nice.lang.rawArray");
        objectType = ClassType.make("java.lang.Object");
        objectArray = new ArrayType(objectType);
        makeMethod = wrappedType.getDeclaredMethod("make", 1);
    }
}

