/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import mlsub.typing.lowlevel.BitMatrix;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Domain;
import mlsub.typing.lowlevel.DomainVector;
import mlsub.typing.lowlevel.LowlevelSolutionHandler;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;

final class Satisfier {
    private static boolean satisfiable = false;

    private Satisfier() {
    }

    static int[] compileStrategy(BitMatrix C, BitMatrix Ct, int m, int n) {
        int[] strategy = new int[n - m];
        C.topologicalSort(m, strategy);
        return strategy;
    }

    private static void enumerate(int[] strategy, DomainVector domains, BitMatrix C, BitMatrix Ct, BitMatrix R, BitMatrix Rt, int m, int n, BitVector observers, LowlevelSolutionHandler handler) throws LowlevelUnsatisfiable, Satisfiable {
        domains.gfp(R, Rt, C, Ct, strategy);
        boolean isObserver = true;
        int x = domains.chooseDomain(observers);
        if (x < 0) {
            isObserver = false;
            x = domains.chooseDomain();
            if (x < 0) {
                handler.handle(domains);
                throw new Satisfiable();
            }
        }
        Domain dx = (Domain)domains.getDomain(x).clone();
        int a = dx.getLowestSetBit();
        while (a >= 0) {
            block6: {
                DomainVector domainsCopy = (DomainVector)domains.clone();
                try {
                    domainsCopy.getDomain(x).instantiate(a);
                    Satisfier.enumerate(strategy, domainsCopy, C, Ct, R, Rt, m, n, observers, handler);
                }
                catch (LowlevelUnsatisfiable e) {
                }
                catch (Satisfiable e) {
                    if (isObserver) break block6;
                    throw e;
                }
            }
            a = dx.getNextBit(a);
        }
        throw new LowlevelUnsatisfiable();
    }

    private static void enumerate(int[] strategy, DomainVector domains, BitMatrix C, BitMatrix Ct, BitMatrix R, BitMatrix Rt, int m, int n, LowlevelSolutionHandler handler) throws LowlevelUnsatisfiable, Satisfiable {
        domains.gfp(R, Rt, C, Ct, strategy);
        int x = domains.chooseDomain();
        if (x < 0) {
            satisfiable = true;
            if (handler == null) {
                throw new Satisfiable();
            }
            handler.handle(domains);
            throw new LowlevelUnsatisfiable();
        }
        Domain dx = (Domain)domains.getDomain(x).clone();
        int a = dx.getLowestSetBit();
        while (a >= 0) {
            DomainVector domainsCopy = (DomainVector)domains.clone();
            try {
                domainsCopy.getDomain(x).instantiate(a);
                Satisfier.enumerate(strategy, domainsCopy, C, Ct, R, Rt, m, n, handler);
                throw new Satisfiable();
            }
            catch (LowlevelUnsatisfiable _) {
                a = dx.getNextBit(a);
            }
        }
        throw new LowlevelUnsatisfiable();
    }

    static void enumerateSolutions(int[] strategy, DomainVector domains, BitMatrix C, BitMatrix Ct, BitMatrix R, BitMatrix Rt, int m, int n, LowlevelSolutionHandler handler) throws LowlevelUnsatisfiable {
        block3: {
            try {
                satisfiable = false;
                domains.initGfpCardinals();
                Satisfier.enumerate(strategy, domains, C, Ct, R, Rt, m, n, handler);
            }
            catch (Satisfiable e) {
            }
            catch (LowlevelUnsatisfiable e) {
                if (satisfiable) break block3;
                throw e;
            }
        }
    }

    static void enumerateSolutions(int[] strategy, DomainVector domains, BitMatrix C, BitMatrix Ct, BitMatrix R, BitMatrix Rt, int m, int n, BitVector observers, LowlevelSolutionHandler handler) {
        try {
            domains.initGfpCardinals();
            Satisfier.enumerate(strategy, domains, C, Ct, R, Rt, m, n, observers, handler);
        }
        catch (Satisfiable e) {
        }
        catch (LowlevelUnsatisfiable e) {
            // empty catch block
        }
    }

    static void satisfy(int[] strategy, DomainVector domains, BitMatrix C, BitMatrix Ct, BitMatrix R, BitMatrix Rt, int m, int n) throws LowlevelUnsatisfiable {
        try {
            domains.initGfpCardinals();
            Satisfier.enumerate(strategy, domains, C, Ct, R, Rt, m, n, null);
        }
        catch (Satisfiable e) {
            // empty catch block
        }
    }

    private static class Satisfiable
    extends Exception {
        private Satisfiable() {
        }
    }
}

