#ifndef IPNS_RUNFILE_HEADER_H
#define IPNS_RUNFILE_HEADER_H
#include <iostream>
#include <fstream>
using namespace std;

struct TableType {
  int location;
  int size;
};

class Header {
 public:
  Header();
  Header(ifstream *, char *);
  int HistStartAddress();
  int NumOfBlocks();
  int OffsetToFree();
  int VersionNumber();
  short NDet();
  void UserName(char *);
  void RunTitle(char *);
  int RunNum();
  int NextRun();
  void StartDate(char *);
  void StartTime(char *);
  void EndDate(char *);
  void EndTime(char *);
  void ProtStatus(char *);
  void VarToMonitor(char *);
  int PresetMonitorCounts();
  int ElapsedMonitorCounts();
  int NumOfCyclesPreset();
  int NumOfCyclesCompleted();
  int RunAfterFinished();
  int TotalMonitorCounts();
  int DetCalibFile();
  void DetLocUnit(char *);
  void PseudoTimeUnit(char *);
  float SourceToSample();
  float SourceToChopper();
  int ModeratorCalibFile();
  short GroupToMonitor();
  short ChannelToMonitor();
  short NumOfHistograms();
  short NumOfTimeFields();
  short NumOfControl();
  short ControlFlag();
  short ClockShift();
  int TotalChannels();
  int NumOfPulses();
  int SizeOfDataArea();
  int HardwareTMin();
  int HardwareTMax();
  int HardTimeDelay();
  short NumOfX();
  short NumOfY();
  short NumOfWavelengths();
  int MaxWavelength();
  int MinWavelength();
  float Dta();
  float Dtd();
  float Omega();
  float Chi();
  float Phi();
  float XLeft();
  float XRight();
  float YLower();
  float YUpper();
  float XDisplacement();
  float YDisplacement();
  float XLength();
  short AreaChannelWidth();
  short AreaDoubleInterval();
  int AddressOf1DData();
  int AddressOf2DData();
  int EndOfOverflow();
  int Channels1D();
  short NumOfOverflows();
  double ClockPeriod();
  double EnergyIn();
  double EnergyOut();
  short NumOfSeqHist();
  double ProtonCurrent();
  short AreaBinning();
  short Microprocessor();
  short NumOfLockouts();
  int FirstOverflow();
  int ExpNum();
  int FirstRun();
  int LastRun();
  int DefaultRun();
  short SamplePos();
  short NumOfHeadBlocks();
  short OverflowSort();
  double StandardClock();
  double LpsdClock();
  int NumOfElements();
  void IName(char *);
  int MagicNumber();
  TableType GetLpsdDetIDMap();
  TableType GetTimeFieldTable();
  TableType GetDetMapTable();
  TableType GetTimeScaleTable();
  TableType GetTimeShiftTable();
  TableType GetTimeDelayTable();
  TableType GetAreaStartTable();
  TableType GetDetectorAngleTable();
  TableType GetFlightPathTable();
  TableType GetDetectorHeightTable();
  TableType GetDetectorTypeTable();
  TableType GetControlTable();
  TableType GetSeqHistWidthTable();
  TableType GetMessageRegTable();
  TableType GetDiscSetTable();
  TableType GetDetLengthTable();
  TableType GetDetWidthTable();
  TableType GetDetDepthTable();
  TableType GetDetSGMapTable();
  TableType GetDetCoordSysTable();
  TableType GetDetRot1Table();
  TableType GetDetRot2Table();
  TableType GetDetEffTable();
  TableType GetPsdOrderTable();
  TableType GetNumSegs1Table();
  TableType GetNumSegs2Table();
  TableType GetCrateNumTable();
  TableType GetSlotNumTable();
  TableType GetInputNumTable();
  TableType GetDataSourceTable();
  TableType GetMinIDTable();
  
  int getLpsdDetIDMapLoc();
  int getLpsdDetIDMapSize();
  int getTimeFieldTableLoc();
  int getTimeFieldTableSize();
  
  
 private:
  TableType controlParameter;
  TableType detectorMapTable;
  TableType timeFieldTable;
  TableType timeScaleTable;
  TableType timeShiftTable;
  TableType areaStartTable;
  TableType timeDelayTable;
  int histStartAddress;
  int numOfBlocks;
  int offsetToFree;
  int versionNumber;
  TableType detectorAngle;
  TableType flightPath;
  TableType detectorHeight;
  TableType detectorType;
  TableType controlTable;
  TableType seqHistWidth;
  short nDet;
  char userName[21];
  char runTitle[81];
  int runNum;
  int nextRun;
  char startDate[10];
  char startTime[9];
  char endDate[10];
  char endTime[9];
  char protStatus[2];
  char varToMonitor[2];
  int presetMonitorCounts;
  int elapsedMonitorCounts;
  short numOfCyclesPreset;
  short numOfCyclesCompleted;
  int runAfterFinished;
  int totalMonitorCounts;
  int detCalibFile;
  char detLocUnit[2];
  char pseudoTimeUnit[2];
  float sourceToSample;
  float sourceToChopper;
  int moderatorCalibFile;
  short groupToMonitor;
  short channelToMonitor;
  short numOfHistograms;
  short numOfTimeFields;
  short numOfControl;
  short controlFlag;
  short clockShift;
  int totalChannels;
  int numOfPulses;
  int sizeOfDataArea;
  int hardwareTMin;
  int hardwareTMax;
  int hardTimeDelay;
  short numOfX;
  short numOfY;
  short numOfWavelengths;
  int maxWavelength;
  int minWavelength;
  float dta;
  float dtd;
  float omega;
  float chi;
  float phi;
  float xLeft;
  float xRight;
  float yLower;
  float yUpper;
  float xDisplacement;
  float yDisplacement;
  float xLength;
  short areaChannelWidth;
  short areaDoubleInterval;
  int addressOf1DData;
  int addressOf2DData;
  int endOfOverflows;
  int channels1D;
  short numOfOverflows;
  float clockPeriod;
  float energyIn;
  float energyOut ;
  short numOfSeqHist;
  double protonCurrent;
  short areaBinning;
  short microproccessor;
  short numOfLockouts;
  int firstOverflow;
  int expNum;
  int firstRun;
  int lastRun;
  int defaultRun;
  short samplePos;
  short numOfHeadBlocks;
  short overflowSort;
  double standardClock;
  double lpsdClock;
  int numOfElements;
  char iName[5];
  int magicNumber;
  TableType messageRegion;
  TableType discSettings ;
  TableType PSD_IDMap;
  TableType detectorLength;
  TableType detectorWidth;
  TableType detectorDepth;
  TableType detectorSGMap;
  TableType detCoordSys;
  TableType detectorRot1;
  TableType detectorRot2;
  TableType detectorEfficiency;
  TableType psdOrder;
  TableType numSegs1;
  TableType numSegs2;
  TableType crateNum ;
  TableType slotNum;
  TableType inputNum;
  TableType dataSource;
  TableType minID;
  int instrumentType;
  int filterType;
  int sampleEnv;
  int detectorConfig;
  int runType;
  
  
};

#endif
