/*  VER 146  TAB P   $Id: pull.c,v 1.17.2.1 2001/02/14 06:55:40 egil Exp $
 *
 *  pull news      
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: pull.c,v $
 *  Revision 1.17.2.1  2001/02/14 06:55:40  egil
 *  Fixes from Winston Edmond
 *
 *  Revision 1.17  1999/03/15 07:45:13  src
 *  Fix for unused spool
 *
 *  Revision 1.16  1999/03/07 14:58:19  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.15  1999/03/04 17:19:27  src
 *  Fix for removed groups that weren't
 *
 *  Revision 1.14  1998/11/22 08:23:07  src
 *  Added --forget-inactive
 *
 *  Revision 1.13  1998/11/21 19:14:24  src
 *  Added --filter option
 *
 *  Revision 1.12  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.11  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.9  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.8  1998/07/12 09:39:29  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "newsconfig.h"
#include "news.h"

/* BUG: have NNTP timeout function with unlimited line length */

/* 
 *  globals for pull_group
 */

extern long bytes_in_spool; /* external: number of bytes read */
extern long latest_where;   /* external: last article read OK */

/*
 *  for pull() and pull_cleanup()
 */
static int pull_active;
static int pull_anything;
static int removed_groups;             /* number of groups removed */
static FILE *pull_in;
static FILE *pull_tmp;
static char activename[PATH_MAX];
static char active_tmp[PATH_MAX];
static char active_old[PATH_MAX];

/*
 *  pull newsgroup
 *  return false if no point in continuing (i.e. an error occurred)
 */
static int 
pull_group(char *group, long *wherep, int is_new)
{
    int more = 1;
    int first_time = 1;
    long first,last;
    long where;

    where = *wherep;
    if (noaction_opt) {
	/* dummy for testing */
	first = where;
	last = where-1;
	pull_anything = 1;
    } else switch (select_group(group,&first,&last)) {
    case 1:       /* OK */
	break;  
    case 0:       /* no such group - continue */
	++unavailable_groups; 
	return 1;
    default:
	return 0; /* no point in continuing */
    }
    /* BUG: check for consistency?! */
    log_msg(L_DEBUGMORE,"group selected %s, %ld-%ld",group,first,last);

    if (zap_opt || (is_new && zapnew_opt)) {
	/* silently update to latest article */
	log_msg(L_DEBUG,"zap from %d to %ld in %s",where,last+1,group);
	where = last+1;
    } else if (reset_opt) {
	/* fetch all articles */
	where = first;
    } else {
	/* fetch from where we left */
	if (where < 0 || where < first) {
	    log_msg(L_DEBUG,"bumping from %ld to %ld in %s",where,first,group);
	    where = first;
	}
    }

    /*
     *  fetch all articles
     *  where==0 and last==0 is special case for unused spool
     */
    if (where > 0 || last > 0) {
	if (is_new && max_new && where < last+1-max_new) {
	    log_msg(L_DEBUG,"skipping %ld articles due to --maxnew",
						    (last+1-where) - max_new);
	    where = last+1-max_new;
	}
	if (max_articles && where < last+1-max_articles) {
	    log_msg(L_DEBUG,"skipping %ld articles due to --maxart",
						(last+1-where) - max_articles);
	    where = last+1-max_articles;
	}

	latest_where = -1L;
	while (where <= last) {
	    if (!fetch_article(where,first_time,group)) {
		 more = 0;
		 break;
	    }
	    first_time = 0;
	    /* BUG: NOTE that 400 is used for aborting a transfer... */
	    ++where;

	    if (bytes_in_spool > minspool) {
		/* flush spool if too large */
		/* BUG: L_DEBUGMORE */
		log_msg(L_DEBUG,"flushing spool...");
		flush_spool(0);
		bytes_in_spool = 0;
	    }
	}
	/* flush all remaining requests */
	if (!flush_request()) {
	    more = 0;
	}
    }

    /* update article index */
    if (more) {
	/* everything went smoothly */
	*wherep = where;
    } else {
	log_msg(L_DEBUGMORE,"transfer interrupted");
	if (latest_where) {
	    /* this was the last article we retieved */
	    *wherep = latest_where;
	    log_msg(L_DEBUGMORE,"latest article was %ld", latest_where);
	}
    }

    return more;
}

/*
 *  clean up news fetching
 *  NOTE: could be called from a signal handler
 */
void 
pull_cleanup(int urgent)
{
    FILE *f;
    int l_debug = urgent ? L_DEBUG : L_DEBUGMORE;

    if (!pull_active) return;
    pull_active = 0;

    /* finish of spooled batch */
    flush_spool(urgent);

    progtitle("pull: cleanup");
    if ((f = pull_in)) {
	pull_in = 0;
	fclose(f);
    }
    if ((f = pull_tmp)) {
	pull_tmp = 0;
	fclose(pull_tmp);
    }

    /* clean up and update host active */
    if (pull_anything || removed_groups) {
	if (pull_anything) {
	    log_msg(l_debug,"%d group%s contained new articles",
			pull_anything,
			pull_anything==1 ? "":"s");
	}
	if (removed_groups) {
	    log_msg(l_debug,"removed %d group%s",
			removed_groups,
			removed_groups==1 ? "":"s");
	}
	removed_groups =
	pull_anything = 0;

	if (active_old[0]) {
	    log_msg(l_debug,"renaming %s to %s",activename,active_old);
	    unlink(active_old);
	    if (!rename_file(activename,active_old)) exit_cleanup(6);
	}
	log_msg(l_debug,"renaming %s to %s",active_tmp,activename);
	if (!rename_file(active_tmp,activename)) exit_cleanup(6);
    } else {
	log_msg(L_DEBUG,"no news is good news!");
	unlink(active_tmp);
    }
}

/*
 *  pull news 
 */
int
pull(char *spoolname)
{
    char *p,*t;
    char buf[BUFSIZ];
    int skip = 0;
    int n;
    long where,where0;
    char group[BUFSIZ];

    progtitle("pull: opening host active");

    removed_groups =
    pull_anything =
    pull_active = 0;

    /* BUG: add procid or something... */
    /* BUG: make directory if not there ? */

    build_filename(activename,cfg_inhosts,"/",spoolname,NULL);
    build_filename(active_tmp,cfg_inhosts,"/",spoolname,_TMP);
    build_filename(active_old,cfg_inhosts,"/",spoolname,_OLD);

    if (!(pull_in = fopen(activename,"r"))) {
	log_msg(L_ERRno,"can't find a host active \"%s\"",activename);
	active_old[0] = '\0';
	/* but let us continue */
    }
    if (!(pull_tmp = fopen(active_tmp,"w"))) {
	log_msg(L_ERRno,"can't create temporary host active \"%s\"",active_tmp);
	exit_cleanup(6);
    }

    pull_active = 1;
    if (pull_in) {
	while (fgets(buf,BUFSIZ,pull_in)) {
	    p = buf;
	    while (isspace(*p)) ++p;
	    /* BUG: implement include-file mechanism... */
	    /* BUG: or have one rc per server, and let another file
		    decide which groups we'll really use! use the
		    active file as a basis for this file */
	    /* BUG: remove group duplicates... */
	    if (!*p || *p == '#') {
		/* keep comments */
		fputs(buf,pull_tmp);
	    } else if (*p == ':') {
		/* tag */
		++p;
		while (isspace(*p)) ++p;
		t = p;
		if ((p=strchr(t,'\n'))) *p = '\0';
		if ((p=strchr(t,'\t'))) *p = '\0';
		if ((p=strchr(t,' '))) *p = '\0';
		if (end_tag && strcmp(t,end_tag)==0) {
		    log_msg(L_DEBUG,"end at tag \"%s\"",t);
		    skip = 1;
		}
		fprintf(pull_tmp,":%s\n",t);
	    } else {
		char c = '\0';
		/* must be a group name */
		where = 0;
		if ((n=sscanf(p,"%[^ \n\t!:]%c %ld",group,&c,&where)) < 1) {
		    if (!skip) {
			bad_syntax(p,n,1,"host active");
			fprintf(pull_tmp,"#ERR# %s",buf);
		    }
		} else {
		    /* If .newsrc used for in.hosts file, and it says the
		       group isn't being read, treat the group as inactive,
		       even if it appears in 'active'. */
		    unsigned int ignore_this_group;
		    if (c == '!'  ||  c == ':') {
			ignore_this_group = (c == '!');
			/* Assume .newsrc format line: get last number and
			   find the end of (potentially very) long lines */
			t = p + strlen(p) - 1;	/* n>=1 && c ensure t > p */
			while (*t != '\n') {
			    /* .newsrc line (still) longer than BUFSIZ! */
			    while (isdigit(t[-1]))  --t;
			    strcpy (buf,t);
			    n = strlen(buf);
			    p = buf+n;
			    if (!fgets(p,BUFSIZ-n,pull_in)) {
				t = p;  /* EOF instead of EOL */
				break;
			    }
			    t = p + strlen(p) - 1;
			}
			while (isdigit(t[-1]))  --t;
			where = strtol(t,NULL,10);
		    }
		    else ignore_this_group = 0;	 /* false */
		    if (!skip) {
			if (!ignore_this_group && is_active(group)) {
			    unsigned int ok;
			    where0 = where;
			    if (where > 0) {
			        log_msg(L_DEBUGMORE,"pull group %s",group);
				ok = pull_group(group,&where,0);
			    } else {
			        /* treat groups with where = 0 as new groups */
			        log_msg(L_DEBUGMORE,"pull unseen group %s",group);
				ok = pull_group(group,&where,1);
			        if (ok)  ++unseen_groups;
			    }
			    if (!ok) {
				fetch_aborted = 1;
				skip = 1;
				/* continue reading active to clean up things */
			    } else if (where0 != where) {
			        ++pull_anything;
				fflush(pull_tmp);
			    }
			} else {
			    if (forget_inactive) {
				/* delete information about groups
				   no longer in active file */
				log_msg(L_INFO,"inactive group %s removed from host list",
					group);
				group[0] = '\0';
				++removed_groups;
			    } else {
				log_msg(L_DEBUGMORE,"group %s not active or not read",group);
			    }
			}
		    }
		    /* updated count */
		    if (group[0]) fprintf(pull_tmp,"%s %ld\n",group,where);
		}
	    }
	}
	fclose(pull_in);
	pull_in = 0;
    }

    /*
     * fetch the remaining previously unseen groups,
     * adding them to the host active file 
     */
    if (!skip && !end_tag) {
	progtitle("pull: unseen groups");
	while (unseen_active(group)) {
	    where = 0;
	    log_msg(L_DEBUGMORE,"pull unseen group %s",group);
	    if (!pull_group(group,&where,1)) break;
	    fprintf(pull_tmp,"%s %ld\n",group,where);
	    ++unseen_groups;
	    if (where) {
		++pull_anything;
		fflush(pull_tmp);
	    }
	}
    }

    fclose(pull_tmp);
    pull_tmp = 0;

    /* finish of spooled batch */
    pull_cleanup(fetch_aborted);

    pull_active = 0;

    return !fetch_aborted;
}




