/*  VER 013   TAB P   $Id: filter.c,v 1.3.2.1 2001/02/14 06:55:40 egil Exp $
 *
 *  filter interface
 *
 *  uses the highwind interface, which consists of:
 *
 *       each article, complete with headers, is written to the
 *       filter program in NNTP fashion: each line ends with a
 *       cr/lf, and the end is indicated by a full stop
 *
 *       for each line, the filter program returns a status
 *       that is:
 *               335 if the article is accepted
 *               435 if the article is rejected
 *
 *       the filter program is started only once
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: filter.c,v $
 *  Revision 1.3.2.1  2001/02/14 06:55:40  egil
 *  Fixes from Winston Edmond
 *
 *  Revision 1.3  1998/11/23 12:25:48  src
 *  Default window size 10.
 *
 *  Revision 1.2  1998/11/22 18:37:10  src
 *  Filter test.
 *
 *  Revision 1.1  1998/11/22 18:02:32  src
 *  Filtering repaired
 *
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

#include <fcntl.h>

static int filter_open = 0;
static SOCKET_D filter_sock; /* BUG: no... */

#ifndef HAVE_STRTOUL
/*
 *  for systems that doesn't have it, assuming base<=10
 */
long 
strtoul(char *str,char **endptr,int base)
{
    long u = 0L;
    char c;
    while (isspace(*str)) ++str;
    while (isdigit(c = *str++)) u = u*base + c-'0';
    if (endptr)  *endptr = str;
    return u;
}
#endif
	
/*
 *  start the program if not active already
 */
static void
start_filter()
{
    if (filter && !filter_open) {
	progtitle("open filter");
	program_open(filter, &filter_sock);
	filter_open = 1;
    }
}

/*
 *  stop the filter
 */
static void
stop_filter()
{
    if (filter_open) {
	progtitle("stop filter");
	socket_close(&filter_sock);
	filter_open = 0;
	filter = 0; /* no more... */
    }
}

/*
 *  return a status as to whether the message should be removed
 *  based on the message ID
 */
int  
do_filter(char *msgid,char *group)
{
#if 0
    if (!filter) return 0;

    /* ensure filter runs */
    start_filter();

    log_msg(L_DEBUGMORE,"filter message: %s",msgid);

    fprintf(filter_sock.w_str,"Newsgroups: %s\r\nMessage-ID: %s\r\n.\r\n",
					  group,            msgid);
    fflush(filter_sock.w_str);

    return filter_reject(msgid);
#else
    /* BUG: does not currently work... */
    return 0;
#endif
}

/*
 *  return a status as to whether the message should be removed
 *  based on the entire message (sent line by line)
 */
void
filter_line(char *line)
{
    /* ensure filter runs */
    start_filter();

    if (fputs(line,filter_sock.w_str) == EOF) {
	log_msg(L_ERRno,"filter stopped: %s",filter);
	stop_filter();
    }
}

/*
 *  obtain filter status
 *  msgid is just for error reporting
 */
int  
filter_reject(char *msgid)
{
    char *endptr;
    char status[512];

    /* BUG: put_socket() */
    if (fflush(filter_sock.w_str) == EOF
     || ferror(filter_sock.w_str)) {
	log_msg(L_ERRno,"pipe to filter \"%s\" died",filter);
	stop_filter();
	return 0;
    }

    log_msg(L_DEBUGMORE,"get filter status");

    if (!get_socket(status,sizeof(status), &filter_sock)) {
	stop_filter();
	return 0;
    }

    switch (strtoul(status,&endptr,10)) {
    case CONT_XFER:                     /* article OK */
	log_msg(L_DEBUGMORE,"accepting %s",msgid);
	return 0;
    case ERR_GOTIT:                     /* article should be rejected */
	log_msg(L_DEBUG,"filtering %s",msgid);
	return 1;
    default:
	log_msg(L_ERR,"strange filter response: %s",status);
	stop_filter();
	return 0;
    }
}

