/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PlugCA.cpp: implementation of the PlugCA class.
//
//////////////////////////////////////////////////////////////////////

#include "PlugCA.h"
#include <PKI_ERR.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PlugCA::PlugCA(const mString & LibraryPath)
{
	hLib = NULL;
	FreePlugCa = NULL;
	GetPlugCa = NULL;
	clPlugCa = NULL;

	m_LibraryPath = LibraryPath;

	hLib = DSO_load(NULL, LibraryPath.c_str(), DSO_METHOD_dl(), 0);
	if (!hLib)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		throw ExceptionNewPKI();
	}

	GetPlugCa = (GET_PKI_PLUG_CA)DSO_bind_func(hLib, "GetPlugCa");
	if(!GetPlugCa)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_PLUG_LIB);
		ERR_set_error_data("GetPlugCa", ERR_TXT_STRING);
		if(hLib) DSO_free(hLib);
		throw ExceptionNewPKI();
	}
	FreePlugCa = (FREE_PKI_PLUG_CA)DSO_bind_func(hLib, "FreePlugCa");
	if(!FreePlugCa)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_PLUG_LIB);
		ERR_set_error_data("FreePlugCa", ERR_TXT_STRING);
		if(hLib) DSO_free(hLib);
		throw ExceptionNewPKI();
	}
	clPlugCa = GetPlugCa();
	if(!clPlugCa)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		if(hLib) DSO_free(hLib);
		throw ExceptionNewPKI();
	}
}

PlugCA::~PlugCA()
{
	if(clPlugCa && FreePlugCa) FreePlugCa(clPlugCa);
	if(hLib) DSO_free(hLib);
}


const mString & PlugCA::GetLibraryPath()
{
	return m_LibraryPath;
}

bool PlugCA::ValidateOptions(HashTable_String & Options)
{
	return clPlugCa->ValidateOptions(Options);
}

bool PlugCA::OnNewRequest(HashTable_String & Options, const PKI_CERT & CaCert, const SmtpClient & Mailer, const PKI_CSR & Csr)
{
	return clPlugCa->OnNewRequest(Options, CaCert, Mailer, Csr);
}

bool PlugCA::OnNewCertificate(HashTable_String & Options, const PKI_CERT & CaCert, const SmtpClient & Mailer, const PKI_CERT & Cert)
{
	return clPlugCa->OnNewCertificate(Options, CaCert, Mailer, Cert);
}

bool PlugCA::OnNewRevocation(HashTable_String & Options, const PKI_CERT & CaCert, const SmtpClient & Mailer, unsigned long Serial)
{
	return clPlugCa->OnNewRevocation(Options, CaCert, Mailer, Serial);
}

bool PlugCA::OnNewCRL(HashTable_String & Options, const PKI_CERT & CaCert, const SmtpClient & Mailer, const PKI_CRL & Crl)
{
	return clPlugCa->OnNewCRL(Options, CaCert, Mailer, Crl);
}

