/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgSendMail.cpp: implementation of the DlgSendMail class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"

#include "DlgSendMail.h"
#include "dlgs_wdr.h"
#include "clintl.h"

#include <sys/types.h>
#include <sys/stat.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgSendMail, wxDialog)
    EVT_BUTTON(IDC_OK, DlgSendMail::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgSendMail::OnCancel)
    EVT_BUTTON(IDC_BROWSE, DlgSendMail::OnBrowse)
END_EVENT_TABLE()


DlgSendMail::DlgSendMail(wxWindow * wParent, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Send Mail"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_PkiClient = ClientPki;
	DlgSendMail_SetWindow(this);

	CenterOnScreen();
	ShowModal();		
}

DlgSendMail::~DlgSendMail()
{
}

void DlgSendMail::OnOk(wxCommandEvent& event)
{
	wxString Value;
	wxString Value2;
	int pos;
	struct stat mstat;
	FILE * fd;
	char * Buffer;

	
	Value = ((wxTextCtrl *)FindWindow(IDC_SUBJECT))->GetValue();
	if(!Value.Len()) return;
	mail.set_subject(Value.GetData());

	Value = ((wxTextCtrl *)FindWindow(IDC_BODY))->GetValue();
	if(!Value.Len()) return;
	mail.set_body(Value.GetData());

	Value = ((wxTextCtrl *)FindWindow(IDC_ATTACH_FILE))->GetValue();
	if(Value.Len())
	{
		Value2 = ((wxTextCtrl *)FindWindow(IDC_MIME_TYPE))->GetValue();
		if(!Value2.Len())
			return;

		if(stat(Value.GetData(), &mstat) != 0)
		{
			HandleError(strerror(errno), this);
			return;
		}

		if(! (fd = fopen(Value.GetData(), "rb")) )
		{
			HandleError(strerror(errno), this);
			return;
		}

		if(! (Buffer = (char*)malloc(mstat.st_size)) )
		{
			HandleError(strerror(errno), this);
			fclose(fd);
			return;
		}

		if(fread(Buffer, 1, mstat.st_size, fd) != mstat.st_size)
		{
			HandleError(strerror(errno), this);
			fclose(fd);
			free(Buffer);
			return;
		}
		fclose(fd);

		mail.get_attach().Assign((unsigned char*)Buffer, mstat.st_size);


		pos = Value.rfind("\\");
		if(pos != -1)
		{
			Value = Value.Right(Value.Len() - pos - 1);
		}
		else
		{
			pos = Value.rfind("/");
			if(pos != -1)
			{
				Value = Value.Right(Value.Len() - pos - 1);
			}
		}

		mail.set_attachname(Value.GetData());
		mail.set_attachtype(Value2.GetData());
	}
	else
	{
		mail.set_attachname("");
		mail.set_attachtype("");
		mail.get_attach().Clear();
	}


	
	if(((wxCheckBox *)FindWindow(IDC_SIGN))->GetValue())
	{
		mail.set_signmail(1);
	}
	else
	{
		mail.set_signmail(0);
	}

	if(DisplayMessage(this, _("Are you sure to want to send this admin mail?"), wxYES_NO) == wxNO) return;

	DlgMessage Dlg(this);
	Dlg.wShow(_("Sending Administrative E-Mail..."));
	if(!m_PkiClient->AdminSendMail(mail))
	{
		Dlg.wHide();
		HandleError(m_PkiClient->GetError(), this);
		return;
	}

	Dlg.wHide();
	Close(TRUE);
}

void DlgSendMail::OnCancel(wxCommandEvent& event)
{
	Close(TRUE);
}


void DlgSendMail::OnBrowse(wxCommandEvent& event)
{
	wxFileDialog dialog(this, _("Open File"), "", "", _("Any File (*.*)|*.*"), wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		((wxTextCtrl *)FindWindow(IDC_ATTACH_FILE))->SetValue("");
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_ATTACH_FILE))->SetValue(dialog.GetPath());
	}
}

