/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/



// DlgRequestCert.h: interface for the DlgRequestCert class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGREQUESTCERT_H
#define DLGREQUESTCERT_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


#include <stdio.h>
#include <PkiClient.h>

#include "XmlImport.h"

#ifdef _WIN32
	#include "PkiEnroll.h"
#endif


#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>


class DlgRequestCert: public wxDialog 
{
public:
	DlgRequestCert(wxWindow * wParent, const X509_NAME * profile_dn, const EntityConf & conf, XmlRequest * xmlrequest);
	virtual ~DlgRequestCert();

	void OnRaGenPwd(wxCommandEvent &event);
	void OnPkcs10(wxCommandEvent& event);
	void OnLocalKey(wxCommandEvent& event);
	void OnPkcs12(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent &event);
	void OnBrowseP10(wxCommandEvent& event);
	void OnP10Properties(wxCommandEvent& event);
	bool IsOk();
	const NewpkiRequestCert & get_Request();
	void Cancel();

private:
	bool m_IsOk;
	const EntityConf & m_conf;
	HashTable_Dn DN;
	PKI_CSR csr;
	XmlRequest * m_xmlrequest;
	NewpkiRequestCert m_cert_request;
#ifdef _WIN32
	PkiEnroll Enroll;
#endif
	bool m_IsSc;

	DECLARE_EVENT_TABLE()
};

#endif
