/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgError.cpp: implementation of the DlgError class.
//
//////////////////////////////////////////////////////////////////////
#include "DlgError.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgError, wxDialog)
    EVT_BUTTON(IDC_OK, DlgError::OnOk)
END_EVENT_TABLE()


DlgError::DlgError(wxWindow * wParent, const mString & Error):wxDialog(wParent, (wxWindowID)-1, _("Error"), wxDefaultPosition, wxDefaultSize, wxCAPTION | wxSYSTEM_MENU)
{
	wxIconBundle Icons;
	wxIcon ico;

	DlgError_SetWindow(this);
	
	::wxBell();

	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetBackgroundColour(GetBackgroundColour());
	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetValue(Error.c_str());
	((wxTextCtrl *)FindWindow(IDC_ERROR))->SetForegroundColour(*wxRED);

	ico.CopyFromBitmap(DlgError_GetBitmap(IDB_ERROR_BIG));
	Icons.AddIcon(ico);
	ico.CopyFromBitmap(DlgError_GetBitmap(IDB_ERROR_SMALL));
	Icons.AddIcon(ico);

	SetIcons(Icons);

	CenterOnScreen();
	ShowModal();
}

DlgError::~DlgError()
{
}

void DlgError::OnOk(wxCommandEvent& event)
{
	Close(TRUE);
}
