/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgEeAdmin.h: interface for the DlgEeAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGEEADMIN_H
#define DLGEEADMIN_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


#include <PkiClient.h>
#include "DlgGUI.h"

#include "DlgMessage.h"

#include <map>
using namespace std;



class DlgEeAdminListCtrl: public wxListCtrl
{
public:
	~DlgEeAdminListCtrl();
    DlgEeAdminListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos, const wxSize& size, long style);
    void OnItemRightClick(wxListEvent& event);
    void OnItemClick(wxListEvent& event);
	void OnMouseEvent(wxMouseEvent & event);
private:
    DECLARE_EVENT_TABLE()
};




class DlgEeAdmin: public DlgGUI
{
public:
	DlgEeAdmin(wxWindow * wParent, char * EntityName, char * UserName, char * Password, PkiClient * ClientPki);
	virtual ~DlgEeAdmin();

	void OnChangeProfilePwd(wxCommandEvent &event);
	void OnImportCert(wxCommandEvent& event);
	void OnImportP12(wxCommandEvent& event);
	void OnDeletePKCS12(wxCommandEvent& event);
	void OnCertProperties(wxCommandEvent& event);
	void OnP7bProperties(wxCommandEvent& event);
	void OnMouseEvent(wxMouseEvent & event);
	void OnShowNextEntries(wxCommandEvent &event);
	void OnShowPrevEntries(wxCommandEvent &event);
	void OnRefreshEntries(wxCommandEvent &event);
	void OnSendAdminMail(wxCommandEvent& event);
	void OnReload(wxCommandEvent& event);
	void OnItemClick(wxListEvent &event);
	void OnItemRightClick(wxListEvent &event);
	void OnSavePKCS12(wxCommandEvent& event);
private:
	#define IS_PROFILE_ICON(x) (x == PlusProfileIconId || x == EmptyProfileIconId || x == MinusProfileIconId || x == WaitingProfileIconId)
	#define IS_CERT_ICON(x) (x != PlusProfileIconId && x != EmptyProfileIconId && x != MinusProfileIconId && x != WaitingProfileIconId)

	typedef enum en_PROFILE_STATUS
	{
		PROFILE_STATUS_UNKNOWN = 0,
		PROFILE_STATUS_OPENED = 1,
		PROFILE_STATUS_CLOSED = 2
	}PROFILE_STATUS;

	map<unsigned long, PROFILE_STATUS> listStatus;
	bool LoadUSERS(int NumEntries);
	void RefreshDisplay(int NumEntries);
	void ShowPrevEntries(int NumEntries);
	void ShowNextEntries(int NumEntries);
	void PrintUSERS();
	DlgMessage * DlgMsg;
	long CurrentPosition;
	ASN1_BIT_STRING * my_acl;
	mVector<NewpkiEeUser> m_users;


	int LastSelectedEntry;
	int EmptyProfileIconId;
	int PlusProfileIconId;
	int MinusProfileIconId;
	int WaitingProfileIconId;
	int ActMidConnectorIconId;
	int ActEndConnectorIconId;
	int WaitMidConnectorIconId;
	int WaitEndConnectorIconId;
	int RevMidConnectorIconId;
	int RevEndConnectorIconId;
	int SuspMidConnectorIconId;
	int SuspEndConnectorIconId;
	int ErrMidConnectorIconId;
	int ErrEndConnectorIconId;
	int WaitRevMidConnectorIconId;
	int WaitRevEndConnectorIconId;
	int WaitSuspMidConnectorIconId;
	int WaitSuspEndConnectorIconId;


	NewpkiProfileDatasCert * GetSelectedCert(long Item = -1);
	NewpkiEeUser *GetSelectedUser(long Item = -1);
	void DrawCloseProfile(long item, NewpkiEeUser * Profile);
	void DrawOpenProfile(long item, NewpkiEeUser * Profile);
	void MouseMove(long item);
	void MouseDown(long item);
	
	#define MY_EE_CONF_PTR d.ee_conf->d.EE_CONF_PTR

	long lastItem;

	DlgEeAdminListCtrl *m_listCtrl;
	bool ReloadConf();
	wxImageList * m_imageListSmall;
	EntityConf m_EntityConf;
	
	DECLARE_EVENT_TABLE()
};

#endif
