/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgCrlProperties.cpp: implementation of the DlgCrlProperties class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgCrlProperties.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include <openssl/ocsp.h>


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgCrlPropertiesListCtrl, wxListCtrl)
    EVT_LIST_ITEM_SELECTED(IDC_LISTCTRL, DlgCrlPropertiesListCtrl::OnItemClick)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(DlgCrlProperties, wxDialog)
    EVT_BUTTON(IDC_OK, DlgCrlProperties::OnOk)
    EVT_BUTTON(IDC_SAVE_CRL, DlgCrlProperties::OnSaveCrl)
	EVT_NOTEBOOK_PAGE_CHANGED(ID_NOTEBOOK, DlgCrlProperties::OnPageChange)
END_EVENT_TABLE()


DlgCrlProperties * CrlwParent;

void DlgCrlPropertiesListCtrl::OnItemClick(wxListEvent& event)
{
	CrlwParent->OnItemClick(event);
}


DlgCrlProperties::DlgCrlProperties(wxWindow * wParent, const PKI_CRL & crl):wxDialog(wParent, (wxWindowID)-1, _("CRL properties"), wxDefaultPosition),m_crl(crl)
{
	m_imageListSmall = NULL;
	Frames = NULL;

	CrlwParent = this;


	DlgCrlProperties_SetWindow(this);

	Frames = (wxNotebook*)FindWindow(ID_NOTEBOOK);
	m_imageListSmall = new wxImageList(16, 16, TRUE);

	wxIcon ico;
	ico.CopyFromBitmap(DlgCertProperties_GetBitmap(0));
	IconIdValue = m_imageListSmall->Add( ico );
	
	ico.CopyFromBitmap(DlgCertProperties_GetBitmap(1));
	IconIdExtCrit = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgCertProperties_GetBitmap(2));
	IconIdExtNorm = m_imageListSmall->Add( ico );


	InitDatas1();

	CenterOnScreen();
	ShowModal();
}
DlgCrlProperties::~DlgCrlProperties()
{
	void * value;
	long SelectedItem = -1;
	while( (SelectedItem = m_listCtrl->GetNextItem(SelectedItem, wxLIST_NEXT_ALL, wxLIST_STATE_DONTCARE)) != -1)
	{
		value = (void*)m_listCtrl->GetItemData(SelectedItem);
		if(value)
		{
			free(value);
		}
	}
	if(m_imageListSmall) delete m_imageListSmall;
}


void DlgCrlProperties::InitDatas1()
{
	mString datas;
	mString strDatas1;
	mString strDatas2;



	m_listCtrl = ((DlgCrlPropertiesListCtrl *)Frames->FindWindow(IDC_LISTCTRL));
	((wxTextCtrl *)Frames->FindWindow(IDC_VALUE))->SetBackgroundColour(GetBackgroundColour());

	m_listCtrl->ClearAll();
	((wxTextCtrl *)Frames->FindWindow(IDC_VALUE))->SetValue("");


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Field"), wxLIST_FORMAT_LEFT, 135);
	m_listCtrl->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 198);




	// The version
	datas.sprintf("V%ld", m_crl.GetVersion() + 1);
	InserItem(_("Version"), datas.c_str(), datas.c_str(), IconIdValue);


	//The issuer
	strDatas1 = FormatDN(m_crl.GetIssuerDN(), true);
	strDatas2 = FormatDN(m_crl.GetIssuerDN(), false);
	InserItem(_("Issuer"), strDatas1.c_str(), strDatas2.c_str(), IconIdValue);


	//The valid from 
	datas = FormatTime(m_crl.GetStartTime());
	InserItem(_("Effective date"), datas.c_str(), datas.c_str(), IconIdValue);


	//The valid to
	datas = FormatTime(m_crl.GetEndTime());
	InserItem(_("Next update"), datas.c_str(), datas.c_str(), IconIdValue);


	//The signature algo
	datas = m_crl.GetSignatureAlg();
	InserItem(_("Signature algorithm"), datas.c_str(), datas.c_str(), IconIdValue);


	const char * name;
	const char * value;
	long i;
	int IconId;

	for(i=0; i < m_crl.GetExtensions().EntriesCount(); i++)
	{
		name = m_crl.GetExtensions().GetName(i);
		value = m_crl.GetExtensions().Get(i);
		if(!name || ! value) continue;

		if(strstr(value, "critical,"))
		{
			IconId = IconIdExtCrit;
			value += strlen("critical,");
			while(isspace(*value)) value++;
		}
		else
		{
			IconId = IconIdExtNorm;
		}

		InserItem(name, value, value, IconId);
	}
}

void DlgCrlProperties::InitDatas2()
{
	wxString datas;
	long i;
	const REVOCATION_INFO * rev_inf;
	ASN1_ENUMERATED * rtmp;
	X509V3_EXT_METHOD * meth;
	char * reason;

	m_listCtrl2 = ((wxListCtrl *)Frames->FindWindow(IDC_LISTCTRL_SERIAL));
	m_listCtrl2->ClearAll();

	m_listCtrl2->InsertColumn(0, _("Serial number"), wxLIST_FORMAT_LEFT, 70);
	m_listCtrl2->InsertColumn(1, _("Revocation date"), wxLIST_FORMAT_LEFT, 153);
	m_listCtrl2->InsertColumn(2, _("Reason"), wxLIST_FORMAT_LEFT, 110);

	meth = X509V3_EXT_get_nid(NID_crl_reason);


	for(i=0; i< m_crl.RevokedCertsCount(); i++)
	{
		rev_inf = m_crl.GetRevokedCert(i);
		if(!rev_inf) continue;

		datas.sprintf("%ld", rev_inf->serial);

		m_listCtrl2->InsertItem(i, datas, -1);
		m_listCtrl2->SetItem(i, 1, FormatTime(rev_inf->rev_date));
		if(meth && rev_inf->reason != OCSP_REVOKED_STATUS_NOSTATUS)
		{
			rtmp = ASN1_ENUMERATED_new();
			if(!rtmp)
				continue;
			if(!ASN1_ENUMERATED_set(rtmp, rev_inf->reason))
			{
				ASN1_ENUMERATED_free(rtmp);
				continue;
			}
			reason = i2s_ASN1_ENUMERATED_TABLE(meth, rtmp);
			if(!reason)
			{
				m_listCtrl2->SetItem(i, 2, OCSP_crl_reason_str(rev_inf->reason));
			}
			else
			{
				m_listCtrl2->SetItem(i, 2, reason);
				free(reason);
			}
			ASN1_ENUMERATED_free(rtmp);
		}
	}
}

void DlgCrlProperties::OnItemClick(wxListEvent& event)
{
	char * value;
	long SelectedItem;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	value = (char*)m_listCtrl->GetItemData(SelectedItem);

	((wxTextCtrl *)Frames->FindWindow(IDC_VALUE))->SetValue(value);
}

void DlgCrlProperties::OnOk(wxCommandEvent& event)
{
	Close(TRUE);
}

void DlgCrlProperties::OnSaveCrl(wxCommandEvent& event)
{
	wxFileDialog dialog(this, _("Save CRL"), "", "", _("CRL File (*.crl)|*.crl"), wxSAVE|wxOVERWRITE_PROMPT);

	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	FILE * fd;
	fd = fopen(dialog.GetPath() , "wb");
	if(!fd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}	
	if (PEM_write_X509_CRL(fd, m_crl.GetX509_CRL()) <= 0)
	{
		HandleErrorResult(NULL, this, 0);
	}
	fclose(fd);
}

void DlgCrlProperties::InserItem(const char *name, const char *value, const char *datas, int icon_id)
{
	int RowId = m_listCtrl->GetItemCount();

	m_listCtrl->InsertItem(RowId, name, icon_id);
	m_listCtrl->SetItemData(RowId, (long)strdup(datas));
	m_listCtrl->SetItem(RowId, 1, value);
}

void DlgCrlProperties::OnPageChange(wxNotebookEvent &event)
{
	if(!Frames) return;

	switch(Frames->GetSelection())
	{
		case 0:
			InitDatas1();
			break;

		case 1:
			InitDatas2();
			break;
	}
}
