/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigureCA.cpp: implementation of the DlgConfigureCA class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgManageExt.h"
#include "DlgConfigurePlugin.h"
#include "DlgConfigureCA.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgConfigureCA, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigureEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
    EVT_BUTTON(IDC_MANAGE_CERT_EXTS, DlgConfigureCA::OnManageCERTExts)
    EVT_BUTTON(IDC_MANAGE_CRL_EXTS, DlgConfigureCA::OnManageCRLExts)
    EVT_BUTTON(IDC_CONFIGURE_PLUGIN, DlgConfigureCA::OnManageExternalPlug)
//    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
END_EVENT_TABLE()


DlgConfigureCA::DlgConfigureCA(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):DlgConfigureEntity(wParent, entity_cert, ClientPki)
{
	DlgConfigureCA_SetWindow(this);
	
	if(!Init(ENTITY_TYPE_CA))
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();		
}

DlgConfigureCA::~DlgConfigureCA()
{
}

bool DlgConfigureCA::DisplayConf()
{
	wxString value;

	value.sprintf("%ld", m_EntityConf.get_caConf().CA_CONF_PTR.get_crlvaliditydays());
	((wxTextCtrl*)FindWindow(IDC_CRL_DAYS))->SetValue(value);

	value.sprintf("%ld", m_EntityConf.get_caConf().CA_CONF_PTR.get_crlvalidityhours());
	((wxTextCtrl*)FindWindow(IDC_CRL_HOURS))->SetValue(value);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_ALLOW_CSR_EXTS))
		((wxCheckBox *)FindWindow(IDC_ALLOW_CSR_EXTS))->SetValue(TRUE);
	else
		((wxCheckBox *)FindWindow(IDC_ALLOW_CSR_EXTS))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_CSR_EXTS_OVERWRITE))
		((wxCheckBox *)FindWindow(IDC_CSR_EXTS_OVERWRITE))->SetValue(TRUE);
	else
		((wxCheckBox *)FindWindow(IDC_CSR_EXTS_OVERWRITE))->SetValue(FALSE);


	return true;
}

void DlgConfigureCA::OnManageCRLExts(wxCommandEvent &event)
{
	HashTable_String m_Exts;
	
	if(!m_Exts.From_EXTENSION_VALUE(m_EntityConf.get_caConf().CA_CONF_PTR.get_crlexts()))
	{
		return;
	}
	DlgManageExt Dlg(this, &m_Exts);
	if(!Dlg.IsOK()) return;
	if(!m_Exts.To_EXTENSION_VALUE(m_EntityConf.get_caConf().CA_CONF_PTR.get_crlexts()))
	{
		return;
	}
}

void DlgConfigureCA::OnManageCERTExts(wxCommandEvent &event)
{
	HashTable_String m_Exts;
	if(!m_Exts.From_EXTENSION_VALUE(m_EntityConf.get_caConf().CA_CONF_PTR.get_exts()))
	{
		return;
	}
	DlgManageExt Dlg(this, &m_Exts);
	if(!Dlg.IsOK()) return;

	if(!m_Exts.To_EXTENSION_VALUE(m_EntityConf.get_caConf().CA_CONF_PTR.get_exts()))
	{
		return;
	}
}

void DlgConfigureCA::OnManageExternalPlug(wxCommandEvent &event)
{
	HashTable_String m_Options;
	mString LibPath;
	
	if(!m_Options.From_PLUG_OPTION(m_EntityConf.get_caConf().CA_CONF_PTR.get_plugca().get_options()))
	{
		return;
	}

	DlgConfigurePlugin Dlg(this, &m_Options, m_EntityConf.get_caConf().CA_CONF_PTR.get_plugca().get_librarypath());
	if(!Dlg.IsOK()) return;
	LibPath = Dlg.GetLibPath();
	if(!LibPath.size())
		return;

	m_EntityConf.get_caConf().CA_CONF_PTR.get_plugca().set_librarypath(LibPath);
	
	if(!m_Options.To_PLUG_OPTION(m_EntityConf.get_caConf().CA_CONF_PTR.get_plugca().get_options()))
	{
		return;
	}
}

bool DlgConfigureCA::SetConf()
{
	wxString value;
	int int_value;

	value = ((wxTextCtrl*)FindWindow(IDC_CRL_DAYS))->GetValue();
	if(!value.Len())
	{
		return false;
	}
	sscanf(value.GetData(), "%d", &int_value);
	m_EntityConf.get_caConf().CA_CONF_PTR.set_crlvaliditydays(int_value);

		
	value = ((wxTextCtrl*)FindWindow(IDC_CRL_HOURS))->GetValue();
	if(!value.Len())
	{
		return false;
	}
	sscanf(value.GetData(), "%d", &int_value);
	m_EntityConf.get_caConf().CA_CONF_PTR.set_crlvalidityhours(int_value);


	if(((wxCheckBox *)FindWindow(IDC_ALLOW_CSR_EXTS))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_ALLOW_CSR_EXTS, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_ALLOW_CSR_EXTS, 0);

	if(((wxCheckBox *)FindWindow(IDC_CSR_EXTS_OVERWRITE))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_CSR_EXTS_OVERWRITE, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_caConf().CA_CONF_PTR.get_flags(), CA_CSR_EXTS_OVERWRITE, 0);


	return true;
}
