/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddUser.cpp: implementation of the DlgAddUser class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddUser.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddUser, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddUser::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddUser::OnCancel)
END_EVENT_TABLE()

DlgAddUser::DlgAddUser(wxWindow * wParent, const UserEntry & UserInfos):wxDialog(wParent, (wxWindowID)-1, (UserInfos?_("Modify User"):_("Add User")), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_IsOK = false;
	m_UserInfos = UserInfos;

	DlgAddUser_SetWindow(this);


	if(UserInfos)
	{
		((wxTextCtrl *)FindWindow(IDC_USERNAME))->SetValue(UserInfos.get_userInfo().get_name().c_str());
		
		if(UserInfos.get_userInfo().get_activated())
			((wxCheckBox *)FindWindow(IDC_ACTIVE))->SetValue(true);
		else
			((wxCheckBox *)FindWindow(IDC_ACTIVE))->SetValue(false);
		

		if( UserInfos.get_userInfo().get_flags() & USER_FLAGS_EXTERNAL_AUTH )
			((wxCheckBox *)FindWindow(IDC_EXT_AUTH))->SetValue(true);
		else
			((wxCheckBox *)FindWindow(IDC_EXT_AUTH))->SetValue(false);
	}
	else
	{
		((wxCheckBox *)FindWindow(IDC_ACTIVE))->SetValue(true);
	}

	CenterOnScreen();
	ShowModal();
}

DlgAddUser::~DlgAddUser()
{
}

void DlgAddUser::OnOk(wxCommandEvent& event)
{
	wxString username;

	m_UserInfos.get_userInfo().set_activated(((wxCheckBox *)FindWindow(IDC_ACTIVE))->GetValue()?1:0);

	if( ((wxCheckBox *)FindWindow(IDC_EXT_AUTH))->GetValue() )
	{
		m_UserInfos.get_userInfo().set_flags(USER_FLAGS_EXTERNAL_AUTH);
	}
	else
	{
		m_UserInfos.get_userInfo().set_flags(0);
	}

	
	username = ((wxTextCtrl *)FindWindow(IDC_USERNAME))->GetValue();
	if(!username.Len()) return;

	m_UserInfos.get_userInfo().set_name(username.GetData());

	m_IsOK=true;
	Close(TRUE);
}

void DlgAddUser::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

const UserEntry & DlgAddUser::GetUserInfos()
{
	if(!m_IsOK)
		return UserEntry::EmptyInstance;
	else
		return m_UserInfos;

}
