/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPkiEntity.h: interface for the DlgAddPkiEntity class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGADDPKIENTITY_H
#define DLGADDPKIENTITY_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include "wx/app.h"
#include "wx/dialog.h"


#include <stdio.h>
#include "Error.h"
#include <PkiClient.h>
#include <PKI_PKCS12.h>

#include <openssl/pkcs7.h>
#include "DlgAddEntity.h"
#include "PkiUserCreation.h"

class DlgAddPkiEntity: public DlgAddEntity
{
public:
	DlgAddPkiEntity(wxWindow * wParent, PkiClient * ClientPki);
	virtual ~DlgAddPkiEntity();

	void OnSoftwareKey(wxCommandEvent& event);
	void OnHardwareKey(wxCommandEvent& event);

	void OnEngineKeyROOT(wxCommandEvent& event);
	void OnServerKeyROOT(wxCommandEvent& event);
	void OnEngineKeyUSERS(wxCommandEvent& event);
	void OnServerKeyUSERS(wxCommandEvent& event);
	void OnEngineKeyENTITIES(wxCommandEvent& event);
	void OnServerKeyENTITIES(wxCommandEvent& event);
	void OnEngineKeyOCSP(wxCommandEvent& event);
	void OnServerKeyOCSP(wxCommandEvent& event);
	void OnEngineKeyPKI(wxCommandEvent& event);
	void OnServerKeyPKI(wxCommandEvent& event);

	void OnCancel(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);

private:
	PkiUserCreation UserCreation;
	bool FormatCA(GenPrivateKey & genkey, int idc_ch_engine, int idc_val_engine, int idc_ch_server, int idc_val_server);
	wxNotebook * Frames;
	bool SetX509_NAME(X509_NAME * name, HashTable_Dn & Dn);
	DECLARE_EVENT_TABLE()
};

#endif
