/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAcceptPkiCert.cpp: implementation of the DlgAcceptPkiCert class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgCertProperties.h"
#include "DlgAcceptPkiCert.h"
#include "dlgs_wdr.h"
#include "clintl.h"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAcceptPkiCert, wxDialog)
    EVT_BUTTON(ID_YES, DlgAcceptPkiCert::OnYes)
    EVT_BUTTON(ID_NO, DlgAcceptPkiCert::OnNo)
    EVT_BUTTON(IDC_SHOW_CERT, DlgAcceptPkiCert::OnShowCert)
END_EVENT_TABLE()

DlgAcceptPkiCert::DlgAcceptPkiCert(wxWindow * wParent, PKI_CERT * cert):wxDialog(wParent, (wxWindowID)-1, _("NewPKI"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	IsOk = false;
	m_cert = cert;
	
	DlgAcceptPkiCert_SetWindow(this);

	((wxStaticText *)FindWindow(IDC_LEGEND))->SetLabel(_("The PKI SSL certificate is not trusted.\nDo you want to trust it ?"));

	CenterOnScreen();
	ShowModal();
}

DlgAcceptPkiCert::~DlgAcceptPkiCert()
{
}

void DlgAcceptPkiCert::OnYes(wxCommandEvent& event)
{
	IsOk = true;
	Close(TRUE);
}

void DlgAcceptPkiCert::OnNo(wxCommandEvent& event)
{
	IsOk = false;
	Close(TRUE);
}

void DlgAcceptPkiCert::OnShowCert(wxCommandEvent& event)
{
	DlgCertProperties Dlg(this, *m_cert);
}


bool DlgAcceptPkiCert::IsAccepted()
{
	return IsOk;
}
